/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.v2.description;

import com.netflix.spinnaker.clouddriver.kubernetes.v2.artifact.KubernetesUnversionedArtifactConverter;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.artifact.KubernetesVersionedArtifactConverter;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.KubernetesResourceProperties;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.KubernetesSpinnakerKindMap;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesKind;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.op.handler.KubernetesHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class KubernetesResourcePropertyRegistry {
    private final ConcurrentHashMap<KubernetesKind, KubernetesResourceProperties> globalProperties = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, ConcurrentHashMap<KubernetesKind, KubernetesResourceProperties>> accountProperties = new ConcurrentHashMap();

    @Autowired
    public KubernetesResourcePropertyRegistry(List<KubernetesHandler> handlers, KubernetesSpinnakerKindMap kindMap) {
        for (KubernetesHandler handler : handlers) {
            KubernetesResourceProperties properties = KubernetesResourceProperties.builder().handler(handler).versioned(handler.versioned()).versionedConverter(new KubernetesVersionedArtifactConverter()).unversionedConverter(new KubernetesUnversionedArtifactConverter()).build();
            kindMap.addRelationship(handler.spinnakerKind(), handler.kind());
            this.put(handler.kind(), properties);
        }
    }

    public KubernetesResourceProperties get(String account, KubernetesKind kind) {
        ConcurrentHashMap<KubernetesKind, KubernetesResourceProperties> propertyMap = this.accountProperties.get(account);
        KubernetesResourceProperties properties = null;
        if (!kind.isRegistered()) {
            return this.globalProperties.get(KubernetesKind.NONE);
        }
        if (propertyMap != null) {
            properties = propertyMap.get(kind);
        }
        if (properties == null) {
            properties = this.globalProperties.get(kind);
        }
        return properties;
    }

    private void put(KubernetesKind kind, KubernetesResourceProperties properties) {
        this.globalProperties.put(kind, properties);
    }

    public void registerAccountProperty(String account, KubernetesResourceProperties properties) {
        ConcurrentHashMap<KubernetesKind, KubernetesResourceProperties> propertyMap = this.accountProperties.get(account);
        if (propertyMap == null) {
            propertyMap = new ConcurrentHashMap();
        }
        propertyMap.put(properties.getHandler().kind(), properties);
        this.accountProperties.put(account, propertyMap);
    }

    public Collection<KubernetesResourceProperties> values() {
        ArrayList<KubernetesResourceProperties> result = new ArrayList<KubernetesResourceProperties>(this.globalProperties.values());
        result.addAll(this.accountProperties.values().stream().map(ConcurrentHashMap::values).flatMap(Collection::stream).collect(Collectors.toList()));
        return result;
    }
}

