/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.v2.description;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesKind;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class KubernetesSpinnakerKindMap {
    private Map<SpinnakerKind, Set<KubernetesKind>> spinnakerToKubernetes = new HashMap<SpinnakerKind, Set<KubernetesKind>>();
    private Map<KubernetesKind, SpinnakerKind> kubernetesToSpinnaker = new HashMap<KubernetesKind, SpinnakerKind>();

    void addRelationship(SpinnakerKind spinnakerKind, KubernetesKind kubernetesKind) {
        Set<KubernetesKind> kinds = this.spinnakerToKubernetes.get((Object)spinnakerKind);
        if (kinds == null) {
            kinds = new HashSet<KubernetesKind>();
        }
        kinds.add(kubernetesKind);
        this.spinnakerToKubernetes.put(spinnakerKind, kinds);
        this.kubernetesToSpinnaker.put(kubernetesKind, spinnakerKind);
    }

    public SpinnakerKind translateKubernetesKind(KubernetesKind kubernetesKind) {
        return this.kubernetesToSpinnaker.getOrDefault(kubernetesKind, SpinnakerKind.UNCLASSIFIED);
    }

    public Set<KubernetesKind> translateSpinnakerKind(SpinnakerKind spinnakerKind) {
        return this.spinnakerToKubernetes.get((Object)spinnakerKind);
    }

    public Set<KubernetesKind> allKubernetesKinds() {
        return this.kubernetesToSpinnaker.keySet();
    }

    public Map<String, String> kubernetesToSpinnakerKindStringMap() {
        return this.kubernetesToSpinnaker.entrySet().stream().filter(x -> x.getValue() != SpinnakerKind.UNCLASSIFIED && x.getKey() != KubernetesKind.NONE).collect(Collectors.toMap(x -> ((KubernetesKind)x.getKey()).toString(), x -> ((SpinnakerKind)((Object)((Object)x.getValue()))).toString()));
    }

    public static enum SpinnakerKind {
        INSTANCES("instances"),
        CONFIGS("configs"),
        SERVER_GROUPS("serverGroups"),
        LOAD_BALANCERS("loadBalancers"),
        SECURITY_GROUPS("securityGroups"),
        SERVER_GROUP_MANAGERS("serverGroupManagers"),
        UNCLASSIFIED("unclassified");

        private final String id;

        private SpinnakerKind(String id) {
            this.id = id;
        }

        public String toString() {
            return this.id;
        }

        @JsonCreator
        public static SpinnakerKind fromString(String name) {
            return Arrays.stream(SpinnakerKind.values()).filter(k -> k.toString().equalsIgnoreCase(name)).findFirst().orElse(UNCLASSIFIED);
        }
    }
}

