/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.netflix.spinnaker.clouddriver.kubernetes.description.KubernetesAtomicOperationDescription;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.KubernetesCoordinates;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesKind;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesManifest;
import org.apache.commons.lang3.tuple.Pair;

public class KubernetesManifestOperationDescription
extends KubernetesAtomicOperationDescription {
    private String manifestName;
    private String location;

    @JsonIgnore
    public KubernetesCoordinates getPointCoordinates() {
        Pair<KubernetesKind, String> parsedName = KubernetesManifest.fromFullResourceName(this.manifestName);
        return KubernetesCoordinates.builder().namespace(this.location).kind((KubernetesKind)parsedName.getLeft()).name((String)parsedName.getRight()).build();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KubernetesManifestOperationDescription)) {
            return false;
        }
        KubernetesManifestOperationDescription other = (KubernetesManifestOperationDescription)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$manifestName = this.getManifestName();
        String other$manifestName = other.getManifestName();
        if (this$manifestName == null ? other$manifestName != null : !this$manifestName.equals(other$manifestName)) {
            return false;
        }
        String this$location = this.getLocation();
        String other$location = other.getLocation();
        return !(this$location == null ? other$location != null : !this$location.equals(other$location));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof KubernetesManifestOperationDescription;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $manifestName = this.getManifestName();
        result = result * 59 + ($manifestName == null ? 43 : $manifestName.hashCode());
        String $location = this.getLocation();
        result = result * 59 + ($location == null ? 43 : $location.hashCode());
        return result;
    }

    public String getManifestName() {
        return this.manifestName;
    }

    public String getLocation() {
        return this.location;
    }

    public KubernetesManifestOperationDescription setManifestName(String manifestName) {
        this.manifestName = manifestName;
        return this;
    }

    public KubernetesManifestOperationDescription setLocation(String location) {
        this.location = location;
        return this;
    }

    @Override
    public String toString() {
        return "KubernetesManifestOperationDescription(manifestName=" + this.getManifestName() + ", location=" + this.getLocation() + ")";
    }
}

