/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.artifact;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import com.jayway.jsonpath.Criteria;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.Filter;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.internal.filter.ValueNode;
import com.netflix.spinnaker.clouddriver.artifacts.kubernetes.KubernetesArtifactType;
import com.netflix.spinnaker.kork.annotations.NonnullByDefault;
import com.netflix.spinnaker.kork.artifacts.model.Artifact;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonnullByDefault
public final class Replacer {
    private static final Logger log = LoggerFactory.getLogger(Replacer.class);
    private final KubernetesArtifactType type;
    private final JsonPath findPath;
    private final Function<Artifact, JsonPath> replacePathSupplier;
    private final Function<String, String> nameFromReference;
    private static final Replacer DOCKER_IMAGE = Replacer.builder().path("$..spec.template.spec['containers', 'initContainers'].[?].image").replacePathFromPlaceholder("image").nameFromReference(ref -> {
        int atIndex = ref.indexOf(64);
        if (atIndex >= 0) {
            return ref.substring(0, atIndex);
        }
        int lastColonIndex = ref.lastIndexOf(58);
        if (lastColonIndex >= 0) {
            return ref.substring(0, lastColonIndex);
        }
        return ref;
    }).type(KubernetesArtifactType.DockerImage).build();
    private static final Replacer POD_DOCKER_IMAGE = Replacer.builder().path("$.spec.containers.[?].image").replacePathFromPlaceholder("image").type(KubernetesArtifactType.DockerImage).build();
    private static final Replacer CONFIG_MAP_VOLUME = Replacer.builder().path("$..spec.template.spec.volumes.[?].configMap.name").replacePathFromPlaceholder("configMap.name").type(KubernetesArtifactType.ConfigMap).build();
    private static final Replacer SECRET_VOLUME = Replacer.builder().path("$..spec.template.spec.volumes.[?].secret.secretName").replacePathFromPlaceholder("secret.secretName").type(KubernetesArtifactType.Secret).build();
    private static final Replacer CONFIG_MAP_PROJECTED_VOLUME = Replacer.builder().path("$..spec.template.spec.volumes.*.projected.sources.[?].configMap.name").replacePathFromPlaceholder("configMap.name").type(KubernetesArtifactType.ConfigMap).build();
    private static final Replacer SECRET_PROJECTED_VOLUME = Replacer.builder().path("$..spec.template.spec.volumes.*.projected.sources.[?].secret.name").replacePathFromPlaceholder("secret.name").type(KubernetesArtifactType.Secret).build();
    private static final Replacer CONFIG_MAP_KEY_VALUE = Replacer.builder().path("$..spec.template.spec['containers', 'initContainers'].*.env.[?].valueFrom.configMapKeyRef.name").replacePathFromPlaceholder("valueFrom.configMapKeyRef.name").type(KubernetesArtifactType.ConfigMap).build();
    private static final Replacer SECRET_KEY_VALUE = Replacer.builder().path("$..spec.template.spec['containers', 'initContainers'].*.env.[?].valueFrom.secretKeyRef.name").replacePathFromPlaceholder("valueFrom.secretKeyRef.name").type(KubernetesArtifactType.Secret).build();
    private static final Replacer CONFIG_MAP_ENV = Replacer.builder().path("$..spec.template.spec['containers', 'initContainers'].*.envFrom.[?].configMapRef.name").replacePathFromPlaceholder("configMapRef.name").type(KubernetesArtifactType.ConfigMap).build();
    private static final Replacer SECRET_ENV = Replacer.builder().path("$..spec.template.spec['containers', 'initContainers'].*.envFrom.[?].secretRef.name").replacePathFromPlaceholder("secretRef.name").type(KubernetesArtifactType.Secret).build();
    private static final Replacer HPA_DEPLOYMENT = Replacer.builder().path("$[?].spec.scaleTargetRef.name").findFilter(Filter.filter((Predicate)Criteria.where((String)"spec.scaleTargetRef.kind").is((Object)"Deployment")).or((Predicate)Criteria.where((String)"spec.scaleTargetRef.kind").is((Object)"deployment"))).replacePathFromPlaceholder("spec.scaleTargetRef.name").type(KubernetesArtifactType.Deployment).build();
    private static final Replacer HPA_REPLICA_SET = Replacer.builder().path("$[?].spec.scaleTargetRef.name").findFilter(Filter.filter((Predicate)Criteria.where((String)"spec.scaleTargetRef.kind").is((Object)"ReplicaSet")).or((Predicate)Criteria.where((String)"spec.scaleTargetRef.kind").is((Object)"replicaSet"))).replacePathFromPlaceholder("spec.scaleTargetRef.name").type(KubernetesArtifactType.ReplicaSet).build();

    private Replacer(KubernetesArtifactType type, String path, @Nullable Filter findFilter, String replacePathFromPlaceholder, @Nullable Function<String, String> nameFromReference) {
        this.type = Objects.requireNonNull(type);
        Objects.requireNonNull(path);
        Objects.requireNonNull(replacePathFromPlaceholder);
        this.nameFromReference = Optional.ofNullable(nameFromReference).orElse(a -> a);
        Function<Artifact, Filter> replaceFilter = a -> Filter.filter((Predicate)this.createReplaceFilterPredicate(replacePathFromPlaceholder, a.getName()));
        if (findFilter != null) {
            this.findPath = JsonPath.compile((String)path, (Predicate[])new Predicate[]{findFilter});
            this.replacePathSupplier = a -> JsonPath.compile((String)path, (Predicate[])new Predicate[]{((Filter)replaceFilter.apply((Artifact)a)).and((Predicate)findFilter)});
        } else {
            this.findPath = JsonPath.compile((String)path, (Predicate[])new Predicate[]{Filter.filter(a -> true)});
            this.replacePathSupplier = a -> JsonPath.compile((String)path, (Predicate[])new Predicate[]{(Predicate)replaceFilter.apply((Artifact)a)});
        }
    }

    Stream<Artifact> getArtifacts(DocumentContext document) {
        return Streams.stream((Iterator)((ArrayNode)document.read(this.findPath)).elements()).map(JsonNode::asText).map(ref -> Artifact.builder().type(this.type.getType()).reference(ref).name(this.nameFromReference.apply((String)ref)).build());
    }

    ImmutableCollection<Artifact> replaceArtifacts(DocumentContext obj, Collection<Artifact> artifacts) {
        ImmutableSet.Builder replacedArtifacts = ImmutableSet.builder();
        for (Artifact artifact : artifacts) {
            boolean wasReplaced = this.replaceIfPossible(obj, artifact);
            if (!wasReplaced) continue;
            replacedArtifacts.add((Object)artifact);
        }
        return replacedArtifacts.build();
    }

    private Predicate createReplaceFilterPredicate(String replacePath, String name) {
        return ctx -> {
            ValueNode node = ValueNode.toValueNode((Object)("@." + replacePath)).asPathNode().evaluate(ctx);
            if (!node.isStringNode()) {
                return false;
            }
            String value = node.asStringNode().getString();
            return this.nameFromReference.apply(value).equals(name);
        };
    }

    private boolean replaceIfPossible(DocumentContext obj, Artifact artifact) {
        Object get;
        if (!this.type.getType().equals(artifact.getType())) {
            return false;
        }
        JsonPath path = this.replacePathSupplier.apply(artifact);
        log.debug("Processed jsonPath == {}", (Object)path.getPath());
        try {
            get = obj.read(path);
        }
        catch (PathNotFoundException e) {
            return false;
        }
        if (get == null || get instanceof ArrayNode && ((ArrayNode)get).size() == 0) {
            return false;
        }
        log.info("Found valid swap for " + artifact + " using " + path.getPath() + ": " + get);
        obj.set(path, (Object)artifact.getReference());
        return true;
    }

    public static Replacer dockerImage() {
        return DOCKER_IMAGE;
    }

    public static Replacer podDockerImage() {
        return POD_DOCKER_IMAGE;
    }

    public static Replacer configMapVolume() {
        return CONFIG_MAP_VOLUME;
    }

    public static Replacer secretVolume() {
        return SECRET_VOLUME;
    }

    public static Replacer configMapProjectedVolume() {
        return CONFIG_MAP_PROJECTED_VOLUME;
    }

    public static Replacer secretProjectedVolume() {
        return SECRET_PROJECTED_VOLUME;
    }

    public static Replacer configMapKeyValue() {
        return CONFIG_MAP_KEY_VALUE;
    }

    public static Replacer secretKeyValue() {
        return SECRET_KEY_VALUE;
    }

    public static Replacer configMapEnv() {
        return CONFIG_MAP_ENV;
    }

    public static Replacer secretEnv() {
        return SECRET_ENV;
    }

    public static Replacer hpaDeployment() {
        return HPA_DEPLOYMENT;
    }

    public static Replacer hpaReplicaSet() {
        return HPA_REPLICA_SET;
    }

    @Generated
    private static ReplacerBuilder builder() {
        return new ReplacerBuilder();
    }

    @Generated
    private static class ReplacerBuilder {
        @Generated
        private KubernetesArtifactType type;
        @Generated
        private String path;
        @Generated
        private Filter findFilter;
        @Generated
        private String replacePathFromPlaceholder;
        @Generated
        private Function<String, String> nameFromReference;

        @Generated
        ReplacerBuilder() {
        }

        @Generated
        private ReplacerBuilder type(KubernetesArtifactType type) {
            this.type = type;
            return this;
        }

        @Generated
        private ReplacerBuilder path(String path) {
            this.path = path;
            return this;
        }

        @Generated
        private ReplacerBuilder findFilter(@Nullable Filter findFilter) {
            this.findFilter = findFilter;
            return this;
        }

        @Generated
        private ReplacerBuilder replacePathFromPlaceholder(String replacePathFromPlaceholder) {
            this.replacePathFromPlaceholder = replacePathFromPlaceholder;
            return this;
        }

        @Generated
        private ReplacerBuilder nameFromReference(@Nullable Function<String, String> nameFromReference) {
            this.nameFromReference = nameFromReference;
            return this;
        }

        @Generated
        private Replacer build() {
            return new Replacer(this.type, this.path, this.findFilter, this.replacePathFromPlaceholder, this.nameFromReference);
        }

        @Generated
        public String toString() {
            return "Replacer.ReplacerBuilder(type=" + this.type + ", path=" + this.path + ", findFilter=" + this.findFilter + ", replacePathFromPlaceholder=" + this.replacePathFromPlaceholder + ", nameFromReference=" + this.nameFromReference + ")";
        }
    }
}

