/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.caching.agent;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSetMultimap;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.cats.agent.AccountAware;
import com.netflix.spinnaker.cats.agent.AgentIntervalAware;
import com.netflix.spinnaker.cats.agent.CacheResult;
import com.netflix.spinnaker.cats.agent.CachingAgent;
import com.netflix.spinnaker.cats.agent.DefaultCacheResult;
import com.netflix.spinnaker.cats.cache.CacheData;
import com.netflix.spinnaker.cats.provider.ProviderCache;
import com.netflix.spinnaker.clouddriver.kubernetes.caching.agent.KubernetesCacheData;
import com.netflix.spinnaker.clouddriver.kubernetes.caching.agent.KubernetesCacheDataConverter;
import com.netflix.spinnaker.clouddriver.kubernetes.config.KubernetesCachingPolicy;
import com.netflix.spinnaker.clouddriver.kubernetes.description.KubernetesCoordinates;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesCachingProperties;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesKind;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesKindProperties;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesManifest;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesManifestAnnotater;
import com.netflix.spinnaker.clouddriver.kubernetes.op.job.KubectlJobExecutor;
import com.netflix.spinnaker.clouddriver.kubernetes.security.KubernetesCredentials;
import com.netflix.spinnaker.clouddriver.kubernetes.security.KubernetesNamedAccountCredentials;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class KubernetesCachingAgent
implements AgentIntervalAware,
CachingAgent,
AccountAware {
    private static final Logger log = LoggerFactory.getLogger(KubernetesCachingAgent.class);
    @Nonnull
    protected final String accountName;
    protected final Registry registry;
    protected final KubernetesCredentials credentials;
    protected final ObjectMapper objectMapper;
    protected final int agentIndex;
    protected final int agentCount;
    protected KubectlJobExecutor jobExecutor;
    protected String providerName = "kubernetes";
    protected final Long agentInterval;

    protected KubernetesCachingAgent(KubernetesNamedAccountCredentials namedAccountCredentials, ObjectMapper objectMapper, Registry registry, int agentIndex, int agentCount, Long agentInterval) {
        this.accountName = namedAccountCredentials.getName();
        this.credentials = namedAccountCredentials.getCredentials();
        this.objectMapper = objectMapper;
        this.registry = registry;
        this.agentIndex = agentIndex;
        this.agentCount = agentCount;
        this.agentInterval = agentInterval;
    }

    protected Map<String, Object> defaultIntrospectionDetails() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("namespaces", this.getNamespaces());
        result.put("kinds", this.primaryKinds());
        return result;
    }

    protected abstract List<KubernetesKind> primaryKinds();

    private ImmutableList<KubernetesManifest> loadResources(@Nonnull Iterable<KubernetesKind> kubernetesKinds, Optional<String> optionalNamespace) {
        String namespace = optionalNamespace.orElse(null);
        return this.credentials.list((List<KubernetesKind>)ImmutableList.copyOf(kubernetesKinds), namespace);
    }

    @Nonnull
    private ImmutableList<KubernetesManifest> loadNamespaceScopedResources(@Nonnull Iterable<KubernetesKind> kubernetesKinds) {
        return (ImmutableList)this.getNamespaces().parallelStream().map(n -> this.loadResources(kubernetesKinds, Optional.of(n))).flatMap(Collection::stream).collect(ImmutableList.toImmutableList());
    }

    @Nonnull
    private ImmutableList<KubernetesManifest> loadClusterScopedResources(@Nonnull Iterable<KubernetesKind> kubernetesKinds) {
        if (this.handleClusterScopedResources()) {
            return this.loadResources(kubernetesKinds, Optional.empty());
        }
        return ImmutableList.of();
    }

    private ImmutableSetMultimap<KubernetesKindProperties.ResourceScope, KubernetesKind> primaryKindsByScope() {
        return (ImmutableSetMultimap)this.primaryKinds().stream().collect(ImmutableSetMultimap.toImmutableSetMultimap(k -> this.credentials.getKindProperties((KubernetesKind)k).getResourceScope(), Function.identity()));
    }

    protected Map<KubernetesKind, List<KubernetesManifest>> loadPrimaryResourceList() {
        ImmutableSetMultimap<KubernetesKindProperties.ResourceScope, KubernetesKind> kindsByScope = this.primaryKindsByScope();
        Map<KubernetesKind, List<KubernetesManifest>> result = Stream.concat(this.loadClusterScopedResources((Iterable<KubernetesKind>)kindsByScope.get((Object)KubernetesKindProperties.ResourceScope.CLUSTER)).stream(), this.loadNamespaceScopedResources((Iterable<KubernetesKind>)kindsByScope.get((Object)KubernetesKindProperties.ResourceScope.NAMESPACE)).stream()).collect(Collectors.groupingBy(KubernetesManifest::getKind));
        for (KubernetesCachingPolicy policy : this.credentials.getCachingPolicies()) {
            List<KubernetesManifest> entries;
            KubernetesKind policyKind = KubernetesKind.fromString(policy.getKubernetesKind());
            if (!result.containsKey(policyKind) || (entries = result.get(policyKind)) == null || entries.size() <= policy.getMaxEntriesPerAgent()) continue;
            log.warn("{}: Pruning {} entries from kind {}", new Object[]{this.getAgentType(), entries.size() - policy.getMaxEntriesPerAgent(), policyKind});
            entries = entries.subList(0, policy.getMaxEntriesPerAgent());
            result.put(policyKind, entries);
        }
        return result;
    }

    @Deprecated
    protected KubernetesManifest loadPrimaryResource(KubernetesKind kind, String namespace, String name) {
        return this.loadPrimaryResource(KubernetesCoordinates.builder().kind(kind).namespace(namespace).name(name).build());
    }

    protected KubernetesManifest loadPrimaryResource(KubernetesCoordinates coordinates) {
        return this.credentials.get(coordinates);
    }

    public CacheResult loadData(ProviderCache providerCache) {
        log.info(this.getAgentType() + ": agent is starting");
        Map<String, Object> details = this.defaultIntrospectionDetails();
        long start = System.currentTimeMillis();
        Map<KubernetesKind, List<KubernetesManifest>> primaryResourceList = this.loadPrimaryResourceList();
        details.put("timeSpentInKubectlMs", System.currentTimeMillis() - start);
        return this.buildCacheResult(primaryResourceList);
    }

    protected CacheResult buildCacheResult(KubernetesManifest resource) {
        return this.buildCacheResult((Map<KubernetesKind, List<KubernetesManifest>>)ImmutableMap.of((Object)resource.getKind(), (Object)ImmutableList.of((Object)resource)));
    }

    private Predicate<KubernetesManifest> removeIgnored(boolean onlySpinnakerManaged) {
        return m -> {
            KubernetesCachingProperties props = KubernetesManifestAnnotater.getCachingProperties(m);
            return !props.isIgnore() && (!onlySpinnakerManaged || !props.getApplication().isEmpty());
        };
    }

    protected CacheResult buildCacheResult(Map<KubernetesKind, List<KubernetesManifest>> resources) {
        KubernetesCacheData kubernetesCacheData = new KubernetesCacheData();
        Map<KubernetesManifest, List<KubernetesManifest>> relationships = this.loadSecondaryResourceRelationships(resources);
        resources.values().stream().flatMap(Collection::stream).peek(m -> this.credentials.getResourcePropertyRegistry().get(m.getKind()).getHandler().removeSensitiveKeys((KubernetesManifest)m)).filter(this.removeIgnored(this.credentials.isOnlySpinnakerManaged())).forEach(rs -> {
            try {
                KubernetesCacheDataConverter.convertAsResource(kubernetesCacheData, this.accountName, this.credentials.getKubernetesSpinnakerKindMap(), this.credentials.getNamer(), rs, (List)relationships.getOrDefault(rs, (List<KubernetesManifest>)ImmutableList.of()), this.credentials.isCacheAllApplicationRelationships());
            }
            catch (RuntimeException e) {
                log.warn("{}: Failure converting {}", new Object[]{this.getAgentType(), rs, e});
            }
        });
        Map<String, Collection<CacheData>> entries = kubernetesCacheData.toStratifiedCacheData();
        KubernetesCacheDataConverter.logStratifiedCacheData(this.getAgentType(), entries);
        return new DefaultCacheResult(entries);
    }

    protected Map<KubernetesManifest, List<KubernetesManifest>> loadSecondaryResourceRelationships(Map<KubernetesKind, List<KubernetesManifest>> allResources) {
        HashMap<KubernetesManifest, List<KubernetesManifest>> result = new HashMap<KubernetesManifest, List<KubernetesManifest>>();
        allResources.keySet().forEach(k -> {
            try {
                this.credentials.getResourcePropertyRegistry().get((KubernetesKind)k).getHandler().addRelationships(allResources, result);
            }
            catch (RuntimeException e) {
                log.warn("{}: Failure adding relationships for {}", new Object[]{this.getAgentType(), k, e});
            }
        });
        return result;
    }

    protected ImmutableList<String> getNamespaces() {
        return (ImmutableList)this.credentials.getDeclaredNamespaces().stream().filter(n -> this.agentCount == 1 || Math.abs(n.hashCode() % this.agentCount) == this.agentIndex).collect(ImmutableList.toImmutableList());
    }

    protected boolean handleClusterScopedResources() {
        return this.agentIndex == 0;
    }

    public String getAgentType() {
        return String.format("%s/%s[%d/%d]", this.accountName, this.getClass().getSimpleName(), this.agentIndex + 1, this.agentCount);
    }

    @Nonnull
    @Generated
    public String getAccountName() {
        return this.accountName;
    }

    @Generated
    public String getProviderName() {
        return this.providerName;
    }

    @Generated
    public Long getAgentInterval() {
        return this.agentInterval;
    }
}

