/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.caching.view.provider;

import com.netflix.spinnaker.clouddriver.kubernetes.description.ResourcePropertyRegistry;
import com.netflix.spinnaker.clouddriver.kubernetes.security.KubernetesCredentials;
import com.netflix.spinnaker.clouddriver.kubernetes.security.KubernetesNamedAccountCredentials;
import com.netflix.spinnaker.clouddriver.security.AccountCredentials;
import com.netflix.spinnaker.credentials.CredentialsRepository;
import com.netflix.spinnaker.kork.annotations.NonnullByDefault;
import java.util.Optional;
import org.springframework.stereotype.Component;

@Component
@NonnullByDefault
class KubernetesAccountResolver {
    private final CredentialsRepository<KubernetesNamedAccountCredentials> credentialsRepository;
    private final ResourcePropertyRegistry globalResourcePropertyRegistry;

    KubernetesAccountResolver(CredentialsRepository<KubernetesNamedAccountCredentials> credentialsRepository, ResourcePropertyRegistry globalResourcePropertyRegistry) {
        this.credentialsRepository = credentialsRepository;
        this.globalResourcePropertyRegistry = globalResourcePropertyRegistry;
    }

    Optional<KubernetesCredentials> getCredentials(String account) {
        return Optional.ofNullable((KubernetesNamedAccountCredentials)this.credentialsRepository.getOne(account)).map(AccountCredentials::getCredentials);
    }

    ResourcePropertyRegistry getResourcePropertyRegistry(String account) {
        return this.getCredentials(account).map(KubernetesCredentials::getResourcePropertyRegistry).orElse(this.globalResourcePropertyRegistry);
    }
}

