/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.caching.view.provider;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.netflix.spinnaker.cats.cache.Cache;
import com.netflix.spinnaker.cats.cache.CacheData;
import com.netflix.spinnaker.cats.cache.CacheFilter;
import com.netflix.spinnaker.cats.cache.RelationshipCacheFilter;
import com.netflix.spinnaker.clouddriver.kubernetes.caching.Keys;
import com.netflix.spinnaker.clouddriver.kubernetes.caching.agent.KubernetesCacheDataConverter;
import com.netflix.spinnaker.clouddriver.kubernetes.caching.view.provider.KubernetesAccountResolver;
import com.netflix.spinnaker.clouddriver.kubernetes.caching.view.provider.data.KubernetesCacheData;
import com.netflix.spinnaker.clouddriver.kubernetes.description.KubernetesCoordinates;
import com.netflix.spinnaker.clouddriver.kubernetes.description.KubernetesSpinnakerKindMap;
import com.netflix.spinnaker.clouddriver.kubernetes.description.SpinnakerKind;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesKind;
import com.netflix.spinnaker.clouddriver.kubernetes.op.handler.KubernetesHandler;
import com.netflix.spinnaker.kork.annotations.NonnullByDefault;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@NonnullByDefault
class KubernetesCacheUtils {
    private final Cache cache;
    private final KubernetesSpinnakerKindMap kindMap;
    private final KubernetesAccountResolver resourcePropertyResolver;

    @Autowired
    public KubernetesCacheUtils(Cache cache, KubernetesSpinnakerKindMap kindMap, KubernetesAccountResolver resourcePropertyResolver) {
        this.cache = cache;
        this.kindMap = kindMap;
        this.resourcePropertyResolver = resourcePropertyResolver;
    }

    Collection<CacheData> getAllKeys(String type) {
        return this.cache.getAll(type);
    }

    Collection<String> getAllKeysMatchingPattern(String type, String key) {
        return this.cache.filterIdentifiers(type, key);
    }

    Collection<CacheData> getAllDataMatchingPattern(String type, String key) {
        return this.cache.getAll(type, this.getAllKeysMatchingPattern(type, key));
    }

    Optional<CacheData> getSingleEntry(String type, String key) {
        return Optional.ofNullable(this.cache.get(type, key));
    }

    Optional<CacheData> getSingleEntry(String account, String namespace, String name) {
        KubernetesCoordinates coords;
        try {
            coords = KubernetesCoordinates.builder().namespace(namespace).fullResourceName(name).build();
        }
        catch (IllegalArgumentException e) {
            return Optional.empty();
        }
        return this.getSingleEntry(coords.getKind().toString(), Keys.InfrastructureCacheKey.createKey(account, coords));
    }

    Optional<CacheData> getSingleEntryWithRelationships(String type, String key, RelationshipCacheFilter cacheFilter) {
        return Optional.ofNullable(this.cache.get(type, key, (CacheFilter)cacheFilter));
    }

    ImmutableCollection<String> getRelationshipKeys(CacheData cacheData, SpinnakerKind spinnakerKind) {
        return (ImmutableCollection)this.relationshipTypes(spinnakerKind).flatMap(t -> this.getRelationshipKeys(cacheData, (String)t)).collect(ImmutableSet.toImmutableSet());
    }

    private ImmutableMultimap<String, String> getRelationshipKeys(Collection<CacheData> cacheData, String type) {
        return (ImmutableMultimap)cacheData.stream().collect(ImmutableSetMultimap.flatteningToImmutableSetMultimap(CacheData::getId, cd -> this.getRelationshipKeys((CacheData)cd, type)));
    }

    Collection<CacheData> getRelationships(CacheData cacheData, String relationshipType) {
        return this.getRelationships(cacheData, relationshipType, this.getRelationshipKeys(cacheData, relationshipType));
    }

    Collection<CacheData> getRelationships(CacheData cacheData, String relationshipType, Stream<String> relationshipKeys) {
        return this.cache.getAll(relationshipType, (Collection)relationshipKeys.collect(ImmutableSet.toImmutableSet()));
    }

    ImmutableCollection<CacheData> getRelationships(CacheData cacheData, SpinnakerKind spinnakerKind) {
        return this.getRelationships((Collection<CacheData>)ImmutableList.of((Object)cacheData), spinnakerKind).get((Object)cacheData.getId());
    }

    ImmutableCollection<CacheData> getAllRelationships(CacheData cacheData) {
        ImmutableList.Builder result = ImmutableList.builder();
        cacheData.getRelationships().forEach((kind, relationships) -> result.addAll(this.getRelationships(cacheData, (String)kind, relationships.stream())));
        return result.build();
    }

    ImmutableMultimap<String, CacheData> getRelationships(Collection<CacheData> cacheData, SpinnakerKind spinnakerKind) {
        ImmutableListMultimap.Builder result = ImmutableListMultimap.builder();
        this.relationshipTypes(spinnakerKind).forEach(type -> result.putAll(this.getRelationships(cacheData, (String)type)));
        return result.build();
    }

    private Multimap<String, CacheData> getRelationships(Collection<CacheData> cacheData, String type) {
        ImmutableMultimap<String, String> relKeys = this.getRelationshipKeys(cacheData, type);
        ImmutableMap relData = (ImmutableMap)this.cache.getAll(type, (Collection)relKeys.values()).stream().collect(ImmutableMap.toImmutableMap(CacheData::getId, cd -> cd, (cd1, cd2) -> cd1));
        return Multimaps.filterValues((Multimap)Multimaps.transformValues(relKeys, arg_0 -> ((ImmutableMap)relData).get(arg_0)), Objects::nonNull);
    }

    private Stream<String> getRelationshipKeys(CacheData cacheData, String type) {
        Collection relationships = (Collection)cacheData.getRelationships().get(type);
        if (relationships == null) {
            return Stream.empty();
        }
        return relationships.stream();
    }

    private Stream<String> relationshipTypes(SpinnakerKind spinnakerKind) {
        return this.kindMap.translateSpinnakerKind(spinnakerKind).stream().map(KubernetesKind::toString);
    }

    RelationshipCacheFilter getCacheFilter(Collection<SpinnakerKind> spinnakerKinds) {
        return RelationshipCacheFilter.include((String[])((String[])spinnakerKinds.stream().flatMap(this::relationshipTypes).toArray(String[]::new)));
    }

    Predicate<CacheData> distinctById() {
        HashSet seen = new HashSet();
        return cd -> seen.add(cd.getId());
    }

    KubernetesHandler getHandler(KubernetesCacheData cacheData) {
        Keys.InfrastructureCacheKey key = (Keys.InfrastructureCacheKey)Keys.parseKey(cacheData.primaryData().getId()).get();
        KubernetesKind kind = KubernetesCacheDataConverter.getManifest(cacheData.primaryData()).getKind();
        return this.resourcePropertyResolver.getResourcePropertyRegistry(key.getAccount()).get(kind).getHandler();
    }
}

