/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.caching.view.provider;

import com.google.common.collect.ImmutableList;
import com.netflix.spinnaker.clouddriver.kubernetes.caching.agent.KubernetesCacheDataConverter;
import com.netflix.spinnaker.clouddriver.kubernetes.caching.view.model.KubernetesInstance;
import com.netflix.spinnaker.clouddriver.kubernetes.caching.view.provider.KubernetesAccountResolver;
import com.netflix.spinnaker.clouddriver.kubernetes.caching.view.provider.KubernetesCacheUtils;
import com.netflix.spinnaker.clouddriver.kubernetes.description.KubernetesCoordinates;
import com.netflix.spinnaker.clouddriver.kubernetes.model.ContainerLog;
import com.netflix.spinnaker.clouddriver.kubernetes.op.job.KubectlJobExecutor;
import com.netflix.spinnaker.clouddriver.kubernetes.security.KubernetesCredentials;
import com.netflix.spinnaker.clouddriver.model.InstanceProvider;
import io.kubernetes.client.openapi.models.V1Container;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import io.kubernetes.client.openapi.models.V1Pod;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class KubernetesInstanceProvider
implements InstanceProvider<KubernetesInstance, List<ContainerLog>> {
    private static final Logger log = LoggerFactory.getLogger(KubernetesInstanceProvider.class);
    private final KubernetesCacheUtils cacheUtils;
    private final KubernetesAccountResolver accountResolver;

    @Autowired
    KubernetesInstanceProvider(KubernetesCacheUtils cacheUtils, KubernetesAccountResolver accountResolver) {
        this.cacheUtils = cacheUtils;
        this.accountResolver = accountResolver;
    }

    public String getCloudProvider() {
        return "kubernetes";
    }

    public KubernetesInstance getInstance(String account, String namespace, String fullName) {
        return this.cacheUtils.getSingleEntry(account, namespace, fullName).map(KubernetesInstance::fromCacheData).orElse(null);
    }

    public List<ContainerLog> getConsoleOutput(String account, String namespace, String fullName) {
        KubernetesCoordinates coords;
        Optional<KubernetesCredentials> optionalCredentials = this.accountResolver.getCredentials(account);
        if (!optionalCredentials.isPresent()) {
            log.warn("Failure getting account {}", (Object)account);
            return null;
        }
        KubernetesCredentials credentials = optionalCredentials.get();
        try {
            coords = KubernetesCoordinates.builder().namespace(namespace).fullResourceName(fullName).build();
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        V1Pod pod = KubernetesCacheDataConverter.getResource(credentials.get(coords), V1Pod.class);
        if (pod == null) {
            return ImmutableList.of((Object)new ContainerLog("Error", "Failed to retrieve pod data; pod may have been deleted."));
        }
        return this.getPodLogs(credentials, pod);
    }

    @Nonnull
    private List<ContainerLog> getPodLogs(@Nonnull KubernetesCredentials credentials, @Nonnull V1Pod pod) {
        List initContainers = Optional.ofNullable(pod.getSpec().getInitContainers()).orElse((List)ImmutableList.of());
        List containers = pod.getSpec().getContainers();
        return Stream.concat(initContainers.stream(), containers.stream()).map(container -> this.getContainerLog(credentials, pod, (V1Container)container)).collect(Collectors.toList());
    }

    @Nonnull
    private ContainerLog getContainerLog(@Nonnull KubernetesCredentials credentials, @Nonnull V1Pod pod, @Nonnull V1Container container) {
        String containerName = container.getName();
        V1ObjectMeta metadata = pod.getMetadata();
        try {
            String containerLogs = credentials.logs(metadata.getNamespace(), metadata.getName(), containerName);
            return new ContainerLog(containerName, containerLogs);
        }
        catch (KubectlJobExecutor.KubectlException e) {
            return new ContainerLog(containerName, e.getMessage());
        }
    }
}

