/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.caching.view.provider;

import com.netflix.spinnaker.clouddriver.kubernetes.caching.view.model.KubernetesManifestContainer;
import com.netflix.spinnaker.clouddriver.kubernetes.description.KubernetesPodMetric;
import com.netflix.spinnaker.clouddriver.kubernetes.description.KubernetesResourceProperties;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesKind;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesManifest;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesManifestAnnotater;
import com.netflix.spinnaker.clouddriver.kubernetes.op.handler.KubernetesHandler;
import com.netflix.spinnaker.clouddriver.kubernetes.security.KubernetesCredentials;
import com.netflix.spinnaker.kork.annotations.NonnullByDefault;
import com.netflix.spinnaker.kork.artifacts.model.Artifact;
import com.netflix.spinnaker.moniker.Moniker;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

@NonnullByDefault
final class KubernetesManifestContainerBuilder {
    KubernetesManifestContainerBuilder() {
    }

    static KubernetesManifestContainer buildManifest(KubernetesCredentials credentials, KubernetesManifest manifest, List<KubernetesManifest> events, List<KubernetesPodMetric.ContainerMetric> metrics) {
        String namespace = manifest.getNamespace();
        KubernetesKind kind = manifest.getKind();
        KubernetesResourceProperties properties = credentials.getResourcePropertyRegistry().get(kind);
        Function<KubernetesManifest, String> lastEventTimestamp = m -> m.getOrDefault("lastTimestamp", m.getOrDefault("firstTimestamp", "n/a"));
        Comparator<KubernetesManifest> eventComparator = Comparator.nullsLast(Comparator.comparing(lastEventTimestamp, Comparator.nullsLast(Comparator.naturalOrder())));
        events = events.stream().sorted(eventComparator).collect(Collectors.toList());
        Moniker moniker = KubernetesManifestAnnotater.getMoniker(manifest);
        KubernetesHandler handler = properties.getHandler();
        return KubernetesManifestContainer.builder().account(credentials.getAccountName()).name(manifest.getFullResourceName()).location(namespace).manifest(manifest).moniker(moniker).status(handler.status(manifest)).artifacts((Set<Artifact>)handler.listArtifacts(manifest)).events(events).warnings(handler.listWarnings(manifest)).metrics(metrics).build();
    }
}

