/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.caching.view.provider;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.netflix.spinnaker.cats.cache.CacheData;
import com.netflix.spinnaker.clouddriver.kubernetes.caching.Keys;
import com.netflix.spinnaker.clouddriver.kubernetes.caching.view.provider.KubernetesAccountResolver;
import com.netflix.spinnaker.clouddriver.kubernetes.caching.view.provider.KubernetesCacheUtils;
import com.netflix.spinnaker.clouddriver.kubernetes.description.KubernetesResourceProperties;
import com.netflix.spinnaker.clouddriver.kubernetes.description.KubernetesSpinnakerKindMap;
import com.netflix.spinnaker.clouddriver.kubernetes.description.SpinnakerKind;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesKind;
import com.netflix.spinnaker.clouddriver.search.SearchProvider;
import com.netflix.spinnaker.clouddriver.search.SearchResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class KubernetesSearchProvider
implements SearchProvider {
    private static final Logger log = LoggerFactory.getLogger(KubernetesSearchProvider.class);
    private final KubernetesCacheUtils cacheUtils;
    private final ObjectMapper mapper;
    private final KubernetesSpinnakerKindMap kindMap;
    private final KubernetesAccountResolver resourcePropertyResolver;
    private final List<String> defaultTypes;
    private final Set<String> logicalTypes;
    private final Set<String> allCaches;

    @Autowired
    public KubernetesSearchProvider(KubernetesCacheUtils cacheUtils, KubernetesSpinnakerKindMap kindMap, ObjectMapper objectMapper, KubernetesAccountResolver resourcePropertyResolver) {
        this.cacheUtils = cacheUtils;
        this.mapper = objectMapper;
        this.kindMap = kindMap;
        this.resourcePropertyResolver = resourcePropertyResolver;
        this.defaultTypes = kindMap.allKubernetesKinds().stream().map(KubernetesKind::toString).collect(Collectors.toList());
        this.logicalTypes = Arrays.stream(Keys.LogicalKind.values()).map(Keys.LogicalKind::toString).collect(Collectors.toSet());
        this.allCaches = new HashSet<String>(this.defaultTypes);
        this.allCaches.addAll(this.logicalTypes);
    }

    public String getPlatform() {
        return "kubernetes";
    }

    public SearchResultSet search(String query, Integer pageNumber, Integer pageSize) {
        return this.search(query, this.defaultTypes, pageNumber, pageSize);
    }

    public SearchResultSet search(String query, Integer pageNumber, Integer pageSize, Map<String, String> filters) {
        return this.search(query, this.defaultTypes, pageNumber, pageSize, filters);
    }

    public SearchResultSet search(String query, List<String> types, Integer pageNumber, Integer pageSize) {
        return this.search(query, types, pageNumber, pageSize, (Map<String, String>)ImmutableMap.of());
    }

    public SearchResultSet search(String query, List<String> types, Integer pageNumber, Integer pageSize, Map<String, String> filters) {
        log.info("Querying {} for term {}", types, (Object)query);
        List<Map<String, Object>> results = KubernetesSearchProvider.paginateResults(this.getMatches(query, types), pageSize, pageNumber);
        return SearchResultSet.builder().pageNumber(pageNumber).pageSize(pageSize).platform(this.getPlatform()).query(query).totalMatches(Integer.valueOf(results.size())).results(results).build();
    }

    private Map<String, Object> convertKeyToMap(String key) {
        Map<String, Object> result;
        String type;
        Optional<Keys.CacheKey> optional = Keys.parseKey(key);
        if (!optional.isPresent()) {
            return null;
        }
        Keys.CacheKey parsedKey = optional.get();
        if (parsedKey instanceof Keys.InfrastructureCacheKey) {
            Keys.InfrastructureCacheKey infraKey = (Keys.InfrastructureCacheKey)parsedKey;
            type = this.kindMap.translateKubernetesKind(infraKey.getKubernetesKind()).toString();
            KubernetesResourceProperties properties = this.resourcePropertyResolver.getResourcePropertyRegistry(infraKey.getAccount()).get(infraKey.getKubernetesKind());
            result = properties.getHandler().hydrateSearchResult(infraKey);
        } else if (parsedKey instanceof Keys.LogicalKey) {
            Keys.LogicalKey logicalKey = (Keys.LogicalKey)parsedKey;
            result = (Map<String, Object>)this.mapper.convertValue((Object)logicalKey, (TypeReference)new TypeReference<Map<String, Object>>(){});
            result.put(logicalKey.getLogicalKind().singular(), logicalKey.getName());
            type = logicalKey.getGroup();
        } else {
            log.warn("Unknown key type " + parsedKey + ", ignoring.");
            return null;
        }
        result.put("type", type);
        return result;
    }

    private static Stream<KeyRelationship> getMatchingRelationships(CacheData cacheData, Set<String> typesToSearch) {
        Keys.CacheKey cacheKey = Keys.parseKey(cacheData.getId()).orElse(null);
        if (!(cacheKey instanceof Keys.LogicalKey)) {
            return Stream.empty();
        }
        Map relationships = cacheData.getRelationships();
        return typesToSearch.stream().map(relationships::get).filter(Objects::nonNull).flatMap(Collection::stream).filter(Objects::nonNull).map(k -> new KeyRelationship((String)k, (Keys.LogicalKey)cacheKey));
    }

    private Map<String, List<Keys.LogicalKey>> getKeysRelatedToLogicalMatches(String matchQuery, Set<String> typesToSearch) {
        return this.logicalTypes.stream().map(type -> this.cacheUtils.getAllDataMatchingPattern((String)type, matchQuery)).flatMap(Collection::stream).flatMap(cd -> KubernetesSearchProvider.getMatchingRelationships(cd, typesToSearch)).collect(Collectors.groupingBy(KeyRelationship::getInfrastructureKey, Collectors.mapping(KeyRelationship::getLogicalKey, Collectors.toList())));
    }

    private List<Map<String, Object>> getMatches(String query, List<String> types) {
        String matchQuery = String.format("*%s*", query.toLowerCase());
        HashSet<String> typesToSearch = new HashSet<String>(types);
        typesToSearch.addAll(types.stream().map(t -> {
            try {
                return SpinnakerKind.fromString(t);
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }).filter(k -> k != null && k != SpinnakerKind.UNCLASSIFIED).map(this.kindMap::translateSpinnakerKind).flatMap(Collection::stream).map(KubernetesKind::toString).collect(Collectors.toSet()));
        typesToSearch.retainAll(this.allCaches);
        if (typesToSearch.isEmpty()) {
            return ImmutableList.of();
        }
        Stream<Map> directResults = typesToSearch.stream().map(type -> this.cacheUtils.getAllKeysMatchingPattern((String)type, matchQuery)).flatMap(Collection::stream).map(this::convertKeyToMap);
        Stream<Map> relatedResults = this.getKeysRelatedToLogicalMatches(matchQuery, typesToSearch).entrySet().stream().map(kv -> {
            Map<String, Object> result = this.convertKeyToMap((String)kv.getKey());
            if (result != null) {
                ((List)kv.getValue()).forEach(k -> result.put(k.getLogicalKind().singular(), k.getName()));
            }
            return result;
        });
        return Stream.concat(directResults, relatedResults).filter(Objects::nonNull).filter(result -> typesToSearch.contains(result.get("group"))).collect(Collectors.toList());
    }

    private static <T> List<T> paginateResults(List<T> matches, Integer pageSize, Integer pageNumber) {
        Integer startingIndex = pageSize * (pageNumber - 1);
        Integer endIndex = Math.min(pageSize * pageNumber, matches.size());
        return startingIndex < endIndex ? matches.subList(startingIndex, endIndex) : new ArrayList();
    }

    private static class KeyRelationship {
        private final String infrastructureKey;
        private final Keys.LogicalKey logicalKey;

        @Generated
        public String getInfrastructureKey() {
            return this.infrastructureKey;
        }

        @Generated
        public Keys.LogicalKey getLogicalKey() {
            return this.logicalKey;
        }

        @Generated
        public KeyRelationship(String infrastructureKey, Keys.LogicalKey logicalKey) {
            this.infrastructureKey = infrastructureKey;
            this.logicalKey = logicalKey;
        }
    }
}

