/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.caching.view.provider;

import com.netflix.spinnaker.clouddriver.kubernetes.caching.Keys;
import com.netflix.spinnaker.clouddriver.kubernetes.caching.view.model.KubernetesSecurityGroup;
import com.netflix.spinnaker.clouddriver.kubernetes.caching.view.provider.KubernetesCacheUtils;
import com.netflix.spinnaker.clouddriver.kubernetes.description.KubernetesCoordinates;
import com.netflix.spinnaker.clouddriver.kubernetes.description.KubernetesSpinnakerKindMap;
import com.netflix.spinnaker.clouddriver.kubernetes.description.SpinnakerKind;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesKind;
import com.netflix.spinnaker.clouddriver.model.SecurityGroupProvider;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class KubernetesSecurityGroupProvider
implements SecurityGroupProvider<KubernetesSecurityGroup> {
    private final KubernetesCacheUtils cacheUtils;
    private final KubernetesSpinnakerKindMap kindMap;

    @Autowired
    KubernetesSecurityGroupProvider(KubernetesCacheUtils cacheUtils, KubernetesSpinnakerKindMap kindMap) {
        this.cacheUtils = cacheUtils;
        this.kindMap = kindMap;
    }

    public String getCloudProvider() {
        return "kubernetes";
    }

    public Set<KubernetesSecurityGroup> getAll(boolean includeRules) {
        return this.kindMap.translateSpinnakerKind(SpinnakerKind.SECURITY_GROUPS).stream().map(KubernetesKind::toString).map(this.cacheUtils::getAllKeys).flatMap(Collection::stream).map(KubernetesSecurityGroup::fromCacheData).collect(Collectors.toSet());
    }

    public Set<KubernetesSecurityGroup> getAllByRegion(boolean includeRules, String namespace) {
        return this.kindMap.translateSpinnakerKind(SpinnakerKind.SECURITY_GROUPS).stream().map(k -> {
            String key = Keys.InfrastructureCacheKey.createKey(k, "*", namespace, "*");
            return this.cacheUtils.getAllDataMatchingPattern(k.toString(), key);
        }).flatMap(Collection::stream).map(KubernetesSecurityGroup::fromCacheData).collect(Collectors.toSet());
    }

    public Set<KubernetesSecurityGroup> getAllByAccount(boolean includeRules, String account) {
        return this.kindMap.translateSpinnakerKind(SpinnakerKind.SECURITY_GROUPS).stream().map(k -> {
            String key = Keys.InfrastructureCacheKey.createKey(k, account, "*", "*");
            return this.cacheUtils.getAllDataMatchingPattern(k.toString(), key);
        }).flatMap(Collection::stream).map(KubernetesSecurityGroup::fromCacheData).collect(Collectors.toSet());
    }

    public Set<KubernetesSecurityGroup> getAllByAccountAndName(boolean includeRules, String account, String fullName) {
        String name;
        try {
            name = KubernetesCoordinates.builder().fullResourceName(fullName).build().getName();
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        return this.kindMap.translateSpinnakerKind(SpinnakerKind.SECURITY_GROUPS).stream().map(k -> {
            String key = Keys.InfrastructureCacheKey.createKey(k, account, "*", name);
            return this.cacheUtils.getAllDataMatchingPattern(k.toString(), key);
        }).flatMap(Collection::stream).map(KubernetesSecurityGroup::fromCacheData).collect(Collectors.toSet());
    }

    public Set<KubernetesSecurityGroup> getAllByAccountAndRegion(boolean includeRule, String account, String namespace) {
        return this.kindMap.translateSpinnakerKind(SpinnakerKind.SECURITY_GROUPS).stream().map(k -> {
            String key = Keys.InfrastructureCacheKey.createKey(k, account, namespace, "*");
            return this.cacheUtils.getAllDataMatchingPattern(k.toString(), key);
        }).flatMap(Collection::stream).map(KubernetesSecurityGroup::fromCacheData).collect(Collectors.toSet());
    }

    public KubernetesSecurityGroup get(String account, String namespace, String fullName, String _unused) {
        String name;
        try {
            name = KubernetesCoordinates.builder().fullResourceName(fullName).build().getName();
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        return this.kindMap.translateSpinnakerKind(SpinnakerKind.SECURITY_GROUPS).stream().map(k -> {
            String key = Keys.InfrastructureCacheKey.createKey(k, account, namespace, name);
            return this.cacheUtils.getSingleEntry(k.toString(), key).orElse(null);
        }).filter(Objects::nonNull).map(KubernetesSecurityGroup::fromCacheData).findFirst().orElse(null);
    }

    public KubernetesSecurityGroup getById(String account, String region, String id, String vpcId) {
        throw new UnsupportedOperationException("Not currently implemented.");
    }
}

