/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.config;

import com.google.common.base.Strings;
import com.netflix.spinnaker.clouddriver.kubernetes.config.CustomKubernetesResource;
import com.netflix.spinnaker.clouddriver.kubernetes.config.KubernetesCachingPolicy;
import com.netflix.spinnaker.clouddriver.kubernetes.config.RawResourcesEndpointConfig;
import com.netflix.spinnaker.credentials.definition.CredentialsDefinition;
import com.netflix.spinnaker.fiat.model.resources.Permissions;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;

public class KubernetesConfigurationProperties {
    private static final int DEFAULT_CACHE_THREADS = 1;
    private List<ManagedAccount> accounts = new ArrayList<ManagedAccount>();

    @Generated
    public KubernetesConfigurationProperties() {
    }

    @Generated
    public List<ManagedAccount> getAccounts() {
        return this.accounts;
    }

    @Generated
    public KubernetesConfigurationProperties setAccounts(List<ManagedAccount> accounts) {
        this.accounts = accounts;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KubernetesConfigurationProperties)) {
            return false;
        }
        KubernetesConfigurationProperties other = (KubernetesConfigurationProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<ManagedAccount> this$accounts = this.getAccounts();
        List<ManagedAccount> other$accounts = other.getAccounts();
        return !(this$accounts == null ? other$accounts != null : !((Object)this$accounts).equals(other$accounts));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof KubernetesConfigurationProperties;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<ManagedAccount> $accounts = this.getAccounts();
        result = result * 59 + ($accounts == null ? 43 : ((Object)$accounts).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "KubernetesConfigurationProperties(accounts=" + this.getAccounts() + ")";
    }

    public static class ManagedAccount
    implements CredentialsDefinition {
        private String name;
        private String environment;
        private String accountType;
        private String context;
        private String oAuthServiceAccount;
        private List<String> oAuthScopes;
        private String kubeconfigFile;
        private String kubeconfigContents;
        private String kubectlExecutable;
        private Integer kubectlRequestTimeoutSeconds;
        private boolean serviceAccount = false;
        private List<String> namespaces = new ArrayList<String>();
        private List<String> omitNamespaces = new ArrayList<String>();
        private int cacheThreads = 1;
        private List<String> requiredGroupMembership = new ArrayList<String>();
        private Permissions.Builder permissions = new Permissions.Builder();
        private String namingStrategy = "kubernetesAnnotations";
        private boolean debug = false;
        private boolean metrics = true;
        private boolean checkPermissionsOnStartup = true;
        private List<CustomKubernetesResource> customResources = new ArrayList<CustomKubernetesResource>();
        private List<KubernetesCachingPolicy> cachingPolicies = new ArrayList<KubernetesCachingPolicy>();
        private List<String> kinds = new ArrayList<String>();
        private List<String> omitKinds = new ArrayList<String>();
        private boolean onlySpinnakerManaged = false;
        private Long cacheIntervalSeconds;
        private boolean cacheAllApplicationRelationships = false;
        private RawResourcesEndpointConfig rawResourcesEndpointConfig = new RawResourcesEndpointConfig();

        public void validate() {
            if (Strings.isNullOrEmpty((String)this.name)) {
                throw new IllegalArgumentException("Account name for Kubernetes provider missing.");
            }
            if (!this.omitNamespaces.isEmpty() && !this.namespaces.isEmpty()) {
                throw new IllegalArgumentException("At most one of 'namespaces' and 'omitNamespaces' can be specified");
            }
            if (!this.omitKinds.isEmpty() && !this.kinds.isEmpty()) {
                throw new IllegalArgumentException("At most one of 'kinds' and 'omitKinds' can be specified");
            }
            this.rawResourcesEndpointConfig.validate();
        }

        @Generated
        public ManagedAccount() {
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getEnvironment() {
            return this.environment;
        }

        @Generated
        public String getAccountType() {
            return this.accountType;
        }

        @Generated
        public String getContext() {
            return this.context;
        }

        @Generated
        public String getOAuthServiceAccount() {
            return this.oAuthServiceAccount;
        }

        @Generated
        public List<String> getOAuthScopes() {
            return this.oAuthScopes;
        }

        @Generated
        public String getKubeconfigFile() {
            return this.kubeconfigFile;
        }

        @Generated
        public String getKubeconfigContents() {
            return this.kubeconfigContents;
        }

        @Generated
        public String getKubectlExecutable() {
            return this.kubectlExecutable;
        }

        @Generated
        public Integer getKubectlRequestTimeoutSeconds() {
            return this.kubectlRequestTimeoutSeconds;
        }

        @Generated
        public boolean isServiceAccount() {
            return this.serviceAccount;
        }

        @Generated
        public List<String> getNamespaces() {
            return this.namespaces;
        }

        @Generated
        public List<String> getOmitNamespaces() {
            return this.omitNamespaces;
        }

        @Generated
        public int getCacheThreads() {
            return this.cacheThreads;
        }

        @Generated
        public List<String> getRequiredGroupMembership() {
            return this.requiredGroupMembership;
        }

        @Generated
        public Permissions.Builder getPermissions() {
            return this.permissions;
        }

        @Generated
        public String getNamingStrategy() {
            return this.namingStrategy;
        }

        @Generated
        public boolean isDebug() {
            return this.debug;
        }

        @Generated
        public boolean isMetrics() {
            return this.metrics;
        }

        @Generated
        public boolean isCheckPermissionsOnStartup() {
            return this.checkPermissionsOnStartup;
        }

        @Generated
        public List<CustomKubernetesResource> getCustomResources() {
            return this.customResources;
        }

        @Generated
        public List<KubernetesCachingPolicy> getCachingPolicies() {
            return this.cachingPolicies;
        }

        @Generated
        public List<String> getKinds() {
            return this.kinds;
        }

        @Generated
        public List<String> getOmitKinds() {
            return this.omitKinds;
        }

        @Generated
        public boolean isOnlySpinnakerManaged() {
            return this.onlySpinnakerManaged;
        }

        @Generated
        public Long getCacheIntervalSeconds() {
            return this.cacheIntervalSeconds;
        }

        @Generated
        public boolean isCacheAllApplicationRelationships() {
            return this.cacheAllApplicationRelationships;
        }

        @Generated
        public RawResourcesEndpointConfig getRawResourcesEndpointConfig() {
            return this.rawResourcesEndpointConfig;
        }

        @Generated
        public ManagedAccount setName(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public ManagedAccount setEnvironment(String environment) {
            this.environment = environment;
            return this;
        }

        @Generated
        public ManagedAccount setAccountType(String accountType) {
            this.accountType = accountType;
            return this;
        }

        @Generated
        public ManagedAccount setContext(String context) {
            this.context = context;
            return this;
        }

        @Generated
        public ManagedAccount setOAuthServiceAccount(String oAuthServiceAccount) {
            this.oAuthServiceAccount = oAuthServiceAccount;
            return this;
        }

        @Generated
        public ManagedAccount setOAuthScopes(List<String> oAuthScopes) {
            this.oAuthScopes = oAuthScopes;
            return this;
        }

        @Generated
        public ManagedAccount setKubeconfigFile(String kubeconfigFile) {
            this.kubeconfigFile = kubeconfigFile;
            return this;
        }

        @Generated
        public ManagedAccount setKubeconfigContents(String kubeconfigContents) {
            this.kubeconfigContents = kubeconfigContents;
            return this;
        }

        @Generated
        public ManagedAccount setKubectlExecutable(String kubectlExecutable) {
            this.kubectlExecutable = kubectlExecutable;
            return this;
        }

        @Generated
        public ManagedAccount setKubectlRequestTimeoutSeconds(Integer kubectlRequestTimeoutSeconds) {
            this.kubectlRequestTimeoutSeconds = kubectlRequestTimeoutSeconds;
            return this;
        }

        @Generated
        public ManagedAccount setServiceAccount(boolean serviceAccount) {
            this.serviceAccount = serviceAccount;
            return this;
        }

        @Generated
        public ManagedAccount setNamespaces(List<String> namespaces) {
            this.namespaces = namespaces;
            return this;
        }

        @Generated
        public ManagedAccount setOmitNamespaces(List<String> omitNamespaces) {
            this.omitNamespaces = omitNamespaces;
            return this;
        }

        @Generated
        public ManagedAccount setCacheThreads(int cacheThreads) {
            this.cacheThreads = cacheThreads;
            return this;
        }

        @Generated
        public ManagedAccount setRequiredGroupMembership(List<String> requiredGroupMembership) {
            this.requiredGroupMembership = requiredGroupMembership;
            return this;
        }

        @Generated
        public ManagedAccount setPermissions(Permissions.Builder permissions) {
            this.permissions = permissions;
            return this;
        }

        @Generated
        public ManagedAccount setNamingStrategy(String namingStrategy) {
            this.namingStrategy = namingStrategy;
            return this;
        }

        @Generated
        public ManagedAccount setDebug(boolean debug) {
            this.debug = debug;
            return this;
        }

        @Generated
        public ManagedAccount setMetrics(boolean metrics) {
            this.metrics = metrics;
            return this;
        }

        @Generated
        public ManagedAccount setCheckPermissionsOnStartup(boolean checkPermissionsOnStartup) {
            this.checkPermissionsOnStartup = checkPermissionsOnStartup;
            return this;
        }

        @Generated
        public ManagedAccount setCustomResources(List<CustomKubernetesResource> customResources) {
            this.customResources = customResources;
            return this;
        }

        @Generated
        public ManagedAccount setCachingPolicies(List<KubernetesCachingPolicy> cachingPolicies) {
            this.cachingPolicies = cachingPolicies;
            return this;
        }

        @Generated
        public ManagedAccount setKinds(List<String> kinds) {
            this.kinds = kinds;
            return this;
        }

        @Generated
        public ManagedAccount setOmitKinds(List<String> omitKinds) {
            this.omitKinds = omitKinds;
            return this;
        }

        @Generated
        public ManagedAccount setOnlySpinnakerManaged(boolean onlySpinnakerManaged) {
            this.onlySpinnakerManaged = onlySpinnakerManaged;
            return this;
        }

        @Generated
        public ManagedAccount setCacheIntervalSeconds(Long cacheIntervalSeconds) {
            this.cacheIntervalSeconds = cacheIntervalSeconds;
            return this;
        }

        @Generated
        public ManagedAccount setCacheAllApplicationRelationships(boolean cacheAllApplicationRelationships) {
            this.cacheAllApplicationRelationships = cacheAllApplicationRelationships;
            return this;
        }

        @Generated
        public ManagedAccount setRawResourcesEndpointConfig(RawResourcesEndpointConfig rawResourcesEndpointConfig) {
            this.rawResourcesEndpointConfig = rawResourcesEndpointConfig;
            return this;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ManagedAccount)) {
                return false;
            }
            ManagedAccount other = (ManagedAccount)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$environment = this.getEnvironment();
            String other$environment = other.getEnvironment();
            if (this$environment == null ? other$environment != null : !this$environment.equals(other$environment)) {
                return false;
            }
            String this$accountType = this.getAccountType();
            String other$accountType = other.getAccountType();
            if (this$accountType == null ? other$accountType != null : !this$accountType.equals(other$accountType)) {
                return false;
            }
            String this$context = this.getContext();
            String other$context = other.getContext();
            if (this$context == null ? other$context != null : !this$context.equals(other$context)) {
                return false;
            }
            String this$oAuthServiceAccount = this.getOAuthServiceAccount();
            String other$oAuthServiceAccount = other.getOAuthServiceAccount();
            if (this$oAuthServiceAccount == null ? other$oAuthServiceAccount != null : !this$oAuthServiceAccount.equals(other$oAuthServiceAccount)) {
                return false;
            }
            List<String> this$oAuthScopes = this.getOAuthScopes();
            List<String> other$oAuthScopes = other.getOAuthScopes();
            if (this$oAuthScopes == null ? other$oAuthScopes != null : !((Object)this$oAuthScopes).equals(other$oAuthScopes)) {
                return false;
            }
            String this$kubeconfigFile = this.getKubeconfigFile();
            String other$kubeconfigFile = other.getKubeconfigFile();
            if (this$kubeconfigFile == null ? other$kubeconfigFile != null : !this$kubeconfigFile.equals(other$kubeconfigFile)) {
                return false;
            }
            String this$kubeconfigContents = this.getKubeconfigContents();
            String other$kubeconfigContents = other.getKubeconfigContents();
            if (this$kubeconfigContents == null ? other$kubeconfigContents != null : !this$kubeconfigContents.equals(other$kubeconfigContents)) {
                return false;
            }
            String this$kubectlExecutable = this.getKubectlExecutable();
            String other$kubectlExecutable = other.getKubectlExecutable();
            if (this$kubectlExecutable == null ? other$kubectlExecutable != null : !this$kubectlExecutable.equals(other$kubectlExecutable)) {
                return false;
            }
            Integer this$kubectlRequestTimeoutSeconds = this.getKubectlRequestTimeoutSeconds();
            Integer other$kubectlRequestTimeoutSeconds = other.getKubectlRequestTimeoutSeconds();
            if (this$kubectlRequestTimeoutSeconds == null ? other$kubectlRequestTimeoutSeconds != null : !((Object)this$kubectlRequestTimeoutSeconds).equals(other$kubectlRequestTimeoutSeconds)) {
                return false;
            }
            if (this.isServiceAccount() != other.isServiceAccount()) {
                return false;
            }
            List<String> this$namespaces = this.getNamespaces();
            List<String> other$namespaces = other.getNamespaces();
            if (this$namespaces == null ? other$namespaces != null : !((Object)this$namespaces).equals(other$namespaces)) {
                return false;
            }
            List<String> this$omitNamespaces = this.getOmitNamespaces();
            List<String> other$omitNamespaces = other.getOmitNamespaces();
            if (this$omitNamespaces == null ? other$omitNamespaces != null : !((Object)this$omitNamespaces).equals(other$omitNamespaces)) {
                return false;
            }
            if (this.getCacheThreads() != other.getCacheThreads()) {
                return false;
            }
            List<String> this$requiredGroupMembership = this.getRequiredGroupMembership();
            List<String> other$requiredGroupMembership = other.getRequiredGroupMembership();
            if (this$requiredGroupMembership == null ? other$requiredGroupMembership != null : !((Object)this$requiredGroupMembership).equals(other$requiredGroupMembership)) {
                return false;
            }
            Permissions.Builder this$permissions = this.getPermissions();
            Permissions.Builder other$permissions = other.getPermissions();
            if (this$permissions == null ? other$permissions != null : !this$permissions.equals(other$permissions)) {
                return false;
            }
            String this$namingStrategy = this.getNamingStrategy();
            String other$namingStrategy = other.getNamingStrategy();
            if (this$namingStrategy == null ? other$namingStrategy != null : !this$namingStrategy.equals(other$namingStrategy)) {
                return false;
            }
            if (this.isDebug() != other.isDebug()) {
                return false;
            }
            if (this.isMetrics() != other.isMetrics()) {
                return false;
            }
            if (this.isCheckPermissionsOnStartup() != other.isCheckPermissionsOnStartup()) {
                return false;
            }
            List<CustomKubernetesResource> this$customResources = this.getCustomResources();
            List<CustomKubernetesResource> other$customResources = other.getCustomResources();
            if (this$customResources == null ? other$customResources != null : !((Object)this$customResources).equals(other$customResources)) {
                return false;
            }
            List<KubernetesCachingPolicy> this$cachingPolicies = this.getCachingPolicies();
            List<KubernetesCachingPolicy> other$cachingPolicies = other.getCachingPolicies();
            if (this$cachingPolicies == null ? other$cachingPolicies != null : !((Object)this$cachingPolicies).equals(other$cachingPolicies)) {
                return false;
            }
            List<String> this$kinds = this.getKinds();
            List<String> other$kinds = other.getKinds();
            if (this$kinds == null ? other$kinds != null : !((Object)this$kinds).equals(other$kinds)) {
                return false;
            }
            List<String> this$omitKinds = this.getOmitKinds();
            List<String> other$omitKinds = other.getOmitKinds();
            if (this$omitKinds == null ? other$omitKinds != null : !((Object)this$omitKinds).equals(other$omitKinds)) {
                return false;
            }
            if (this.isOnlySpinnakerManaged() != other.isOnlySpinnakerManaged()) {
                return false;
            }
            Long this$cacheIntervalSeconds = this.getCacheIntervalSeconds();
            Long other$cacheIntervalSeconds = other.getCacheIntervalSeconds();
            if (this$cacheIntervalSeconds == null ? other$cacheIntervalSeconds != null : !((Object)this$cacheIntervalSeconds).equals(other$cacheIntervalSeconds)) {
                return false;
            }
            if (this.isCacheAllApplicationRelationships() != other.isCacheAllApplicationRelationships()) {
                return false;
            }
            RawResourcesEndpointConfig this$rawResourcesEndpointConfig = this.getRawResourcesEndpointConfig();
            RawResourcesEndpointConfig other$rawResourcesEndpointConfig = other.getRawResourcesEndpointConfig();
            return !(this$rawResourcesEndpointConfig == null ? other$rawResourcesEndpointConfig != null : !((Object)this$rawResourcesEndpointConfig).equals(other$rawResourcesEndpointConfig));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ManagedAccount;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $environment = this.getEnvironment();
            result = result * 59 + ($environment == null ? 43 : $environment.hashCode());
            String $accountType = this.getAccountType();
            result = result * 59 + ($accountType == null ? 43 : $accountType.hashCode());
            String $context = this.getContext();
            result = result * 59 + ($context == null ? 43 : $context.hashCode());
            String $oAuthServiceAccount = this.getOAuthServiceAccount();
            result = result * 59 + ($oAuthServiceAccount == null ? 43 : $oAuthServiceAccount.hashCode());
            List<String> $oAuthScopes = this.getOAuthScopes();
            result = result * 59 + ($oAuthScopes == null ? 43 : ((Object)$oAuthScopes).hashCode());
            String $kubeconfigFile = this.getKubeconfigFile();
            result = result * 59 + ($kubeconfigFile == null ? 43 : $kubeconfigFile.hashCode());
            String $kubeconfigContents = this.getKubeconfigContents();
            result = result * 59 + ($kubeconfigContents == null ? 43 : $kubeconfigContents.hashCode());
            String $kubectlExecutable = this.getKubectlExecutable();
            result = result * 59 + ($kubectlExecutable == null ? 43 : $kubectlExecutable.hashCode());
            Integer $kubectlRequestTimeoutSeconds = this.getKubectlRequestTimeoutSeconds();
            result = result * 59 + ($kubectlRequestTimeoutSeconds == null ? 43 : ((Object)$kubectlRequestTimeoutSeconds).hashCode());
            result = result * 59 + (this.isServiceAccount() ? 79 : 97);
            List<String> $namespaces = this.getNamespaces();
            result = result * 59 + ($namespaces == null ? 43 : ((Object)$namespaces).hashCode());
            List<String> $omitNamespaces = this.getOmitNamespaces();
            result = result * 59 + ($omitNamespaces == null ? 43 : ((Object)$omitNamespaces).hashCode());
            result = result * 59 + this.getCacheThreads();
            List<String> $requiredGroupMembership = this.getRequiredGroupMembership();
            result = result * 59 + ($requiredGroupMembership == null ? 43 : ((Object)$requiredGroupMembership).hashCode());
            Permissions.Builder $permissions = this.getPermissions();
            result = result * 59 + ($permissions == null ? 43 : $permissions.hashCode());
            String $namingStrategy = this.getNamingStrategy();
            result = result * 59 + ($namingStrategy == null ? 43 : $namingStrategy.hashCode());
            result = result * 59 + (this.isDebug() ? 79 : 97);
            result = result * 59 + (this.isMetrics() ? 79 : 97);
            result = result * 59 + (this.isCheckPermissionsOnStartup() ? 79 : 97);
            List<CustomKubernetesResource> $customResources = this.getCustomResources();
            result = result * 59 + ($customResources == null ? 43 : ((Object)$customResources).hashCode());
            List<KubernetesCachingPolicy> $cachingPolicies = this.getCachingPolicies();
            result = result * 59 + ($cachingPolicies == null ? 43 : ((Object)$cachingPolicies).hashCode());
            List<String> $kinds = this.getKinds();
            result = result * 59 + ($kinds == null ? 43 : ((Object)$kinds).hashCode());
            List<String> $omitKinds = this.getOmitKinds();
            result = result * 59 + ($omitKinds == null ? 43 : ((Object)$omitKinds).hashCode());
            result = result * 59 + (this.isOnlySpinnakerManaged() ? 79 : 97);
            Long $cacheIntervalSeconds = this.getCacheIntervalSeconds();
            result = result * 59 + ($cacheIntervalSeconds == null ? 43 : ((Object)$cacheIntervalSeconds).hashCode());
            result = result * 59 + (this.isCacheAllApplicationRelationships() ? 79 : 97);
            RawResourcesEndpointConfig $rawResourcesEndpointConfig = this.getRawResourcesEndpointConfig();
            result = result * 59 + ($rawResourcesEndpointConfig == null ? 43 : ((Object)$rawResourcesEndpointConfig).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "KubernetesConfigurationProperties.ManagedAccount(name=" + this.getName() + ", environment=" + this.getEnvironment() + ", accountType=" + this.getAccountType() + ", context=" + this.getContext() + ", oAuthServiceAccount=" + this.getOAuthServiceAccount() + ", oAuthScopes=" + this.getOAuthScopes() + ", kubeconfigFile=" + this.getKubeconfigFile() + ", kubeconfigContents=" + this.getKubeconfigContents() + ", kubectlExecutable=" + this.getKubectlExecutable() + ", kubectlRequestTimeoutSeconds=" + this.getKubectlRequestTimeoutSeconds() + ", serviceAccount=" + this.isServiceAccount() + ", namespaces=" + this.getNamespaces() + ", omitNamespaces=" + this.getOmitNamespaces() + ", cacheThreads=" + this.getCacheThreads() + ", requiredGroupMembership=" + this.getRequiredGroupMembership() + ", permissions=" + this.getPermissions() + ", namingStrategy=" + this.getNamingStrategy() + ", debug=" + this.isDebug() + ", metrics=" + this.isMetrics() + ", checkPermissionsOnStartup=" + this.isCheckPermissionsOnStartup() + ", customResources=" + this.getCustomResources() + ", cachingPolicies=" + this.getCachingPolicies() + ", kinds=" + this.getKinds() + ", omitKinds=" + this.getOmitKinds() + ", onlySpinnakerManaged=" + this.isOnlySpinnakerManaged() + ", cacheIntervalSeconds=" + this.getCacheIntervalSeconds() + ", cacheAllApplicationRelationships=" + this.isCacheAllApplicationRelationships() + ", rawResourcesEndpointConfig=" + this.getRawResourcesEndpointConfig() + ")";
        }
    }
}

