/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.controllers;

import com.netflix.spinnaker.clouddriver.kubernetes.caching.view.model.KubernetesRawResource;
import com.netflix.spinnaker.clouddriver.kubernetes.caching.view.provider.KubernetesRawResourceProvider;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(produces={"application/json"})
class RawResourceController {
    private final KubernetesRawResourceProvider rawResourceProvider;

    @Autowired
    public RawResourceController(KubernetesRawResourceProvider rawResourceProvider) {
        this.rawResourceProvider = rawResourceProvider;
    }

    @PreAuthorize(value="hasPermission(#application, 'APPLICATION', 'READ')")
    @PostAuthorize(value="@authorizationSupport.filterForAccounts(returnObject)")
    @RequestMapping(value={"/applications/{application}/rawResources"}, method={RequestMethod.GET})
    List<KubernetesRawResource> list(@PathVariable String application) {
        return new ArrayList<KubernetesRawResource>(this.rawResourceProvider.getApplicationRawResources(application));
    }
}

