/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.converter.job;

import com.netflix.spinnaker.clouddriver.kubernetes.KubernetesOperation;
import com.netflix.spinnaker.clouddriver.kubernetes.artifact.ResourceVersioner;
import com.netflix.spinnaker.clouddriver.kubernetes.deploy.converters.KubernetesAtomicOperationConverterHelper;
import com.netflix.spinnaker.clouddriver.kubernetes.description.job.KubernetesRunJobOperationDescription;
import com.netflix.spinnaker.clouddriver.kubernetes.op.job.KubernetesRunJobDeploymentResult;
import com.netflix.spinnaker.clouddriver.kubernetes.op.job.KubernetesRunJobOperation;
import com.netflix.spinnaker.clouddriver.kubernetes.security.KubernetesNamedAccountCredentials;
import com.netflix.spinnaker.clouddriver.orchestration.AtomicOperation;
import com.netflix.spinnaker.clouddriver.security.AbstractAtomicOperationsCredentialsConverter;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@KubernetesOperation(value="runJob")
@Component
public class KubernetesRunJobOperationConverter
extends AbstractAtomicOperationsCredentialsConverter<KubernetesNamedAccountCredentials> {
    private final ResourceVersioner resourceVersioner;
    private final boolean appendSuffix;

    @Autowired
    public KubernetesRunJobOperationConverter(ResourceVersioner resourceVersioner, @Value(value="${kubernetes.jobs.append-suffix:false}") boolean appendSuffix) {
        this.resourceVersioner = resourceVersioner;
        this.appendSuffix = appendSuffix;
    }

    public AtomicOperation<KubernetesRunJobDeploymentResult> convertOperation(Map<String, Object> input) {
        return new KubernetesRunJobOperation((KubernetesRunJobOperationDescription)this.convertDescription((Map)input), this.resourceVersioner, this.appendSuffix);
    }

    public KubernetesRunJobOperationDescription convertDescription(Map<String, Object> input) {
        return KubernetesAtomicOperationConverterHelper.convertDescription(input, this, KubernetesRunJobOperationDescription.class);
    }
}

