/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.description;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMap;
import com.netflix.spinnaker.clouddriver.kubernetes.description.KubernetesResourceProperties;
import com.netflix.spinnaker.clouddriver.kubernetes.description.ResourcePropertyRegistry;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesKind;
import com.netflix.spinnaker.clouddriver.kubernetes.op.handler.KubernetesHandler;
import com.netflix.spinnaker.clouddriver.kubernetes.op.handler.KubernetesUnregisteredCustomResourceHandler;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ParametersAreNonnullByDefault
public class GlobalResourcePropertyRegistry
implements ResourcePropertyRegistry {
    private final ImmutableMap<KubernetesKind, KubernetesResourceProperties> globalProperties;
    private final KubernetesResourceProperties defaultProperties;

    @Autowired
    public GlobalResourcePropertyRegistry(List<KubernetesHandler> handlers, KubernetesUnregisteredCustomResourceHandler defaultHandler) {
        this.globalProperties = (ImmutableMap)handlers.stream().collect(ImmutableMap.toImmutableMap(KubernetesHandler::kind, h -> new KubernetesResourceProperties((KubernetesHandler)h, h.versioned())));
        this.defaultProperties = new KubernetesResourceProperties(defaultHandler, defaultHandler.versioned());
    }

    @Override
    @Nonnull
    public KubernetesResourceProperties get(KubernetesKind kind) {
        KubernetesResourceProperties globalResult = (KubernetesResourceProperties)this.globalProperties.get((Object)kind);
        if (globalResult != null) {
            return globalResult;
        }
        return this.defaultProperties;
    }

    @Override
    @Nonnull
    public ImmutableCollection<KubernetesResourceProperties> values() {
        return this.globalProperties.values();
    }
}

