/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.description.manifest;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesApiGroup;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;

public class KubernetesApiVersion {
    public static final KubernetesApiVersion V1 = new KubernetesApiVersion("v1");
    public static final KubernetesApiVersion EXTENSIONS_V1BETA1 = new KubernetesApiVersion("extensions/v1beta1");
    public static final KubernetesApiVersion NETWORKING_K8S_IO_V1 = new KubernetesApiVersion("networking.k8s.io/v1");
    public static final KubernetesApiVersion NETWORKING_K8S_IO_V1BETA1 = new KubernetesApiVersion("networking.k8s.io/v1beta1");
    public static final KubernetesApiVersion APPS_V1 = new KubernetesApiVersion("apps/v1");
    public static final KubernetesApiVersion APPS_V1BETA1 = new KubernetesApiVersion("apps/v1beta1");
    public static final KubernetesApiVersion APPS_V1BETA2 = new KubernetesApiVersion("apps/v1beta2");
    public static final KubernetesApiVersion BATCH_V1 = new KubernetesApiVersion("batch/v1");
    public static final KubernetesApiVersion NONE = new KubernetesApiVersion("");
    @Nonnull
    private final String name;
    @Nonnull
    private final KubernetesApiGroup apiGroup;

    private KubernetesApiVersion(@Nonnull String name) {
        this.name = name.toLowerCase();
        this.apiGroup = KubernetesApiVersion.parseApiGroup(this.name);
    }

    @JsonValue
    public String toString() {
        return this.name;
    }

    @Nonnull
    private static KubernetesApiGroup parseApiGroup(@Nonnull String name) {
        int index = name.indexOf(47);
        if (index > 0) {
            return KubernetesApiGroup.fromString(name.substring(0, index));
        }
        return KubernetesApiGroup.NONE;
    }

    @JsonCreator
    @Nonnull
    public static KubernetesApiVersion fromString(@Nullable String name) {
        if (name == null) {
            return NONE;
        }
        return new KubernetesApiVersion(name);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KubernetesApiVersion)) {
            return false;
        }
        KubernetesApiVersion other = (KubernetesApiVersion)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.name;
        String other$name = other.name;
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof KubernetesApiVersion;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.name;
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    @Nonnull
    @Generated
    public KubernetesApiGroup getApiGroup() {
        return this.apiGroup;
    }
}

