/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.description.manifest;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterators;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesApiGroup;
import com.netflix.spinnaker.kork.annotations.NonnullByDefault;
import io.kubernetes.client.openapi.models.V1beta1CustomResourceDefinition;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import lombok.Generated;

@NonnullByDefault
public class KubernetesKind {
    private static final Splitter QUALIFIED_KIND_SPLITTER = Splitter.on((char)'.').limit(2);
    private static final Map<KubernetesKind, KubernetesKind> aliasMap = new ConcurrentHashMap<KubernetesKind, KubernetesKind>();
    public static final KubernetesKind API_SERVICE = KubernetesKind.createWithAlias("apiService", null, KubernetesApiGroup.APIREGISTRATION_K8S_IO);
    public static final KubernetesKind CLUSTER_ROLE = KubernetesKind.createWithAlias("clusterRole", null, KubernetesApiGroup.RBAC_AUTHORIZATION_K8S_IO);
    public static final KubernetesKind CLUSTER_ROLE_BINDING = KubernetesKind.createWithAlias("clusterRoleBinding", null, KubernetesApiGroup.RBAC_AUTHORIZATION_K8S_IO);
    public static final KubernetesKind CONFIG_MAP = KubernetesKind.createWithAlias("configMap", "cm", KubernetesApiGroup.CORE);
    public static final KubernetesKind CONTROLLER_REVISION = KubernetesKind.createWithAlias("controllerRevision", null, KubernetesApiGroup.APPS);
    public static final KubernetesKind CUSTOM_RESOURCE_DEFINITION = KubernetesKind.createWithAlias("customResourceDefinition", "crd", KubernetesApiGroup.EXTENSIONS);
    public static final KubernetesKind CRON_JOB = KubernetesKind.createWithAlias("cronJob", null, KubernetesApiGroup.BATCH);
    public static final KubernetesKind DAEMON_SET = KubernetesKind.createWithAlias("daemonSet", "ds", KubernetesApiGroup.APPS);
    public static final KubernetesKind DEPLOYMENT = KubernetesKind.createWithAlias("deployment", "deploy", KubernetesApiGroup.APPS);
    public static final KubernetesKind EVENT = KubernetesKind.createWithAlias("event", null, KubernetesApiGroup.CORE);
    public static final KubernetesKind HORIZONTAL_POD_AUTOSCALER = KubernetesKind.createWithAlias("horizontalpodautoscaler", "hpa", KubernetesApiGroup.AUTOSCALING);
    public static final KubernetesKind INGRESS = KubernetesKind.createWithAlias("ingress", null, KubernetesApiGroup.NETWORKING_K8S_IO);
    public static final KubernetesKind JOB = KubernetesKind.createWithAlias("job", null, KubernetesApiGroup.BATCH);
    public static final KubernetesKind LIMIT_RANGE = KubernetesKind.createWithAlias("limitRange", null, KubernetesApiGroup.NONE);
    public static final KubernetesKind MUTATING_WEBHOOK_CONFIGURATION = KubernetesKind.createWithAlias("mutatingWebhookConfiguration", null, KubernetesApiGroup.ADMISSIONREGISTRATION_K8S_IO);
    public static final KubernetesKind NAMESPACE = KubernetesKind.createWithAlias("namespace", "ns", KubernetesApiGroup.CORE);
    public static final KubernetesKind NETWORK_POLICY = KubernetesKind.createWithAlias("networkPolicy", "netpol", KubernetesApiGroup.NETWORKING_K8S_IO);
    public static final KubernetesKind PERSISTENT_VOLUME = KubernetesKind.createWithAlias("persistentVolume", "pv", KubernetesApiGroup.CORE);
    public static final KubernetesKind PERSISTENT_VOLUME_CLAIM = KubernetesKind.createWithAlias("persistentVolumeClaim", "pvc", KubernetesApiGroup.CORE);
    public static final KubernetesKind POD = KubernetesKind.createWithAlias("pod", "po", KubernetesApiGroup.CORE);
    public static final KubernetesKind POD_PRESET = KubernetesKind.createWithAlias("podPreset", null, KubernetesApiGroup.SETTINGS_K8S_IO);
    public static final KubernetesKind POD_SECURITY_POLICY = KubernetesKind.createWithAlias("podSecurityPolicy", null, KubernetesApiGroup.POLICY);
    public static final KubernetesKind POD_DISRUPTION_BUDGET = KubernetesKind.createWithAlias("podDisruptionBudget", null, KubernetesApiGroup.POLICY);
    public static final KubernetesKind REPLICA_SET = KubernetesKind.createWithAlias("replicaSet", "rs", KubernetesApiGroup.APPS);
    public static final KubernetesKind ROLE = KubernetesKind.createWithAlias("role", null, KubernetesApiGroup.RBAC_AUTHORIZATION_K8S_IO);
    public static final KubernetesKind ROLE_BINDING = KubernetesKind.createWithAlias("roleBinding", null, KubernetesApiGroup.RBAC_AUTHORIZATION_K8S_IO);
    public static final KubernetesKind SECRET = KubernetesKind.createWithAlias("secret", null, KubernetesApiGroup.CORE);
    public static final KubernetesKind SERVICE = KubernetesKind.createWithAlias("service", "svc", KubernetesApiGroup.CORE);
    public static final KubernetesKind SERVICE_ACCOUNT = KubernetesKind.createWithAlias("serviceAccount", "sa", KubernetesApiGroup.CORE);
    public static final KubernetesKind STATEFUL_SET = KubernetesKind.createWithAlias("statefulSet", null, KubernetesApiGroup.APPS);
    public static final KubernetesKind STORAGE_CLASS = KubernetesKind.createWithAlias("storageClass", "sc", KubernetesApiGroup.STORAGE_K8S_IO);
    public static final KubernetesKind VALIDATING_WEBHOOK_CONFIGURATION = KubernetesKind.createWithAlias("validatingWebhookConfiguration", null, KubernetesApiGroup.ADMISSIONREGISTRATION_K8S_IO);
    public static final KubernetesKind NONE = KubernetesKind.createWithAlias("none", null, KubernetesApiGroup.NONE);
    private final String name;
    private final String lcName;
    private final KubernetesApiGroup apiGroup;
    @Nullable
    private final KubernetesApiGroup customApiGroup;

    private KubernetesKind(String name, @Nullable KubernetesApiGroup apiGroup) {
        this.name = name;
        this.lcName = name.toLowerCase();
        this.apiGroup = apiGroup == null ? KubernetesApiGroup.NONE : apiGroup;
        this.customApiGroup = this.apiGroup.isNativeGroup() ? null : apiGroup;
    }

    private static KubernetesKind createWithAlias(String name, @Nullable String alias, @Nullable KubernetesApiGroup apiGroup) {
        KubernetesKind kind = new KubernetesKind(name, apiGroup);
        aliasMap.put(kind, kind);
        if (alias != null) {
            aliasMap.put(new KubernetesKind(alias, apiGroup), kind);
        }
        return kind;
    }

    public static KubernetesKind from(@Nullable String name, @Nullable KubernetesApiGroup apiGroup) {
        if (name == null || name.isEmpty()) {
            return NONE;
        }
        KubernetesKind result = new KubernetesKind(name, apiGroup);
        return aliasMap.getOrDefault(result, result);
    }

    public static KubernetesKind fromCustomResourceDefinition(V1beta1CustomResourceDefinition crd) {
        return KubernetesKind.from(crd.getSpec().getNames().getKind(), KubernetesApiGroup.fromString(crd.getSpec().getGroup()));
    }

    @JsonCreator
    public static KubernetesKind fromString(String qualifiedKind) {
        Iterator parts = QUALIFIED_KIND_SPLITTER.split((CharSequence)qualifiedKind).iterator();
        String kindName = (String)parts.next();
        String apiGroup = (String)Iterators.getNext(parts, null);
        return KubernetesKind.from(kindName, KubernetesApiGroup.fromString(apiGroup));
    }

    @JsonValue
    public String toString() {
        if (this.apiGroup.isNativeGroup()) {
            return this.name;
        }
        return this.name + "." + this.apiGroup.toString();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KubernetesKind)) {
            return false;
        }
        KubernetesKind other = (KubernetesKind)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$lcName = this.lcName;
        String other$lcName = other.lcName;
        if (this$lcName == null ? other$lcName != null : !this$lcName.equals(other$lcName)) {
            return false;
        }
        KubernetesApiGroup this$customApiGroup = this.customApiGroup;
        KubernetesApiGroup other$customApiGroup = other.customApiGroup;
        return !(this$customApiGroup == null ? other$customApiGroup != null : !((Object)this$customApiGroup).equals(other$customApiGroup));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof KubernetesKind;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $lcName = this.lcName;
        result = result * 59 + ($lcName == null ? 43 : $lcName.hashCode());
        KubernetesApiGroup $customApiGroup = this.customApiGroup;
        result = result * 59 + ($customApiGroup == null ? 43 : ((Object)$customApiGroup).hashCode());
        return result;
    }
}

