/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.description.manifest;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.netflix.spinnaker.clouddriver.kubernetes.description.KubernetesCoordinates;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesApiGroup;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesApiVersion;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesKind;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesManifestSelector;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.MalformedManifestException;
import java.time.Instant;
import java.time.format.DateTimeParseException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesManifest
extends HashMap<String, Object> {
    private static final Logger log = LoggerFactory.getLogger(KubernetesManifest.class);
    private static final ObjectMapper mapper = new ObjectMapper();
    @Nullable
    private transient KubernetesKind computedKind;

    @Override
    public KubernetesManifest clone() {
        return (KubernetesManifest)super.clone();
    }

    @JsonIgnore
    @Nonnull
    public KubernetesKind getKind() {
        if (this.computedKind == null) {
            this.computedKind = this.computeKind();
        }
        return this.computedKind;
    }

    @Nonnull
    private KubernetesKind computeKind() {
        String kindName = this.getKindName();
        KubernetesApiGroup kubernetesApiGroup = this.containsKey("apiVersion") ? this.getApiVersion().getApiGroup() : null;
        return KubernetesKind.from(kindName, kubernetesApiGroup);
    }

    @JsonIgnore
    public String getKindName() {
        return Optional.ofNullable((String)this.get("kind")).orElseThrow(() -> MalformedManifestException.missingField(this, "kind"));
    }

    @JsonIgnore
    public void setKind(KubernetesKind kind) {
        this.put("kind", kind.toString());
        this.computedKind = null;
    }

    @JsonIgnore
    public KubernetesApiVersion getApiVersion() {
        return Optional.ofNullable((String)this.get("apiVersion")).map(KubernetesApiVersion::fromString).orElseThrow(() -> MalformedManifestException.missingField(this, "apiVersion"));
    }

    @JsonIgnore
    public void setApiVersion(KubernetesApiVersion apiVersion) {
        this.put("apiVersion", apiVersion.toString());
        this.computedKind = null;
    }

    @JsonIgnore
    private Map<String, Object> getMetadata() {
        return Optional.ofNullable((Map)this.get("metadata")).orElseThrow(() -> MalformedManifestException.missingField(this, "metadata"));
    }

    @JsonIgnore
    public String getName() {
        return (String)this.getMetadata().get("name");
    }

    @JsonIgnore
    public boolean hasGenerateName() {
        if (!Strings.isNullOrEmpty((String)this.getName())) {
            return false;
        }
        return !Strings.isNullOrEmpty((String)((String)this.getMetadata().get("generateName")));
    }

    @JsonIgnore
    public String getUid() {
        return (String)this.getMetadata().get("uid");
    }

    @JsonIgnore
    public void setName(String name) {
        this.getMetadata().put("name", name);
    }

    @JsonIgnore
    @Nonnull
    public String getNamespace() {
        String namespace = (String)this.getMetadata().get("namespace");
        return Strings.nullToEmpty((String)namespace);
    }

    @JsonIgnore
    public void setNamespace(String namespace) {
        this.getMetadata().put("namespace", namespace);
    }

    @JsonIgnore
    @Nonnull
    public String getCreationTimestamp() {
        Object timestamp = this.getMetadata().get("creationTimestamp");
        if (timestamp == null) {
            return "";
        }
        return timestamp.toString();
    }

    @JsonIgnore
    @Nullable
    public Long getCreationTimestampEpochMillis() {
        try {
            return Instant.parse(this.getCreationTimestamp()).toEpochMilli();
        }
        catch (DateTimeParseException e) {
            log.warn("Failed to parse timestamp: ", (Throwable)e);
            return null;
        }
    }

    @JsonIgnore
    @Nonnull
    public List<OwnerReference> getOwnerReferences() {
        Map<String, Object> metadata = this.getMetadata();
        return Optional.ofNullable(metadata.get("ownerReferences")).map(r -> (List)mapper.convertValue(r, (TypeReference)new TypeReference<List<OwnerReference>>(){})).orElseGet(ImmutableList::of);
    }

    @JsonIgnore
    public KubernetesManifestSelector getManifestSelector() {
        if (!this.containsKey("spec")) {
            return null;
        }
        Map spec = (Map)this.get("spec");
        if (!spec.containsKey("selector")) {
            return null;
        }
        Map selector = (Map)spec.get("selector");
        if (!selector.containsKey("matchExpressions") && !selector.containsKey("matchLabels")) {
            return new KubernetesManifestSelector().setMatchLabels((Map)spec.get("selector"));
        }
        return (KubernetesManifestSelector)mapper.convertValue((Object)selector, KubernetesManifestSelector.class);
    }

    @JsonIgnore
    public Map<String, String> getLabels() {
        HashMap result = (HashMap)this.getMetadata().get("labels");
        if (result == null) {
            result = new HashMap();
            this.getMetadata().put("labels", result);
        }
        return result;
    }

    @JsonIgnore
    public Map<String, String> getAnnotations() {
        HashMap result = (HashMap)this.getMetadata().get("annotations");
        if (result == null) {
            result = new HashMap();
            this.getMetadata().put("annotations", result);
        }
        return result;
    }

    @JsonIgnore
    public Double getReplicas() {
        if (!this.containsKey("spec")) {
            return null;
        }
        Map spec = (Map)this.get("spec");
        if (!spec.containsKey("replicas")) {
            return null;
        }
        return (Double)spec.get("replicas");
    }

    @JsonIgnore
    public void setReplicas(Double replicas) {
        if (!this.containsKey("spec")) {
            return;
        }
        Map spec = (Map)this.get("spec");
        if (!spec.containsKey("replicas")) {
            return;
        }
        spec.put("replicas", replicas);
    }

    @JsonIgnore
    public Optional<Map<String, String>> getSpecTemplateLabels() {
        if (!this.containsKey("spec")) {
            return Optional.empty();
        }
        Map spec = (Map)this.get("spec");
        if (!spec.containsKey("template")) {
            return Optional.empty();
        }
        if (!(spec.get("template") instanceof Map)) {
            return Optional.empty();
        }
        Map template = (Map)spec.get("template");
        if (!template.containsKey("metadata")) {
            return Optional.empty();
        }
        Map metadata = (Map)template.get("metadata");
        if (metadata == null) {
            return Optional.empty();
        }
        HashMap result = (HashMap)metadata.get("labels");
        if (result == null) {
            result = new HashMap();
            metadata.put("labels", result);
        }
        return Optional.of(result);
    }

    @JsonIgnore
    public Optional<Map<String, String>> getSpecTemplateAnnotations() {
        if (!this.containsKey("spec")) {
            return Optional.empty();
        }
        Map spec = (Map)this.get("spec");
        if (!spec.containsKey("template")) {
            return Optional.empty();
        }
        if (!(spec.get("template") instanceof Map)) {
            return Optional.empty();
        }
        Map template = (Map)spec.get("template");
        if (!template.containsKey("metadata")) {
            return Optional.empty();
        }
        Map metadata = (Map)template.get("metadata");
        if (metadata == null) {
            return Optional.empty();
        }
        HashMap result = (HashMap)metadata.get("annotations");
        if (result == null) {
            result = new HashMap();
            metadata.put("annotations", result);
        }
        return Optional.of(result);
    }

    @JsonIgnore
    public Object getStatus() {
        return this.get("status");
    }

    @JsonIgnore
    public String getFullResourceName() {
        return KubernetesManifest.getFullResourceName(this.getKind(), this.getName());
    }

    public static String getFullResourceName(KubernetesKind kind, String name) {
        return String.join((CharSequence)" ", kind.toString(), name);
    }

    public boolean nonMetadataEquals(KubernetesManifest other) {
        if (other == null) {
            return false;
        }
        KubernetesManifest cloneThis = this.clone();
        KubernetesManifest cloneOther = other.clone();
        cloneThis.remove("metadata");
        cloneOther.remove("metadata");
        return cloneThis.equals(cloneOther);
    }

    @Deprecated
    public static Pair<KubernetesKind, String> fromFullResourceName(String fullResourceName) {
        KubernetesCoordinates coords = KubernetesCoordinates.builder().fullResourceName(fullResourceName).build();
        return new ImmutablePair((Object)coords.getKind(), (Object)coords.getName());
    }

    public static class OwnerReference {
        KubernetesApiVersion apiVersion;
        String kind;
        String name;
        String uid;
        boolean blockOwnerDeletion;
        boolean controller;

        public KubernetesKind computedKind() {
            KubernetesApiGroup kubernetesApiGroup = this.apiVersion != null ? this.getApiVersion().getApiGroup() : null;
            return KubernetesKind.from(this.kind, kubernetesApiGroup);
        }

        @Generated
        public OwnerReference() {
        }

        @Generated
        public KubernetesApiVersion getApiVersion() {
            return this.apiVersion;
        }

        @Generated
        public String getKind() {
            return this.kind;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getUid() {
            return this.uid;
        }

        @Generated
        public boolean isBlockOwnerDeletion() {
            return this.blockOwnerDeletion;
        }

        @Generated
        public boolean isController() {
            return this.controller;
        }

        @Generated
        public OwnerReference setApiVersion(KubernetesApiVersion apiVersion) {
            this.apiVersion = apiVersion;
            return this;
        }

        @Generated
        public OwnerReference setKind(String kind) {
            this.kind = kind;
            return this;
        }

        @Generated
        public OwnerReference setName(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public OwnerReference setUid(String uid) {
            this.uid = uid;
            return this;
        }

        @Generated
        public OwnerReference setBlockOwnerDeletion(boolean blockOwnerDeletion) {
            this.blockOwnerDeletion = blockOwnerDeletion;
            return this;
        }

        @Generated
        public OwnerReference setController(boolean controller) {
            this.controller = controller;
            return this;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof OwnerReference)) {
                return false;
            }
            OwnerReference other = (OwnerReference)o;
            if (!other.canEqual(this)) {
                return false;
            }
            KubernetesApiVersion this$apiVersion = this.getApiVersion();
            KubernetesApiVersion other$apiVersion = other.getApiVersion();
            if (this$apiVersion == null ? other$apiVersion != null : !((Object)this$apiVersion).equals(other$apiVersion)) {
                return false;
            }
            String this$kind = this.getKind();
            String other$kind = other.getKind();
            if (this$kind == null ? other$kind != null : !this$kind.equals(other$kind)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$uid = this.getUid();
            String other$uid = other.getUid();
            if (this$uid == null ? other$uid != null : !this$uid.equals(other$uid)) {
                return false;
            }
            if (this.isBlockOwnerDeletion() != other.isBlockOwnerDeletion()) {
                return false;
            }
            return this.isController() == other.isController();
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof OwnerReference;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            KubernetesApiVersion $apiVersion = this.getApiVersion();
            result = result * 59 + ($apiVersion == null ? 43 : ((Object)$apiVersion).hashCode());
            String $kind = this.getKind();
            result = result * 59 + ($kind == null ? 43 : $kind.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $uid = this.getUid();
            result = result * 59 + ($uid == null ? 43 : $uid.hashCode());
            result = result * 59 + (this.isBlockOwnerDeletion() ? 79 : 97);
            result = result * 59 + (this.isController() ? 79 : 97);
            return result;
        }

        @Generated
        public String toString() {
            return "KubernetesManifest.OwnerReference(apiVersion=" + this.getApiVersion() + ", kind=" + this.getKind() + ", name=" + this.getName() + ", uid=" + this.getUid() + ", blockOwnerDeletion=" + this.isBlockOwnerDeletion() + ", controller=" + this.isController() + ")";
        }
    }
}

