/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.names;

import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesManifest;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesManifestAnnotater;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesManifestLabeler;
import com.netflix.spinnaker.clouddriver.names.NamingStrategy;
import com.netflix.spinnaker.moniker.Moniker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class KubernetesManifestNamer
implements NamingStrategy<KubernetesManifest> {
    private final boolean applyAppLabels;
    private final String managedBySuffix;

    @Autowired
    public KubernetesManifestNamer(@Value(value="${kubernetes.v2.apply-app-labels:true}") boolean applyAppLabels, @Value(value="${kubernetes.v2.managed-by-suffix:}") String managedBySuffix) {
        this.applyAppLabels = applyAppLabels;
        this.managedBySuffix = managedBySuffix;
    }

    public KubernetesManifestNamer() {
        this(true, "");
    }

    public String getName() {
        return "kubernetesAnnotations";
    }

    public void applyMoniker(KubernetesManifest obj, Moniker moniker) {
        KubernetesManifestAnnotater.annotateManifest(obj, moniker);
        if (this.applyAppLabels) {
            KubernetesManifestLabeler.labelManifest(this.managedBySuffix, obj, moniker);
        }
    }

    public Moniker deriveMoniker(KubernetesManifest obj) {
        return KubernetesManifestAnnotater.getMoniker(obj);
    }
}

