/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.op.handler;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.netflix.spinnaker.clouddriver.kubernetes.caching.agent.KubernetesCacheDataConverter;
import com.netflix.spinnaker.clouddriver.kubernetes.caching.agent.KubernetesCachingAgentFactory;
import com.netflix.spinnaker.clouddriver.kubernetes.caching.agent.KubernetesCoreCachingAgent;
import com.netflix.spinnaker.clouddriver.kubernetes.description.SpinnakerKind;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesApiVersion;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesKind;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesManifest;
import com.netflix.spinnaker.clouddriver.kubernetes.model.Manifest;
import com.netflix.spinnaker.clouddriver.kubernetes.op.handler.KubernetesHandler;
import io.kubernetes.client.openapi.models.V1Event;
import io.kubernetes.client.openapi.models.V1ObjectReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.springframework.stereotype.Component;

@Component
public class KubernetesEventHandler
extends KubernetesHandler {
    @Override
    public int deployPriority() {
        throw new IllegalStateException("Events cannot be deployed.");
    }

    @Override
    @Nonnull
    public KubernetesKind kind() {
        return KubernetesKind.EVENT;
    }

    @Override
    public boolean versioned() {
        return false;
    }

    @Override
    @Nonnull
    public SpinnakerKind spinnakerKind() {
        return SpinnakerKind.UNCLASSIFIED;
    }

    @Override
    public Manifest.Status status(KubernetesManifest manifest) {
        return Manifest.Status.defaultStatus();
    }

    @Override
    protected KubernetesCachingAgentFactory cachingAgentFactory() {
        return KubernetesCoreCachingAgent::new;
    }

    @Override
    public void addRelationships(Map<KubernetesKind, List<KubernetesManifest>> allResources, Map<KubernetesManifest, List<KubernetesManifest>> relationshipMap) {
        relationshipMap.putAll(((List)allResources.getOrDefault(KubernetesKind.EVENT, new ArrayList())).stream().map(m -> ImmutablePair.of((Object)m, (Object)this.involvedManifest(KubernetesCacheDataConverter.getResource(m, V1Event.class)))).filter(p -> p.getRight() != null).collect(Collectors.toMap(ImmutablePair::getLeft, p -> ImmutableList.of((Object)((KubernetesManifest)p.getRight())))));
    }

    private KubernetesManifest involvedManifest(V1Event event) {
        if (event == null) {
            return null;
        }
        V1ObjectReference ref = event.getInvolvedObject();
        if (ref == null || Strings.isNullOrEmpty((String)ref.getApiVersion()) || Strings.isNullOrEmpty((String)ref.getKind()) || Strings.isNullOrEmpty((String)ref.getName())) {
            return null;
        }
        KubernetesManifest result = new KubernetesManifest();
        result.put("metadata", new HashMap());
        result.setApiVersion(KubernetesApiVersion.fromString(ref.getApiVersion()));
        result.setKind(KubernetesKind.fromString(ref.getKind()));
        result.setNamespace(ref.getNamespace());
        result.setName(ref.getName());
        return result;
    }
}

