/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.op.handler;

import com.google.common.collect.ImmutableSet;
import com.netflix.spinnaker.clouddriver.kubernetes.caching.Keys;
import com.netflix.spinnaker.clouddriver.kubernetes.caching.agent.KubernetesCacheDataConverter;
import com.netflix.spinnaker.clouddriver.kubernetes.caching.agent.KubernetesCachingAgentFactory;
import com.netflix.spinnaker.clouddriver.kubernetes.caching.agent.KubernetesCoreCachingAgent;
import com.netflix.spinnaker.clouddriver.kubernetes.description.SpinnakerKind;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesApiVersion;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesKind;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesManifest;
import com.netflix.spinnaker.clouddriver.kubernetes.model.Manifest;
import com.netflix.spinnaker.clouddriver.kubernetes.op.handler.KubernetesHandler;
import com.netflix.spinnaker.clouddriver.kubernetes.op.handler.UnsupportedVersionException;
import io.kubernetes.client.openapi.models.NetworkingV1beta1HTTPIngressPath;
import io.kubernetes.client.openapi.models.NetworkingV1beta1HTTPIngressRuleValue;
import io.kubernetes.client.openapi.models.NetworkingV1beta1Ingress;
import io.kubernetes.client.openapi.models.NetworkingV1beta1IngressBackend;
import io.kubernetes.client.openapi.models.NetworkingV1beta1IngressRule;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class KubernetesIngressHandler
extends KubernetesHandler {
    private static final Logger log = LoggerFactory.getLogger(KubernetesIngressHandler.class);
    private static final ImmutableSet<KubernetesApiVersion> SUPPORTED_API_VERSIONS = ImmutableSet.of((Object)KubernetesApiVersion.EXTENSIONS_V1BETA1, (Object)KubernetesApiVersion.NETWORKING_K8S_IO_V1BETA1);

    @Override
    public int deployPriority() {
        return KubernetesHandler.DeployPriority.NETWORK_RESOURCE_PRIORITY.getValue();
    }

    @Override
    @Nonnull
    public KubernetesKind kind() {
        return KubernetesKind.INGRESS;
    }

    @Override
    public boolean versioned() {
        return false;
    }

    @Override
    @Nonnull
    public SpinnakerKind spinnakerKind() {
        return SpinnakerKind.LOAD_BALANCERS;
    }

    @Override
    public Manifest.Status status(KubernetesManifest manifest) {
        return Manifest.Status.defaultStatus();
    }

    @Override
    protected KubernetesCachingAgentFactory cachingAgentFactory() {
        return KubernetesCoreCachingAgent::new;
    }

    @Override
    public void addRelationships(Map<KubernetesKind, List<KubernetesManifest>> allResources, Map<KubernetesManifest, List<KubernetesManifest>> relationshipMap) {
        BiFunction<String, String, String> manifestName = (namespace, name) -> namespace + ":" + name;
        Map<String, KubernetesManifest> services = ((List)allResources.getOrDefault(KubernetesKind.SERVICE, new ArrayList())).stream().collect(Collectors.toMap(m -> (String)manifestName.apply(m.getNamespace(), m.getName()), m -> m));
        for (KubernetesManifest ingress : (List)allResources.getOrDefault(KubernetesKind.INGRESS, new ArrayList())) {
            List<Object> attachedServices = new ArrayList();
            try {
                attachedServices = KubernetesIngressHandler.attachedServices(ingress).stream().map(s -> (KubernetesManifest)services.get(manifestName.apply(ingress.getNamespace(), (String)s))).filter(Objects::nonNull).collect(Collectors.toList());
            }
            catch (Exception e) {
                log.warn("Failure getting services attached to {}", (Object)ingress.getName(), (Object)e);
            }
            relationshipMap.put(ingress, attachedServices);
        }
    }

    private static List<String> attachedServices(KubernetesManifest manifest) {
        if (!SUPPORTED_API_VERSIONS.contains((Object)manifest.getApiVersion())) {
            throw new UnsupportedVersionException(manifest);
        }
        NetworkingV1beta1Ingress v1beta1Ingress = KubernetesCacheDataConverter.getResource(manifest, NetworkingV1beta1Ingress.class);
        return KubernetesIngressHandler.attachedServices(v1beta1Ingress);
    }

    private static List<String> attachedServices(NetworkingV1beta1Ingress ingress) {
        List rules;
        HashSet<String> result = new HashSet<String>();
        NetworkingV1beta1IngressBackend backend = ingress.getSpec().getBackend();
        if (backend != null) {
            result.add(backend.getServiceName());
        }
        rules = (rules = ingress.getSpec().getRules()) == null ? new ArrayList() : rules;
        for (NetworkingV1beta1IngressRule rule : rules) {
            NetworkingV1beta1HTTPIngressRuleValue http = rule.getHttp();
            if (http == null) continue;
            for (NetworkingV1beta1HTTPIngressPath path : http.getPaths()) {
                backend = path.getBackend();
                if (backend == null) continue;
                result.add(backend.getServiceName());
            }
        }
        return new ArrayList<String>(result);
    }

    @Override
    public Map<String, Object> hydrateSearchResult(Keys.InfrastructureCacheKey key) {
        Map<String, Object> result = super.hydrateSearchResult(key);
        result.put("loadBalancer", result.get("name"));
        return result;
    }
}

