/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.op.handler;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.netflix.spinnaker.clouddriver.kubernetes.artifact.Replacer;
import com.netflix.spinnaker.clouddriver.kubernetes.caching.Keys;
import com.netflix.spinnaker.clouddriver.kubernetes.caching.agent.KubernetesCacheDataConverter;
import com.netflix.spinnaker.clouddriver.kubernetes.caching.agent.KubernetesCachingAgentFactory;
import com.netflix.spinnaker.clouddriver.kubernetes.caching.agent.KubernetesCoreCachingAgent;
import com.netflix.spinnaker.clouddriver.kubernetes.description.SpinnakerKind;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesKind;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesManifest;
import com.netflix.spinnaker.clouddriver.kubernetes.model.Manifest;
import com.netflix.spinnaker.clouddriver.kubernetes.op.handler.CanPauseRollout;
import com.netflix.spinnaker.clouddriver.kubernetes.op.handler.CanResize;
import com.netflix.spinnaker.clouddriver.kubernetes.op.handler.CanResumeRollout;
import com.netflix.spinnaker.clouddriver.kubernetes.op.handler.CanRollingRestart;
import com.netflix.spinnaker.clouddriver.kubernetes.op.handler.CanScale;
import com.netflix.spinnaker.clouddriver.kubernetes.op.handler.CanUndoRollout;
import com.netflix.spinnaker.clouddriver.kubernetes.op.handler.KubernetesHandler;
import com.netflix.spinnaker.clouddriver.kubernetes.op.handler.ServerGroupHandler;
import com.netflix.spinnaker.clouddriver.kubernetes.op.handler.UnstableReason;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import io.kubernetes.client.openapi.models.V1beta2RollingUpdateStatefulSetStrategy;
import io.kubernetes.client.openapi.models.V1beta2StatefulSet;
import io.kubernetes.client.openapi.models.V1beta2StatefulSetStatus;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.springframework.stereotype.Component;

@Component
public class KubernetesStatefulSetHandler
extends KubernetesHandler
implements CanResize,
CanScale,
CanPauseRollout,
CanResumeRollout,
CanUndoRollout,
CanRollingRestart,
ServerGroupHandler {
    @Override
    @Nonnull
    protected ImmutableList<Replacer> artifactReplacers() {
        return ImmutableList.of((Object)Replacer.dockerImage(), (Object)Replacer.configMapVolume(), (Object)Replacer.secretVolume(), (Object)Replacer.configMapProjectedVolume(), (Object)Replacer.secretProjectedVolume(), (Object)Replacer.configMapEnv(), (Object)Replacer.secretEnv(), (Object)Replacer.configMapKeyValue(), (Object)Replacer.secretKeyValue());
    }

    @Override
    public int deployPriority() {
        return KubernetesHandler.DeployPriority.WORKLOAD_CONTROLLER_PRIORITY.getValue();
    }

    @Override
    @Nonnull
    public KubernetesKind kind() {
        return KubernetesKind.STATEFUL_SET;
    }

    @Override
    public boolean versioned() {
        return false;
    }

    @Override
    @Nonnull
    public SpinnakerKind spinnakerKind() {
        return SpinnakerKind.SERVER_GROUPS;
    }

    @Override
    protected KubernetesCachingAgentFactory cachingAgentFactory() {
        return KubernetesCoreCachingAgent::new;
    }

    @Override
    public Manifest.Status status(KubernetesManifest manifest) {
        V1beta2StatefulSet v1beta2StatefulSet = KubernetesCacheDataConverter.getResource(manifest, V1beta2StatefulSet.class);
        return this.status(v1beta2StatefulSet);
    }

    public static String serviceName(KubernetesManifest manifest) {
        Map spec = (Map)manifest.get("spec");
        return (String)spec.get("serviceName");
    }

    @Override
    public Map<String, Object> hydrateSearchResult(Keys.InfrastructureCacheKey key) {
        Map<String, Object> result = super.hydrateSearchResult(key);
        result.put("serverGroup", result.get("name"));
        return result;
    }

    private Manifest.Status status(V1beta2StatefulSet statefulSet) {
        int existing;
        if (statefulSet.getSpec().getUpdateStrategy().getType().equalsIgnoreCase("ondelete")) {
            return Manifest.Status.defaultStatus();
        }
        V1beta2StatefulSetStatus status = statefulSet.getStatus();
        if (status == null) {
            return Manifest.Status.noneReported();
        }
        if (!this.generationMatches(statefulSet, status)) {
            return Manifest.Status.defaultStatus().unstable(UnstableReason.OLD_GENERATION.getMessage());
        }
        int desiredReplicas = KubernetesStatefulSetHandler.defaultToZero(statefulSet.getSpec().getReplicas());
        if (desiredReplicas > (existing = KubernetesStatefulSetHandler.defaultToZero(status.getReplicas()))) {
            return Manifest.Status.defaultStatus().unstable("Waiting for at least the desired replica count to be met");
        }
        existing = KubernetesStatefulSetHandler.defaultToZero(status.getReadyReplicas());
        if (desiredReplicas > existing) {
            return Manifest.Status.defaultStatus().unstable("Waiting for all updated replicas to be ready");
        }
        String updateType = statefulSet.getSpec().getUpdateStrategy().getType();
        V1beta2RollingUpdateStatefulSetStrategy rollingUpdate = statefulSet.getSpec().getUpdateStrategy().getRollingUpdate();
        Integer updated = status.getUpdatedReplicas();
        if (updateType.equalsIgnoreCase("rollingupdate") && updated != null && rollingUpdate != null) {
            Integer partition = rollingUpdate.getPartition();
            Integer replicas = status.getReplicas();
            if (replicas != null && partition != null && updated < replicas - partition) {
                return Manifest.Status.defaultStatus().unstable("Waiting for partitioned roll out to finish");
            }
            return Manifest.Status.defaultStatus().stable("Partitioned roll out complete");
        }
        existing = KubernetesStatefulSetHandler.defaultToZero(status.getCurrentReplicas());
        if (desiredReplicas > existing) {
            return Manifest.Status.defaultStatus().unstable("Waiting for all updated replicas to be scheduled");
        }
        if (!status.getCurrentRevision().equals(status.getUpdateRevision())) {
            return Manifest.Status.defaultStatus().unstable("Waiting for the updated revision to match the current revision");
        }
        return Manifest.Status.defaultStatus();
    }

    private boolean generationMatches(V1beta2StatefulSet statefulSet, V1beta2StatefulSetStatus status) {
        Optional<Long> metadataGeneration = Optional.ofNullable(statefulSet.getMetadata()).map(V1ObjectMeta::getGeneration);
        Optional<Long> statusGeneration = Optional.ofNullable(status.getObservedGeneration());
        return statusGeneration.isPresent() && statusGeneration.equals(metadataGeneration);
    }

    private static int defaultToZero(@Nullable Integer input) {
        return input == null ? 0 : input;
    }

    @Override
    public void addRelationships(Map<KubernetesKind, List<KubernetesManifest>> allResources, Map<KubernetesManifest, List<KubernetesManifest>> relationshipMap) {
        BiFunction<String, String, String> manifestName = (namespace, name) -> namespace + ":" + name;
        Map<String, KubernetesManifest> services = ((List)allResources.getOrDefault(KubernetesKind.SERVICE, new ArrayList())).stream().collect(Collectors.toMap(m -> (String)manifestName.apply(m.getNamespace(), m.getName()), m -> m));
        for (KubernetesManifest manifest : (List)allResources.getOrDefault(KubernetesKind.STATEFUL_SET, new ArrayList())) {
            String key;
            String serviceName = KubernetesStatefulSetHandler.serviceName(manifest);
            if (Strings.isNullOrEmpty((String)serviceName) || !services.containsKey(key = manifestName.apply(manifest.getNamespace(), serviceName))) continue;
            KubernetesManifest service = services.get(key);
            relationshipMap.put(manifest, (List<KubernetesManifest>)ImmutableList.of((Object)service));
        }
    }
}

