/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.op.manifest;

import com.google.common.collect.ImmutableList;
import com.netflix.spinnaker.clouddriver.data.task.Task;
import com.netflix.spinnaker.clouddriver.data.task.TaskRepository;
import com.netflix.spinnaker.clouddriver.kubernetes.description.JsonPatch;
import com.netflix.spinnaker.clouddriver.kubernetes.description.KubernetesCoordinates;
import com.netflix.spinnaker.clouddriver.kubernetes.description.KubernetesPatchOptions;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesEnableDisableManifestDescription;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesManifest;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesManifestAnnotater;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesManifestTraffic;
import com.netflix.spinnaker.clouddriver.kubernetes.op.OperationResult;
import com.netflix.spinnaker.clouddriver.kubernetes.op.handler.CanLoadBalance;
import com.netflix.spinnaker.clouddriver.kubernetes.op.handler.HasPods;
import com.netflix.spinnaker.clouddriver.kubernetes.security.KubernetesCredentials;
import com.netflix.spinnaker.clouddriver.orchestration.AtomicOperation;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang.WordUtils;

@ParametersAreNonnullByDefault
public abstract class AbstractKubernetesEnableDisableManifestOperation
implements AtomicOperation<OperationResult> {
    private final KubernetesEnableDisableManifestDescription description;
    private final KubernetesCredentials credentials;
    private final String OP_NAME = this.getVerbName().toUpperCase() + "_MANIFEST";

    protected abstract String getVerbName();

    protected abstract List<JsonPatch> patchResource(CanLoadBalance var1, KubernetesManifest var2, KubernetesManifest var3);

    protected AbstractKubernetesEnableDisableManifestOperation(KubernetesEnableDisableManifestDescription description) {
        this.description = description;
        this.credentials = description.getCredentials().getCredentials();
    }

    private static Task getTask() {
        return (Task)TaskRepository.threadLocalTask.get();
    }

    @Nonnull
    private List<String> determineLoadBalancers(@Nonnull KubernetesManifest target) {
        AbstractKubernetesEnableDisableManifestOperation.getTask().updateStatus(this.OP_NAME, "Getting load balancer list to " + this.getVerbName() + "...");
        ImmutableList<String> result = this.description.getLoadBalancers();
        if (!result.isEmpty()) {
            AbstractKubernetesEnableDisableManifestOperation.getTask().updateStatus(this.OP_NAME, "Using supplied list [" + String.join((CharSequence)", ", result) + "]");
        } else {
            KubernetesManifestTraffic traffic = KubernetesManifestAnnotater.getTraffic(target);
            result = traffic.getLoadBalancers();
            AbstractKubernetesEnableDisableManifestOperation.getTask().updateStatus(this.OP_NAME, "Using annotated list [" + String.join((CharSequence)", ", result) + "]");
        }
        return result;
    }

    private void op(String loadBalancerName, KubernetesManifest target) {
        KubernetesCoordinates coords;
        try {
            coords = KubernetesCoordinates.builder().namespace(target.getNamespace()).fullResourceName(loadBalancerName).build();
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format("Failed to perform operation with load balancer '%s'. Load balancers must be specified in the form '{kind} {name}', e.g. 'service my-service'", loadBalancerName), e);
        }
        CanLoadBalance loadBalancerHandler = CanLoadBalance.lookupProperties(this.credentials.getResourcePropertyRegistry(), coords);
        KubernetesManifest loadBalancer = Optional.ofNullable(this.credentials.get(coords)).orElseThrow(() -> new IllegalStateException(String.format("Could not find load balancer: %s.", coords)));
        List<JsonPatch> patch = this.patchResource(loadBalancerHandler, loadBalancer, target);
        AbstractKubernetesEnableDisableManifestOperation.getTask().updateStatus(this.OP_NAME, "Patching target for '" + loadBalancerName + "\"");
        this.credentials.patch(target.getKind(), target.getNamespace(), target.getName(), KubernetesPatchOptions.json(), patch);
        HasPods podHandler = null;
        try {
            podHandler = HasPods.lookupProperties(this.credentials.getResourcePropertyRegistry(), target.getKind());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (podHandler != null) {
            AbstractKubernetesEnableDisableManifestOperation.getTask().updateStatus(this.OP_NAME, "Patching pods for '" + loadBalancerName + "\"");
            List<KubernetesManifest> pods = podHandler.pods(this.credentials, target);
            for (KubernetesManifest pod : pods) {
                patch = this.patchResource(loadBalancerHandler, loadBalancer, pod);
                this.credentials.patch(pod.getKind(), pod.getNamespace(), pod.getName(), KubernetesPatchOptions.json(), patch);
            }
        }
    }

    public OperationResult operate(List<OperationResult> priorOutputs) {
        AbstractKubernetesEnableDisableManifestOperation.getTask().updateStatus(this.OP_NAME, "Starting " + this.getVerbName() + " operation...");
        KubernetesCoordinates coordinates = this.description.getPointCoordinates();
        KubernetesManifest target = Optional.ofNullable(this.credentials.get(coordinates)).orElseThrow(() -> new IllegalStateException(String.format("Could not find kubernetes manifest: %s", coordinates.toString())));
        this.determineLoadBalancers(target).forEach(l -> this.op((String)l, target));
        AbstractKubernetesEnableDisableManifestOperation.getTask().updateStatus(this.OP_NAME, WordUtils.capitalize((String)this.getVerbName()) + " operation for " + coordinates + " succeeded");
        return null;
    }
}

