/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.op.manifest;

import com.google.common.collect.ImmutableList;
import com.netflix.spinnaker.clouddriver.data.task.Task;
import com.netflix.spinnaker.clouddriver.data.task.TaskRepository;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesDeleteManifestDescription;
import com.netflix.spinnaker.clouddriver.kubernetes.op.OperationResult;
import com.netflix.spinnaker.clouddriver.kubernetes.op.handler.KubernetesHandler;
import com.netflix.spinnaker.clouddriver.kubernetes.security.KubernetesCredentials;
import com.netflix.spinnaker.clouddriver.orchestration.AtomicOperation;
import java.util.List;

public class KubernetesDeleteManifestOperation
implements AtomicOperation<OperationResult> {
    private final KubernetesDeleteManifestDescription description;
    private final KubernetesCredentials credentials;
    private static final String OP_NAME = "DELETE_KUBERNETES_MANIFEST";

    public KubernetesDeleteManifestOperation(KubernetesDeleteManifestDescription description) {
        this.description = description;
        this.credentials = description.getCredentials().getCredentials();
    }

    private static Task getTask() {
        return (Task)TaskRepository.threadLocalTask.get();
    }

    public OperationResult operate(List<OperationResult> priorOutputs) {
        KubernetesDeleteManifestOperation.getTask().updateStatus(OP_NAME, "Starting delete operation...");
        ImmutableList coordinates = this.description.isDynamic() ? this.description.getAllCoordinates() : ImmutableList.of((Object)this.description.getPointCoordinates());
        OperationResult result = new OperationResult();
        coordinates.forEach(c -> {
            KubernetesDeleteManifestOperation.getTask().updateStatus(OP_NAME, "Looking up resource properties for " + c.getKind() + "...");
            KubernetesHandler deployer = this.credentials.getResourcePropertyRegistry().get(c.getKind()).getHandler();
            KubernetesDeleteManifestOperation.getTask().updateStatus(OP_NAME, "Calling delete operation...");
            result.merge(deployer.delete(this.credentials, c.getNamespace(), c.getName(), this.description.getLabelSelectors(), this.description.getOptions()));
        });
        return result;
    }
}

