/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.op.manifest;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.netflix.spinnaker.clouddriver.data.task.Task;
import com.netflix.spinnaker.clouddriver.data.task.TaskRepository;
import com.netflix.spinnaker.clouddriver.kubernetes.artifact.ArtifactConverter;
import com.netflix.spinnaker.clouddriver.kubernetes.artifact.ArtifactReplacer;
import com.netflix.spinnaker.clouddriver.kubernetes.artifact.ResourceVersioner;
import com.netflix.spinnaker.clouddriver.kubernetes.description.KubernetesCoordinates;
import com.netflix.spinnaker.clouddriver.kubernetes.description.KubernetesResourceProperties;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesDeployManifestDescription;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesKind;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesManifest;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesManifestAnnotater;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesManifestStrategy;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesManifestTraffic;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesSourceCapacity;
import com.netflix.spinnaker.clouddriver.kubernetes.op.OperationResult;
import com.netflix.spinnaker.clouddriver.kubernetes.op.handler.CanLoadBalance;
import com.netflix.spinnaker.clouddriver.kubernetes.op.handler.CanScale;
import com.netflix.spinnaker.clouddriver.kubernetes.op.handler.KubernetesHandler;
import com.netflix.spinnaker.clouddriver.kubernetes.op.manifest.ArtifactKey;
import com.netflix.spinnaker.clouddriver.kubernetes.security.KubernetesCredentials;
import com.netflix.spinnaker.clouddriver.orchestration.AtomicOperation;
import com.netflix.spinnaker.kork.artifacts.model.Artifact;
import com.netflix.spinnaker.moniker.Moniker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesDeployManifestOperation
implements AtomicOperation<OperationResult> {
    private static final Logger log = LoggerFactory.getLogger(KubernetesDeployManifestOperation.class);
    private final KubernetesDeployManifestDescription description;
    private final KubernetesCredentials credentials;
    private final ResourceVersioner resourceVersioner;
    @Nonnull
    private final String accountName;
    private static final String OP_NAME = "DEPLOY_KUBERNETES_MANIFEST";

    public KubernetesDeployManifestOperation(KubernetesDeployManifestDescription description, ResourceVersioner resourceVersioner) {
        this.description = description;
        this.credentials = description.getCredentials().getCredentials();
        this.resourceVersioner = resourceVersioner;
        this.accountName = description.getCredentials().getName();
    }

    private static Task getTask() {
        return (Task)TaskRepository.threadLocalTask.get();
    }

    public OperationResult operate(List<OperationResult> _unused) {
        List<Artifact> optionalArtifacts;
        KubernetesDeployManifestOperation.getTask().updateStatus(OP_NAME, "Beginning deployment of manifest...");
        ImmutableList inputManifests = this.description.getManifests();
        ArrayList<KubernetesManifest> deployManifests = new ArrayList<KubernetesManifest>();
        if (inputManifests == null || inputManifests.isEmpty()) {
            KubernetesManifest manifest = this.description.getManifest();
            log.warn("Relying on deprecated single manifest input (account: {}, kind: {}, name: {})", new Object[]{this.accountName, manifest.getKind(), manifest.getName()});
            inputManifests = ImmutableList.of((Object)manifest);
        }
        inputManifests = inputManifests.stream().filter(Objects::nonNull).collect(Collectors.toList());
        List<Artifact> requiredArtifacts = this.description.getRequiredArtifacts();
        if (requiredArtifacts == null) {
            requiredArtifacts = new ArrayList<Artifact>();
        }
        if ((optionalArtifacts = this.description.getOptionalArtifacts()) == null) {
            optionalArtifacts = new ArrayList<Artifact>();
        }
        ArrayList<Artifact> artifacts = new ArrayList<Artifact>();
        artifacts.addAll(optionalArtifacts);
        artifacts.addAll(requiredArtifacts);
        HashSet<Artifact> boundArtifacts = new HashSet<Artifact>();
        for (KubernetesManifest manifest : inputManifests) {
            KubernetesManifestAnnotater.validateAnnotationsForRolloutStrategies(manifest, this.description.getStrategy());
            KubernetesDeployManifestOperation.getTask().updateStatus(OP_NAME, "Swapping out artifacts in " + manifest.getFullResourceName() + " from context...");
            ArtifactReplacer.ReplaceResult replaceResult = this.findResourceProperties(manifest).getHandler().replaceArtifacts(manifest, artifacts, this.description.getAccount());
            deployManifests.add(replaceResult.getManifest());
            boundArtifacts.addAll((Collection<Artifact>)replaceResult.getBoundArtifacts());
        }
        Sets.SetView unboundArtifacts = Sets.difference(ArtifactKey.fromArtifacts(this.description.getRequiredArtifacts()), ArtifactKey.fromArtifacts(boundArtifacts));
        KubernetesDeployManifestOperation.getTask().updateStatus(OP_NAME, "Checking if all requested artifacts were bound...");
        if (!unboundArtifacts.isEmpty()) {
            throw new IllegalArgumentException(String.format("The following required artifacts could not be bound: '%s'. Check that the Docker image name above matches the name used in the image field of your manifest. Failing the stage as this is likely a configuration error.", unboundArtifacts));
        }
        KubernetesDeployManifestOperation.getTask().updateStatus(OP_NAME, "Sorting manifests by priority...");
        deployManifests.sort(Comparator.comparingInt(m -> this.findResourceProperties((KubernetesManifest)m).getHandler().deployPriority()));
        KubernetesDeployManifestOperation.getTask().updateStatus(OP_NAME, "Deploy order is: " + deployManifests.stream().map(KubernetesManifest::getFullResourceName).collect(Collectors.joining(", ")));
        OperationResult result = new OperationResult();
        for (KubernetesManifest manifest : deployManifests) {
            Double replicas;
            KubernetesManifestStrategy strategy;
            KubernetesResourceProperties properties = this.findResourceProperties(manifest);
            OptionalInt version = this.isVersioned(properties, strategy = KubernetesManifestAnnotater.getStrategy(manifest)) ? this.resourceVersioner.getVersion(manifest, this.credentials) : OptionalInt.empty();
            Moniker moniker = KubernetesDeployManifestOperation.cloneMoniker(this.description.getMoniker());
            version.ifPresent(arg_0 -> ((Moniker)moniker).setSequence(arg_0));
            if (Strings.isNullOrEmpty((String)moniker.getCluster())) {
                moniker.setCluster(manifest.getFullResourceName());
            }
            Artifact artifact = ArtifactConverter.toArtifact(manifest, this.description.getAccount(), version);
            KubernetesDeployManifestOperation.getTask().updateStatus(OP_NAME, "Annotating manifest " + manifest.getFullResourceName() + " with artifact, relationships & moniker...");
            KubernetesManifestAnnotater.annotateManifest(manifest, artifact);
            KubernetesHandler deployer = properties.getHandler();
            if (strategy.isUseSourceCapacity() && deployer instanceof CanScale && (replicas = KubernetesSourceCapacity.getSourceCapacity(manifest, this.credentials)) != null) {
                manifest.setReplicas(replicas);
            }
            this.setTrafficAnnotation(this.description.getServices(), manifest);
            if (this.description.isEnableTraffic()) {
                KubernetesManifestTraffic traffic = KubernetesManifestAnnotater.getTraffic(manifest);
                this.applyTraffic(traffic, manifest);
            }
            this.credentials.getNamer().applyMoniker((Object)manifest, moniker);
            manifest.setName(artifact.getReference());
            KubernetesDeployManifestOperation.getTask().updateStatus(OP_NAME, "Swapping out artifacts in " + manifest.getFullResourceName() + " from other deployments...");
            ArtifactReplacer.ReplaceResult replaceResult = deployer.replaceArtifacts(manifest, new ArrayList<Artifact>(result.getCreatedArtifacts()), this.description.getAccount());
            boundArtifacts.addAll((Collection<Artifact>)replaceResult.getBoundArtifacts());
            manifest = replaceResult.getManifest();
            KubernetesDeployManifestOperation.getTask().updateStatus(OP_NAME, "Submitting manifest " + manifest.getFullResourceName() + " to kubernetes master...");
            log.debug("Manifest in {} to be deployed: {}", (Object)this.accountName, (Object)manifest);
            result.merge(deployer.deploy(this.credentials, manifest, strategy.getDeployStrategy()));
            result.getCreatedArtifacts().add(artifact);
        }
        result.getBoundArtifacts().addAll(boundArtifacts);
        result.removeSensitiveKeys(this.credentials.getResourcePropertyRegistry());
        KubernetesDeployManifestOperation.getTask().updateStatus(OP_NAME, "Deploy manifest task completed successfully.");
        return result;
    }

    private void setTrafficAnnotation(List<String> services, KubernetesManifest manifest) {
        if (services == null || services.isEmpty()) {
            return;
        }
        KubernetesManifestTraffic traffic = new KubernetesManifestTraffic(services);
        KubernetesManifestAnnotater.setTraffic(manifest, traffic);
    }

    private void applyTraffic(KubernetesManifestTraffic traffic, KubernetesManifest target) {
        traffic.getLoadBalancers().forEach(l -> this.attachLoadBalancer((String)l, target));
    }

    private void attachLoadBalancer(String loadBalancerName, KubernetesManifest target) {
        KubernetesCoordinates coords;
        try {
            coords = KubernetesCoordinates.builder().namespace(target.getNamespace()).fullResourceName(loadBalancerName).build();
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format("Failed to attach load balancer '%s'. Load balancers must be specified in the form '{kind} {name}', e.g. 'service my-service'.", loadBalancerName), e);
        }
        CanLoadBalance handler = CanLoadBalance.lookupProperties(this.credentials.getResourcePropertyRegistry(), coords);
        KubernetesManifest loadBalancer = Optional.ofNullable(this.credentials.get(coords)).orElseThrow(() -> new IllegalArgumentException("Load balancer " + loadBalancerName + " does not exist"));
        KubernetesDeployManifestOperation.getTask().updateStatus(OP_NAME, "Attaching load balancer " + loadBalancer.getFullResourceName() + " to " + target.getFullResourceName());
        handler.attach(loadBalancer, target);
    }

    private boolean isVersioned(KubernetesResourceProperties properties, KubernetesManifestStrategy strategy) {
        if (strategy.getVersioned() != KubernetesManifestStrategy.Versioned.DEFAULT) {
            return strategy.getVersioned() == KubernetesManifestStrategy.Versioned.TRUE;
        }
        if (this.description.getVersioned() != null) {
            return this.description.getVersioned();
        }
        return properties.isVersioned();
    }

    private static Moniker cloneMoniker(Moniker inp) {
        return Moniker.builder().app(inp.getApp()).cluster(inp.getCluster()).stack(inp.getStack()).detail(inp.getDetail()).sequence(inp.getSequence()).build();
    }

    @Nonnull
    private KubernetesResourceProperties findResourceProperties(KubernetesManifest manifest) {
        KubernetesKind kind = manifest.getKind();
        KubernetesDeployManifestOperation.getTask().updateStatus(OP_NAME, "Finding deployer for " + kind + "...");
        return this.credentials.getResourcePropertyRegistry().get(kind);
    }
}

