/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.op.servergroup;

import com.netflix.spinnaker.clouddriver.data.task.Task;
import com.netflix.spinnaker.clouddriver.data.task.TaskRepository;
import com.netflix.spinnaker.clouddriver.kubernetes.description.KubernetesCoordinates;
import com.netflix.spinnaker.clouddriver.kubernetes.description.servergroup.KubernetesResizeServerGroupDescription;
import com.netflix.spinnaker.clouddriver.kubernetes.op.handler.CanResize;
import com.netflix.spinnaker.clouddriver.kubernetes.op.handler.KubernetesHandler;
import com.netflix.spinnaker.clouddriver.kubernetes.security.KubernetesCredentials;
import com.netflix.spinnaker.clouddriver.orchestration.AtomicOperation;
import java.util.List;

public class KubernetesResizeServerGroupOperation
implements AtomicOperation<Void> {
    private final KubernetesResizeServerGroupDescription description;
    private final KubernetesCredentials credentials;
    private static final String OP_NAME = "RESIZE_KUBERNETES_SERVER_GROUP";

    public KubernetesResizeServerGroupOperation(KubernetesResizeServerGroupDescription description) {
        this.description = description;
        this.credentials = description.getCredentials().getCredentials();
    }

    private static Task getTask() {
        return (Task)TaskRepository.threadLocalTask.get();
    }

    public Void operate(List<Void> priorOutputs) {
        KubernetesResizeServerGroupOperation.getTask().updateStatus(OP_NAME, "Starting resize operation...");
        KubernetesCoordinates coordinates = this.description.getCoordinates();
        KubernetesResizeServerGroupOperation.getTask().updateStatus(OP_NAME, "Looking up resource properties...");
        KubernetesHandler deployer = this.credentials.getResourcePropertyRegistry().get(coordinates.getKind()).getHandler();
        if (!(deployer instanceof CanResize)) {
            throw new IllegalArgumentException("Resource with " + coordinates + " does not support resize");
        }
        CanResize canResize = (CanResize)((Object)deployer);
        KubernetesResizeServerGroupOperation.getTask().updateStatus(OP_NAME, "Calling resize operation...");
        canResize.resize(this.credentials, coordinates.getNamespace(), coordinates.getName(), this.description.getCapacity());
        return null;
    }
}

