/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.security;

import com.google.common.hash.Hashing;
import java.nio.file.Files;
import java.nio.file.Paths;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubeconfigFileHasher {
    private static final Logger log = LoggerFactory.getLogger(KubeconfigFileHasher.class);

    public static String hashKubeconfigFile(@Nonnull String filepath) {
        if (filepath.isEmpty()) {
            return "";
        }
        try {
            byte[] contents = Files.readAllBytes(Paths.get(filepath, new String[0]));
            return Hashing.sha256().hashBytes(contents).toString();
        }
        catch (Exception e) {
            log.warn("failed to hash kubeconfig file at {}: {}", (Object)filepath, (Object)e);
            return "";
        }
    }
}

