/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.validator.manifest;

import com.netflix.spinnaker.clouddriver.deploy.DescriptionValidator;
import com.netflix.spinnaker.clouddriver.deploy.ValidationErrors;
import com.netflix.spinnaker.clouddriver.kubernetes.KubernetesOperation;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesDeployManifestDescription;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesManifest;
import com.netflix.spinnaker.clouddriver.kubernetes.validator.KubernetesValidationUtil;
import com.netflix.spinnaker.clouddriver.security.AccountCredentialsProvider;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@KubernetesOperation(value="deployManifest")
@Component
public class KubernetesDeployManifestValidator
extends DescriptionValidator<KubernetesDeployManifestDescription> {
    @Autowired
    AccountCredentialsProvider provider;

    public void validate(List<KubernetesDeployManifestDescription> priorDescriptions, KubernetesDeployManifestDescription description, ValidationErrors errors) {
        KubernetesValidationUtil util = new KubernetesValidationUtil("deployKubernetesManifest", errors);
        if (!util.validateNotEmpty("moniker", description)) {
            return;
        }
        for (KubernetesManifest manifest : description.getManifests()) {
            if (manifest == null || util.validateCredentials(this.provider, description.getAccount(), manifest)) continue;
            return;
        }
    }
}

