/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.security;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.netflix.spinnaker.clouddriver.security.ProviderVersion;
import com.netflix.spinnaker.fiat.model.Authorization;
import com.netflix.spinnaker.fiat.model.resources.Permissions;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public interface AccountCredentials<T> {
    public String getName();

    public String getEnvironment();

    public String getAccountType();

    default public ProviderVersion getProviderVersion() {
        return ProviderVersion.v1;
    }

    default public String getSkin() {
        return this.getProviderVersion().toString();
    }

    default public String getAccountId() {
        return null;
    }

    @JsonIgnore
    public T getCredentials();

    public String getCloudProvider();

    @Deprecated
    public List<String> getRequiredGroupMembership();

    default public Permissions getPermissions() {
        Set rgm = Optional.ofNullable(this.getRequiredGroupMembership()).map(l -> l.stream().map(s -> Optional.ofNullable(s).map(String::trim).map(String::toLowerCase).orElse("")).filter(s -> !s.isEmpty()).collect(Collectors.toSet())).orElse(Collections.EMPTY_SET);
        if (rgm.isEmpty()) {
            return Permissions.EMPTY;
        }
        Permissions.Builder perms = new Permissions.Builder();
        for (String role : rgm) {
            perms.add(Authorization.READ, role);
            perms.add(Authorization.WRITE, role);
        }
        return perms.build();
    }

    default public boolean isEnabled() {
        return true;
    }
}

