/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.security;

import com.netflix.spinnaker.clouddriver.security.AccountCredentials;
import com.netflix.spinnaker.clouddriver.security.AccountCredentialsProvider;
import com.netflix.spinnaker.clouddriver.security.AccountCredentialsRepository;
import com.netflix.spinnaker.clouddriver.security.MapBackedAccountCredentialsRepository;
import com.netflix.spinnaker.credentials.CompositeCredentialsRepository;
import java.util.Collections;
import java.util.Set;

public class DefaultAccountCredentialsProvider
implements AccountCredentialsProvider {
    private final AccountCredentialsRepository repository;
    private final CompositeCredentialsRepository<AccountCredentials<?>> compositeRepository;

    public DefaultAccountCredentialsProvider() {
        this(new MapBackedAccountCredentialsRepository());
    }

    public DefaultAccountCredentialsProvider(AccountCredentialsRepository repository) {
        this(repository, new CompositeCredentialsRepository(Collections.emptyList()));
    }

    public DefaultAccountCredentialsProvider(AccountCredentialsRepository repository, CompositeCredentialsRepository<AccountCredentials<?>> compositeRepository) {
        this.repository = repository;
        this.compositeRepository = compositeRepository;
    }

    public Set<AccountCredentials<?>> getAll() {
        Set all = this.repository.getAll();
        all.addAll(this.compositeRepository.getAllCredentials());
        return all;
    }

    public AccountCredentials<?> getCredentials(String name) {
        AccountCredentials credentials = this.repository.getOne(name);
        if (credentials != null) {
            return credentials;
        }
        return (AccountCredentials)this.compositeRepository.getFirstCredentialsWithName(name);
    }
}

