/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.fiat.shared;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spinnaker.fiat.shared.FiatAuthenticationFilter;
import com.netflix.spinnaker.fiat.shared.FiatClientConfigurationProperties;
import com.netflix.spinnaker.fiat.shared.FiatService;
import com.netflix.spinnaker.okhttp.SpinnakerRequestInterceptor;
import javax.servlet.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import retrofit.Endpoints;
import retrofit.RequestInterceptor;
import retrofit.RestAdapter;
import retrofit.client.Client;
import retrofit.client.OkClient;
import retrofit.converter.Converter;
import retrofit.converter.JacksonConverter;

@EnableWebSecurity
@EnableGlobalMethodSecurity(prePostEnabled=true)
@Configuration
@EnableConfigurationProperties(value={FiatClientConfigurationProperties.class})
@ComponentScan(value={"com.netflix.spinnaker.fiat.shared"})
public class FiatAuthenticationConfig {
    private static final Logger log = LoggerFactory.getLogger(FiatAuthenticationConfig.class);
    @Autowired(required=false)
    private RestAdapter.LogLevel retrofitLogLevel = RestAdapter.LogLevel.BASIC;
    @Autowired
    SpinnakerRequestInterceptor spinnakerRequestInterceptor;

    @Bean
    @ConditionalOnMissingBean(value={FiatService.class})
    public FiatService fiatService(FiatClientConfigurationProperties fiatConfigurationProperties, SpinnakerRequestInterceptor interceptor, OkClient okClient) {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.enable(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL);
        objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        return (FiatService)new RestAdapter.Builder().setEndpoint(Endpoints.newFixedEndpoint((String)fiatConfigurationProperties.getBaseUrl())).setRequestInterceptor((RequestInterceptor)interceptor).setClient((Client)okClient).setConverter((Converter)new JacksonConverter(objectMapper)).setLogLevel(this.retrofitLogLevel).setLog((RestAdapter.Log)new Slf4jRetrofitLogger(FiatService.class)).build().create(FiatService.class);
    }

    @Bean
    FilterRegistrationBean fiatFilterRegistrationBean(FiatAuthenticationFilter filter) {
        FilterRegistrationBean frb = new FilterRegistrationBean((Filter)filter, new ServletRegistrationBean[0]);
        frb.setOrder(-2147483647);
        frb.addUrlPatterns(new String[]{"/*"});
        return frb;
    }

    @ConditionalOnExpression(value="!${services.fiat.enabled:false}")
    @Bean
    AnonymousConfig anonymousConfig() {
        return new AnonymousConfig();
    }

    public FiatAuthenticationConfig setRetrofitLogLevel(RestAdapter.LogLevel retrofitLogLevel) {
        this.retrofitLogLevel = retrofitLogLevel;
        return this;
    }

    private static class Slf4jRetrofitLogger
    implements RestAdapter.Log {
        private final Logger logger;

        Slf4jRetrofitLogger(Class type) {
            this(LoggerFactory.getLogger((Class)type));
        }

        Slf4jRetrofitLogger(Logger logger) {
            this.logger = logger;
        }

        public void log(String message) {
            this.logger.info(message);
        }
    }

    private class AnonymousConfig
    extends WebSecurityConfigurerAdapter {
        private AnonymousConfig() {
        }

        protected void configure(HttpSecurity http) throws Exception {
            log.info("Fiat service is disabled. Setting Spring Security to allow all traffic.");
            ((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().anyRequest()).permitAll().and()).csrf().disable();
        }
    }
}

