/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.fiat.shared;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.netflix.frigga.Names;
import com.netflix.spinnaker.fiat.model.Authorization;
import com.netflix.spinnaker.fiat.model.UserPermission;
import com.netflix.spinnaker.fiat.model.resources.ResourceType;
import com.netflix.spinnaker.fiat.shared.FiatClientConfigurationProperties;
import com.netflix.spinnaker.fiat.shared.FiatService;
import com.netflix.spinnaker.security.AuthenticatedRequest;
import com.netflix.spinnaker.security.User;
import java.io.Serializable;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.access.PermissionEvaluator;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;

@Component
public class FiatPermissionEvaluator
implements PermissionEvaluator,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(FiatPermissionEvaluator.class);
    @Autowired
    private FiatService fiatService;
    @Autowired
    private FiatClientConfigurationProperties configProps;
    @Value(value="${services.fiat.enabled:false}")
    private String fiatEnabled;
    private Cache<String, UserPermission.View> permissionsCache;

    public void afterPropertiesSet() throws Exception {
        this.permissionsCache = CacheBuilder.newBuilder().maximumSize((long)this.configProps.getCache().getMaxEntries().intValue()).expireAfterWrite((long)this.configProps.getCache().getExpiresAfterWriteSeconds().intValue(), TimeUnit.SECONDS).recordStats().build();
    }

    public boolean hasPermission(Authentication authentication, Object resource, Object authorization) {
        return false;
    }

    public boolean hasPermission(Authentication authentication, Serializable resourceName, String resourceType, Object authorization) {
        String parsedName;
        if (!Boolean.valueOf(this.fiatEnabled).booleanValue()) {
            return true;
        }
        if (resourceName == null || resourceType == null || authorization == null) {
            log.debug("Permission denied due to null argument. resourceName={}, resourceType={}, authorization={}", new Object[]{resourceName, resourceType, authorization});
            return false;
        }
        ResourceType r = ResourceType.parse((String)resourceType);
        Authorization a = null;
        if (r != ResourceType.SERVICE_ACCOUNT) {
            a = Authorization.valueOf((String)authorization.toString());
        }
        if (r == ResourceType.APPLICATION && StringUtils.isNotEmpty((CharSequence)(parsedName = Names.parseName((String)resourceName.toString()).getApp()))) {
            resourceName = parsedName;
        }
        UserPermission.View permission = this.getPermission(this.getUsername(authentication));
        return this.permissionContains(permission, resourceName.toString(), r, a);
    }

    private String getUsername(Authentication authentication) {
        String username = "anonymous";
        if (authentication.isAuthenticated() && authentication.getPrincipal() != null) {
            Object principal = authentication.getPrincipal();
            if (principal instanceof User) {
                username = ((User)principal).getUsername();
            } else if (StringUtils.isNotEmpty((CharSequence)principal.toString())) {
                username = principal.toString();
            }
        }
        return username;
    }

    private boolean isAuthorized(String username, ResourceType resourceType, String resourceName, Authorization a) {
        try {
            AuthenticatedRequest.propagate(() -> this.fiatService.hasAuthorization(username, resourceType.toString(), resourceName, a.toString())).call();
        }
        catch (Exception e) {
            String message = String.format("Fiat authorization failed for user '%s' '%s'-ing '%s' resourceType named '%s'. Cause: %s", username, a, resourceType, resourceName, e.getMessage());
            if (log.isDebugEnabled()) {
                log.debug(message, (Throwable)e);
            } else {
                log.info(message);
            }
            return false;
        }
        return true;
    }

    public UserPermission.View getPermission(String username) {
        UserPermission.View view = null;
        if (StringUtils.isEmpty((CharSequence)username)) {
            return null;
        }
        try {
            AtomicBoolean cacheHit = new AtomicBoolean(true);
            view = (UserPermission.View)this.permissionsCache.get((Object)username, () -> {
                cacheHit.set(false);
                return (UserPermission.View)AuthenticatedRequest.propagate(() -> this.fiatService.getUserPermission(username)).call();
            });
            log.debug("Fiat permission cache hit: " + cacheHit.get());
        }
        catch (UncheckedExecutionException | ExecutionException ee) {
            String message = String.format("Cannot get whole user permission for user %s. Cause: %s", username, ee.getCause().getMessage());
            if (log.isDebugEnabled()) {
                log.debug(message, ee.getCause());
            }
            log.info(message);
        }
        return view;
    }

    @Deprecated
    public boolean storeWholePermission() {
        if (!Boolean.valueOf(this.fiatEnabled).booleanValue()) {
            return true;
        }
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        UserPermission.View permission = this.getPermission(this.getUsername(authentication));
        return permission != null;
    }

    private boolean permissionContains(UserPermission.View permission, String resourceName, ResourceType resourceType, Authorization authorization) {
        if (permission == null) {
            return false;
        }
        Function<Set, Boolean> containsAuth = resources -> resources.stream().anyMatch(view -> view.getName().equalsIgnoreCase(resourceName) && view.getAuthorizations().contains(authorization));
        switch (resourceType) {
            case ACCOUNT: {
                return containsAuth.apply(permission.getAccounts());
            }
            case APPLICATION: {
                return containsAuth.apply(permission.getApplications());
            }
            case SERVICE_ACCOUNT: {
                return permission.getServiceAccounts().stream().anyMatch(view -> view.getName().equalsIgnoreCase(resourceName));
            }
        }
        return false;
    }

    public boolean isAdmin() {
        return true;
    }

    public FiatPermissionEvaluator setFiatService(FiatService fiatService) {
        this.fiatService = fiatService;
        return this;
    }

    public FiatPermissionEvaluator setConfigProps(FiatClientConfigurationProperties configProps) {
        this.configProps = configProps;
        return this;
    }

    public FiatPermissionEvaluator setFiatEnabled(String fiatEnabled) {
        this.fiatEnabled = fiatEnabled;
        return this;
    }
}

