/*
 * Decompiled with CFR 0.152.
 */
package com.offbytwo.jenkins.client.util;

import com.offbytwo.jenkins.client.util.EncodingUtils;
import com.offbytwo.jenkins.model.FolderJob;
import java.net.URI;

public final class UrlUtils {
    private static final int DEFAULT_BUFFER_SIZE = 64;

    private UrlUtils() {
    }

    public static String toBaseUrl(FolderJob folder) {
        return folder == null ? "/" : folder.getUrl();
    }

    public static String toJobBaseUrl(FolderJob folder, String jobName) {
        StringBuilder sb = new StringBuilder(64);
        sb.append(UrlUtils.toBaseUrl(folder));
        if (sb.charAt(sb.length() - 1) != '/') {
            sb.append('/');
        }
        sb.append("job/");
        String[] jobNameParts = jobName.split("/");
        for (int i = 0; i < jobNameParts.length; ++i) {
            sb.append(EncodingUtils.encode(jobNameParts[i]));
            if (i == jobNameParts.length - 1) continue;
            sb.append('/');
        }
        return sb.toString();
    }

    public static String toViewBaseUrl(FolderJob folder, String name) {
        StringBuilder sb = new StringBuilder(64);
        String base = UrlUtils.toBaseUrl(folder);
        sb.append(base);
        if (!base.endsWith("/")) {
            sb.append('/');
        }
        sb.append("view/").append(EncodingUtils.encode(name));
        return sb.toString();
    }

    public static String toFullJobPath(String jobName) {
        String[] parts = jobName.split("/");
        if (parts.length == 1) {
            return parts[0];
        }
        StringBuilder sb = new StringBuilder(64);
        for (int i = 0; i < parts.length; ++i) {
            sb.append(parts[i]);
            if (i == parts.length - 1) continue;
            sb.append("/job/");
        }
        return sb.toString();
    }

    public static String join(String path1, String path2) {
        if (path1.isEmpty() && path2.isEmpty()) {
            return "";
        }
        if (path1.isEmpty() && !path2.isEmpty()) {
            return path2;
        }
        if (path2.isEmpty() && !path1.isEmpty()) {
            return path1;
        }
        StringBuilder sb = new StringBuilder(64);
        sb.append(path1);
        if (sb.charAt(sb.length() - 1) == '/') {
            sb.setLength(sb.length() - 1);
        }
        if (path2.charAt(0) != '/') {
            sb.append('/');
        }
        sb.append(path2);
        return sb.toString();
    }

    public static URI toJsonApiUri(URI uri, String context, String path) {
        String p = path;
        if (!p.matches("(?i)https?://.*")) {
            p = UrlUtils.join(context, p);
        }
        if (!p.contains("?")) {
            p = UrlUtils.join(p, "api/json");
        } else {
            String[] components = p.split("\\?", 2);
            p = UrlUtils.join(components[0], "api/json") + "?" + components[1];
        }
        return uri.resolve("/").resolve(p.replace(" ", "%20"));
    }

    public static URI toNoApiUri(URI uri, String context, String path) {
        String p = path.matches("(?i)https?://.*") ? path : UrlUtils.join(context, path);
        return uri.resolve("/").resolve(p);
    }
}

