/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.nodes;

import jdk.vm.ci.meta.ConstantReflectionProvider;
import org.graalvm.compiler.core.common.type.ObjectStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.spi.ArrayLengthProvider;

@NodeInfo(size=NodeSize.SIZE_IGNORED, cycles=NodeCycles.CYCLES_IGNORED)
public class AnalysisArraysCopyOfNode
extends FixedWithNextNode
implements ArrayLengthProvider {
    public static final NodeClass<AnalysisArraysCopyOfNode> TYPE = NodeClass.create(AnalysisArraysCopyOfNode.class);
    @Node.Input
    ValueNode original;
    @Node.Input
    ValueNode newLength;
    @Node.OptionalInput
    ValueNode newArrayType;

    public AnalysisArraysCopyOfNode(@Node.InjectedNodeParameter Stamp stamp, ValueNode original, ValueNode newLength) {
        this(stamp, original, newLength, null);
    }

    public AnalysisArraysCopyOfNode(@Node.InjectedNodeParameter Stamp stamp, ValueNode original, ValueNode newLength, ValueNode newArrayType) {
        super(TYPE, AnalysisArraysCopyOfNode.computeStamp(stamp));
        this.original = original;
        this.newLength = newLength;
        this.newArrayType = newArrayType;
    }

    public ValueNode getOriginal() {
        return this.original;
    }

    public ValueNode getNewArrayType() {
        return this.newArrayType;
    }

    public ValueNode findLength(ArrayLengthProvider.FindLengthMode mode, ConstantReflectionProvider constantReflection) {
        return this.newLength;
    }

    private static Stamp computeStamp(Stamp result) {
        if (result instanceof ObjectStamp) {
            return result.join(StampFactory.objectNonNull());
        }
        return result;
    }
}

