/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.driver;

import com.oracle.graal.pointsto.api.PointstoOptions;
import com.oracle.svm.core.FallbackExecutor;
import com.oracle.svm.core.OS;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.configure.ConfigurationFiles;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import com.oracle.svm.core.util.ClasspathUtils;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.driver.APIOptionHandler;
import com.oracle.svm.driver.DefaultOptionHandler;
import com.oracle.svm.driver.MacroOption;
import com.oracle.svm.driver.MacroOptionHandler;
import com.oracle.svm.driver.NativeImageServer;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.Queue;
import java.util.Scanner;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.compiler.serviceprovider.JavaVersionUtil;
import org.graalvm.nativeimage.ProcessProperties;

public class NativeImage {
    static final boolean IS_AOT = Boolean.getBoolean("com.oracle.graalvm.isaot");
    static final String platform = NativeImage.getPlatform();
    static final String graalvmVersion = System.getProperty("org.graalvm.version", "dev");
    static final String graalvmConfig = System.getProperty("org.graalvm.config", "");
    static final Map<String, String[]> graalCompilerFlags = NativeImage.getCompilerFlags();
    static Boolean useJVMCINativeLibrary = null;
    private static final String usageText = NativeImage.getResource("/Usage.txt");
    final APIOptionHandler apiOptionHandler;
    public static final String oH = "-H:";
    static final String oR = "-R:";
    final String enablePrintFlags = SubstrateOptions.PrintFlags.getName() + "=";
    final String oHClass = NativeImage.oH(SubstrateOptions.Class);
    final String oHName = NativeImage.oH(SubstrateOptions.Name);
    final String oHPath = NativeImage.oH(SubstrateOptions.Path);
    final String enableSharedLibraryFlag = "-H:+" + SubstrateOptions.SharedLibrary.getName();
    final String oHCLibraryPath = NativeImage.oH(SubstrateOptions.CLibraryPath);
    final String oHOptimize = NativeImage.oH(SubstrateOptions.Optimize);
    final String oHFallbackThreshold = NativeImage.oH(SubstrateOptions.FallbackThreshold);
    final String oHFallbackExecutorJavaArg = NativeImage.oH(FallbackExecutor.Options.FallbackExecutorJavaArg);
    final String oRRuntimeJavaArg = NativeImage.oR(FallbackExecutor.Options.FallbackExecutorRuntimeJavaArg);
    final String oHSubstitutionFiles = NativeImage.oH(ConfigurationFiles.Options.SubstitutionFiles);
    final String oHReflectionConfigurationFiles = NativeImage.oH(ConfigurationFiles.Options.ReflectionConfigurationFiles);
    final String oHDynamicProxyConfigurationFiles = NativeImage.oH(ConfigurationFiles.Options.DynamicProxyConfigurationFiles);
    final String oHResourceConfigurationFiles = NativeImage.oH(ConfigurationFiles.Options.ResourceConfigurationFiles);
    final String oHJNIConfigurationFiles = NativeImage.oH(ConfigurationFiles.Options.JNIConfigurationFiles);
    final String oHInspectServerContentPath = NativeImage.oH(PointstoOptions.InspectServerContentPath);
    static final String oXmx = "-Xmx";
    static final String oXms = "-Xms";
    private static final String pKeyNativeImageArgs = "NativeImageArgs";
    private final LinkedHashSet<String> imageBuilderArgs = new LinkedHashSet();
    private final LinkedHashSet<Path> imageBuilderClasspath = new LinkedHashSet();
    private final LinkedHashSet<Path> imageBuilderBootClasspath = new LinkedHashSet();
    private final ArrayList<String> imageBuilderJavaArgs = new ArrayList();
    private final LinkedHashSet<Path> imageClasspath = new LinkedHashSet();
    private final LinkedHashSet<Path> imageProvidedClasspath = new LinkedHashSet();
    private final ArrayList<String> customJavaArgs = new ArrayList();
    private final LinkedHashSet<String> customImageBuilderArgs = new LinkedHashSet();
    private final LinkedHashSet<Path> customImageClasspath = new LinkedHashSet();
    private final ArrayList<OptionHandler<? extends NativeImage>> optionHandlers = new ArrayList();
    protected final BuildConfiguration config;
    private final Map<String, String> userConfigProperties = new HashMap<String, String>();
    private final Map<String, String> propertyFileSubstitutionValues = new HashMap<String, String>();
    private boolean verbose = Boolean.valueOf(System.getenv("VERBOSE_GRAALVM_LAUNCHERS"));
    private boolean jarOptionMode = false;
    private boolean dryRun = false;
    private String queryOption = null;
    final MacroOption.Registry optionRegistry;
    private LinkedHashSet<MacroOption.EnabledOption> enabledLanguages;
    public static final String nativeImagePropertiesFilename = "native-image.properties";
    public static final String nativeImageMetaInf = "META-INF/native-image";
    private String mainClass;
    private String imageName;
    private Path imagePath;
    private static final Function<BuildConfiguration, NativeImage> defaultNativeImageProvider = config -> IS_AOT ? NativeImageServer.create(config) : new NativeImage((BuildConfiguration)config);
    private static String deletedFileSuffix = ".deleted";

    private static String getPlatform() {
        return (OS.getCurrent().className + "-" + SubstrateUtil.getArchitectureName()).toLowerCase();
    }

    private static Map<String, String[]> getCompilerFlags() {
        HashMap<String, String[]> result = new HashMap<String, String[]>();
        for (String versionTag : NativeImage.getResource(NativeImage.flagsFileName("versions")).split("\n")) {
            result.put(versionTag, NativeImage.getResource(NativeImage.flagsFileName(versionTag)).split("\n"));
        }
        return result;
    }

    private static String flagsFileName(String versionTag) {
        return "/graal-compiler-flags-" + versionTag + ".config";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static String getResource(String resourceName) {
        try (InputStream input = NativeImage.class.getResourceAsStream(resourceName);){
            BufferedReader reader = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));
            String resourceString = reader.lines().collect(Collectors.joining("\n"));
            String string = resourceString.replace("%pathsep%", File.pathSeparator);
            return string;
        }
        catch (IOException e) {
            VMError.shouldNotReachHere((Throwable)e);
            return null;
        }
    }

    private static <T> String oH(OptionKey<T> option) {
        return oH + option.getName() + "=";
    }

    private static <T> String oR(OptionKey<T> option) {
        return oR + option.getName() + "=";
    }

    private ArrayList<String> createFallbackBuildArgs() {
        ArrayList<String> buildArgs = new ArrayList<String>();
        Collection fallbackSystemProperties = this.customJavaArgs.stream().filter(s -> s.startsWith("-D")).collect(Collectors.toCollection(LinkedHashSet::new));
        for (Object property : fallbackSystemProperties) {
            buildArgs.add(NativeImage.oH(FallbackExecutor.Options.FallbackExecutorSystemProperty) + (String)property);
        }
        List runtimeJavaArgs = this.imageBuilderArgs.stream().filter(s -> s.startsWith(this.oRRuntimeJavaArg)).collect(Collectors.toList());
        for (Object runtimeJavaArg : runtimeJavaArgs) {
            buildArgs.add((String)runtimeJavaArg);
        }
        List fallbackExecutorJavaArgs = this.imageBuilderArgs.stream().filter(s -> s.startsWith(this.oHFallbackExecutorJavaArg)).collect(Collectors.toList());
        for (String fallbackExecutorJavaArg : fallbackExecutorJavaArgs) {
            buildArgs.add(fallbackExecutorJavaArg);
        }
        buildArgs.add("-H:+" + SubstrateOptions.ParseRuntimeOptions.getName());
        String classpathString = this.imageClasspath.stream().map(this.imagePath::relativize).map(ClasspathUtils::classpathToString).collect(Collectors.joining(File.pathSeparator));
        buildArgs.add(this.oHPath + this.imagePath.toString());
        buildArgs.add(NativeImage.oH(FallbackExecutor.Options.FallbackExecutorClasspath) + classpathString);
        buildArgs.add(NativeImage.oH(FallbackExecutor.Options.FallbackExecutorMainClass) + this.mainClass);
        buildArgs.add(FallbackExecutor.class.getName());
        buildArgs.add(this.imageName);
        for (OptionHandler<? extends NativeImage> handler : this.optionHandlers) {
            handler.addFallbackBuildArgs(buildArgs);
        }
        return buildArgs;
    }

    protected NativeImage(BuildConfiguration config) {
        this.config = config;
        String configFileEnvVarKey = "NATIVE_IMAGE_CONFIG_FILE";
        String configFile = System.getenv(configFileEnvVarKey);
        if (configFile != null && !configFile.isEmpty()) {
            try {
                this.userConfigProperties.putAll(NativeImage.loadProperties(this.canonicalize(Paths.get(configFile, new String[0]))));
            }
            catch (NativeImageError | Exception e) {
                NativeImage.showError("Invalid environment variable " + configFileEnvVarKey, e);
            }
        }
        this.addPlainImageBuilderArg(this.oHPath + config.getWorkingDirectory());
        this.optionRegistry = new MacroOption.Registry();
        this.registerOptionHandler(new DefaultOptionHandler(this));
        this.apiOptionHandler = new APIOptionHandler(this);
        this.registerOptionHandler(this.apiOptionHandler);
        this.registerOptionHandler(new MacroOptionHandler(this));
    }

    void addMacroOptionRoot(Path configDir) {
        this.optionRegistry.addMacroOptionRoot(this.canonicalize(configDir));
    }

    protected void registerOptionHandler(OptionHandler<? extends NativeImage> handler) {
        this.optionHandlers.add(handler);
    }

    protected Map<String, String> getUserConfigProperties() {
        return this.userConfigProperties;
    }

    protected Path getUserConfigDir() {
        String envVarKey = "NATIVE_IMAGE_USER_HOME";
        String userHomeStr = System.getenv(envVarKey);
        if (userHomeStr == null || userHomeStr.isEmpty()) {
            return Paths.get(System.getProperty("user.home"), ".native-image");
        }
        return Paths.get(userHomeStr, new String[0]);
    }

    protected static void ensureDirectoryExists(Path dir) {
        if (Files.exists(dir, new LinkOption[0])) {
            if (!Files.isDirectory(dir, new LinkOption[0])) {
                throw NativeImage.showError("File " + dir + " is not a directory");
            }
        } else {
            try {
                Files.createDirectories(dir, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw NativeImage.showError("Could not create directory " + dir);
            }
        }
    }

    private void prepareImageBuildArgs() {
        this.config.getBuilderJavaArgs().forEach(xva$0 -> this.addImageBuilderJavaArgs((String)xva$0));
        this.addImageBuilderJavaArgs("-Xss10m");
        this.addImageBuilderJavaArgs(oXms + this.getXmsValue());
        this.addImageBuilderJavaArgs(oXmx + this.getXmxValue(1));
        this.addImageBuilderJavaArgs("-Duser.country=US", "-Duser.language=en");
        this.addImageBuilderJavaArgs("-Dorg.graalvm.version=" + graalvmVersion);
        this.addImageBuilderJavaArgs("-Dorg.graalvm.config=" + graalvmConfig);
        this.addImageBuilderJavaArgs("-Dcom.oracle.graalvm.isaot=true");
        this.config.getBuilderClasspath().forEach(this::addImageBuilderClasspath);
        this.config.getImageProvidedClasspath().forEach(this::addImageProvidedClasspath);
        String clibrariesBuilderArg = this.config.getBuilderCLibrariesPaths().stream().map(path -> this.canonicalize(path.resolve(platform)).toString()).collect(Collectors.joining(",", this.oHCLibraryPath, ""));
        this.addPlainImageBuilderArg(clibrariesBuilderArg);
        if (this.config.getBuilderInspectServerPath() != null) {
            this.addPlainImageBuilderArg(this.oHInspectServerContentPath + this.config.getBuilderInspectServerPath());
        }
        if (this.config.useJavaModules()) {
            String modulePath = this.config.getBuilderModulePath().stream().map(p -> this.canonicalize((Path)p).toString()).collect(Collectors.joining(File.pathSeparator));
            this.addImageBuilderJavaArgs(Arrays.asList("--module-path", modulePath));
            String upgradeModulePath = this.config.getBuilderUpgradeModulePath().stream().map(p -> this.canonicalize((Path)p).toString()).collect(Collectors.joining(File.pathSeparator));
            this.addImageBuilderJavaArgs(Arrays.asList("--upgrade-module-path", upgradeModulePath));
        } else {
            this.config.getBuilderJVMCIClasspath().forEach(this::addImageBuilderClasspath);
            if (!this.config.getBuilderJVMCIClasspathAppend().isEmpty()) {
                String builderJavaArg = this.config.getBuilderJVMCIClasspathAppend().stream().map(path -> this.canonicalize((Path)path).toString()).collect(Collectors.joining(File.pathSeparator, "-Djvmci.class.path.append=", ""));
                this.addImageBuilderJavaArgs(builderJavaArg);
            }
            this.config.getBuilderBootClasspath().forEach(this::addImageBuilderBootClasspath);
        }
        this.config.getImageClasspath().forEach(this::addCustomImageClasspath);
    }

    private void completeOptionArgs() {
        LinkedHashSet<MacroOption.EnabledOption> enabledOptions = this.optionRegistry.getEnabledOptions();
        if (!enabledOptions.isEmpty()) {
            this.addPlainImageBuilderArg(this.oHFallbackThreshold + 0);
        }
        this.enabledLanguages = this.optionRegistry.getEnabledOptions(MacroOption.MacroOptionKind.Language);
        if (this.enabledLanguages.size() > 1) {
            long baseMemRequirements = SubstrateOptionsParser.parseLong((String)"4g");
            long memRequirements = baseMemRequirements + (long)this.enabledLanguages.size() * SubstrateOptionsParser.parseLong((String)"1g");
            this.addImageBuilderJavaArgs(oXmx + memRequirements);
        }
        NativeImage.consolidateListArgs(this.imageBuilderJavaArgs, "-Dpolyglot.engine.PreinitializeContexts=", ",", Function.identity());
        NativeImage.consolidateListArgs(this.imageBuilderJavaArgs, "-Dpolyglot.image-build-time.PreinitializeContexts=", ",", Function.identity());
    }

    protected static String consolidateSingleValueArg(Collection<String> args, String argPrefix) {
        BiFunction<String, String, String> takeLast = (a, b) -> b;
        return NativeImage.consolidateArgs(args, argPrefix, Function.identity(), Function.identity(), () -> null, takeLast);
    }

    protected static boolean replaceArg(Collection<String> args, String argPrefix, String argSuffix) {
        boolean elementsRemoved = args.removeIf(arg -> arg.startsWith(argPrefix));
        args.add(argPrefix + argSuffix);
        return elementsRemoved;
    }

    private static <T> T consolidateArgs(Collection<String> args, String argPrefix, Function<String, T> fromSuffix, Function<T, String> toSuffix, Supplier<T> init, BiFunction<T, T, T> combiner) {
        Object consolidatedValue = null;
        boolean needsConsolidate = false;
        for (String arg : args) {
            if (!arg.startsWith(argPrefix)) continue;
            if (consolidatedValue == null) {
                consolidatedValue = init.get();
            } else {
                needsConsolidate = true;
            }
            consolidatedValue = combiner.apply(consolidatedValue, fromSuffix.apply(arg.substring(argPrefix.length())));
        }
        if (consolidatedValue != null && needsConsolidate) {
            NativeImage.replaceArg(args, argPrefix, toSuffix.apply(consolidatedValue));
        }
        return consolidatedValue;
    }

    private static LinkedHashSet<String> collectListArgs(Collection<String> args, String argPrefix, String delimiter) {
        LinkedHashSet<String> allEntries = new LinkedHashSet<String>();
        for (String arg : args) {
            String argEntriesRaw;
            if (!arg.startsWith(argPrefix) || (argEntriesRaw = arg.substring(argPrefix.length())).isEmpty()) continue;
            allEntries.addAll(Arrays.asList(argEntriesRaw.split(delimiter)));
        }
        return allEntries;
    }

    private static void consolidateListArgs(Collection<String> args, String argPrefix, String delimiter, Function<String, String> mapFunc) {
        LinkedHashSet<String> allEntries = NativeImage.collectListArgs(args, argPrefix, delimiter);
        if (!allEntries.isEmpty()) {
            NativeImage.replaceArg(args, argPrefix, allEntries.stream().map(mapFunc).collect(Collectors.joining(delimiter)));
        }
    }

    private void processClasspathNativeImageMetaInf(Path classpathEntry) {
        this.processClasspathNativeImageMetaInf(classpathEntry, this::processNativeImageMetaInf);
    }

    private void processClasspathNativeImageMetaInf(Path classpathEntry, NativeImageMetaInfResourceProcessor metaInfProcessor) {
        block21: {
            try {
                if (Files.isDirectory(classpathEntry, new LinkOption[0])) {
                    Path nativeImageMetaInfBase = classpathEntry.resolve(Paths.get(nativeImageMetaInf, new String[0]));
                    this.processNativeImageMetaInf(classpathEntry, nativeImageMetaInfBase, metaInfProcessor);
                    break block21;
                }
                List<Object> jarFileMatches = Collections.emptyList();
                if (classpathEntry.endsWith("$JavaCla$$pathWildcard$ubstitute$")) {
                    try {
                        jarFileMatches = Files.list(classpathEntry.getParent()).filter(ClasspathUtils::isJar).collect(Collectors.toList());
                    }
                    catch (NoSuchFileException noSuchFileException) {}
                } else if (Files.isReadable(classpathEntry)) {
                    jarFileMatches = Collections.singletonList(classpathEntry);
                }
                for (Path path : jarFileMatches) {
                    FileSystem probeJarFS;
                    block22: {
                        URI jarFileURI = URI.create("jar:" + path.toUri());
                        try {
                            probeJarFS = FileSystems.newFileSystem(jarFileURI, Collections.emptyMap());
                        }
                        catch (UnsupportedOperationException e) {
                            probeJarFS = null;
                            if (!this.isVerbose()) break block22;
                            NativeImage.showWarning(ClasspathUtils.classpathToString((Path)classpathEntry) + " does not describe valid jarfile" + (jarFileMatches.size() > 1 ? "s" : ""));
                        }
                    }
                    if (probeJarFS == null) continue;
                    FileSystem jarFS = probeJarFS;
                    Throwable throwable = null;
                    try {
                        Path nativeImageMetaInfBase = jarFS.getPath("/META-INF/native-image", new String[0]);
                        this.processNativeImageMetaInf(path, nativeImageMetaInfBase, metaInfProcessor);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (jarFS == null) continue;
                        if (throwable != null) {
                            try {
                                jarFS.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        jarFS.close();
                    }
                }
            }
            catch (IOException | FileSystemNotFoundException e) {
                throw NativeImage.showError("Invalid classpath entry " + ClasspathUtils.classpathToString((Path)classpathEntry), e);
            }
        }
    }

    private void processNativeImageMetaInf(Path classpathEntry, Path nativeImageMetaInfBase, NativeImageMetaInfResourceProcessor metaInfProcessor) throws IOException {
        if (Files.isDirectory(nativeImageMetaInfBase, new LinkOption[0])) {
            for (MetaInfFileType fileType : MetaInfFileType.values()) {
                List nativeImageMetaInfFiles = Files.walk(nativeImageMetaInfBase, new FileVisitOption[0]).filter(p -> p.endsWith(fileType.fileName)).collect(Collectors.toList());
                for (Path nativeImageMetaInfFile : nativeImageMetaInfFiles) {
                    Path resourceRoot = nativeImageMetaInfBase.getParent().getParent();
                    Function<String, String> resolver = str -> {
                        Path componentDirectory = resourceRoot.relativize(nativeImageMetaInfFile).getParent();
                        int nameCount = componentDirectory.getNameCount();
                        String optionArg = null;
                        if (nameCount > 2) {
                            String optionArgKey = componentDirectory.subpath(2, nameCount).toString();
                            optionArg = this.propertyFileSubstitutionValues.get(optionArgKey);
                        }
                        return NativeImage.resolvePropertyValue(str, optionArg, componentDirectory.toString());
                    };
                    this.showVerboseMessage(this.isVerbose(), "Apply " + nativeImageMetaInfFile.toUri());
                    try {
                        metaInfProcessor.processMetaInfResource(classpathEntry, resourceRoot, nativeImageMetaInfFile, fileType, resolver);
                    }
                    catch (NativeImageError err) {
                        NativeImage.showError("Processing " + nativeImageMetaInfFile.toUri() + " failed", err);
                    }
                }
            }
        }
    }

    private void processNativeImageMetaInf(Path classpathEntry, Path resourceRoot, Path resourcePath, MetaInfFileType resourceType, Function<String, String> resolver) throws IOException {
        NativeImageArgsProcessor args = new NativeImageArgsProcessor();
        if (resourceType == MetaInfFileType.Properties) {
            Map<String, String> properties = NativeImage.loadProperties(Files.newInputStream(resourcePath, new OpenOption[0]));
            String imageNameValue = properties.get("ImageName");
            if (imageNameValue != null) {
                this.addCustomImageBuilderArgs(this.oHName + resolver.apply(imageNameValue));
            }
            NativeImage.forEachPropertyValue(properties.get("JavaArgs"), xva$0 -> this.addImageBuilderJavaArgs((String)xva$0), resolver);
            NativeImage.forEachPropertyValue(properties.get("Args"), args, resolver);
        } else {
            args.accept(NativeImage.oH(resourceType.optionKey) + resourceRoot.relativize(resourcePath));
        }
        args.apply(true);
    }

    static void processManifestMainAttributes(Path path, BiConsumer<Path, Attributes> manifestConsumer) {
        if (path.endsWith("$JavaCla$$pathWildcard$ubstitute$")) {
            if (!Files.isDirectory(path.getParent(), new LinkOption[0])) {
                throw NativeImage.showError("Cannot expand wildcard: '" + path + "' is not a directory");
            }
            try {
                Files.list(path.getParent()).filter(ClasspathUtils::isJar).forEach(p -> NativeImage.processJarManifestMainAttributes(p, manifestConsumer));
            }
            catch (IOException e) {
                throw NativeImage.showError("Error while expanding wildcard for '" + path + "'", e);
            }
        } else if (!Files.isDirectory(path, new LinkOption[0])) {
            NativeImage.processJarManifestMainAttributes(path, manifestConsumer);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static boolean processJarManifestMainAttributes(Path jarFilePath, BiConsumer<Path, Attributes> manifestConsumer) {
        try (JarFile jarFile = new JarFile(jarFilePath.toFile());){
            Manifest manifest = jarFile.getManifest();
            if (manifest == null) {
                boolean bl = false;
                return bl;
            }
            manifestConsumer.accept(jarFilePath, manifest.getMainAttributes());
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            throw NativeImage.showError("Invalid or corrupt jarfile " + jarFilePath, e);
        }
    }

    void handleMainClassAttribute(Path jarFilePath, Attributes mainAttributes) {
        String mainClassValue = mainAttributes.getValue("Main-Class");
        if (mainClassValue == null) {
            NativeImage.showError("No main manifest attribute, in " + jarFilePath);
        }
        this.addPlainImageBuilderArg(this.oHClass + mainClassValue);
        String jarFileName = jarFilePath.getFileName().toString();
        String jarSuffix = ".jar";
        String jarFileNameBase = jarFileName.endsWith(jarSuffix) ? jarFileName.substring(0, jarFileName.length() - jarSuffix.length()) : jarFileName;
        if (!jarFileNameBase.isEmpty()) {
            this.addPlainImageBuilderArg(this.oHName + jarFileNameBase);
        }
    }

    void handleClassPathAttribute(Path jarFilePath, Attributes mainAttributes) {
        String classPathValue = mainAttributes.getValue("Class-Path");
        if (classPathValue != null) {
            for (String cp : classPathValue.split(" +")) {
                Path manifestClassPath = ClasspathUtils.stringToClasspath((String)cp);
                if (!manifestClassPath.isAbsolute()) {
                    manifestClassPath = jarFilePath.getParent().resolve(manifestClassPath);
                }
                this.addImageClasspathEntry(this.imageClasspath, manifestClassPath, false);
            }
        }
    }

    private int completeImageBuild() {
        List<String> leftoverArgs = this.processNativeImageArgs();
        this.completeOptionArgs();
        if (this.queryOption != null) {
            this.addPlainImageBuilderArg(oH + this.enablePrintFlags + this.queryOption);
            this.addPlainImageBuilderArg(oR + this.enablePrintFlags + this.queryOption);
        }
        if (!this.config.buildFallbackImage() && this.customImageClasspath.isEmpty() && this.queryOption == null) {
            this.addImageClasspath(Paths.get(".", new String[0]));
        } else {
            this.imageClasspath.addAll(this.customImageClasspath);
        }
        Long xmxValue = NativeImage.consolidateArgs(this.imageBuilderJavaArgs, oXmx, SubstrateOptionsParser::parseLong, String::valueOf, () -> 0L, Math::max);
        Long xmsValue = NativeImage.consolidateArgs(this.imageBuilderJavaArgs, oXms, SubstrateOptionsParser::parseLong, String::valueOf, () -> SubstrateOptionsParser.parseLong((String)this.getXmsValue()), Math::max);
        if (Long.compareUnsigned(xmsValue, xmxValue) > 0) {
            NativeImage.replaceArg(this.imageBuilderJavaArgs, oXms, Long.toUnsignedString(xmxValue));
        }
        if (this.traceClassInitialization()) {
            this.imageBuilderJavaArgs.add("-javaagent:" + this.config.getAgentJAR());
        }
        this.addImageBuilderJavaArgs(this.customJavaArgs.toArray(new String[0]));
        Function<String, String> canonicalizedPathStr = s -> this.canonicalize(Paths.get(s, new String[0])).toString();
        NativeImage.consolidateListArgs(this.imageBuilderArgs, this.oHCLibraryPath, ",", canonicalizedPathStr);
        NativeImage.consolidateListArgs(this.imageBuilderArgs, this.oHSubstitutionFiles, ",", canonicalizedPathStr);
        NativeImage.consolidateListArgs(this.imageBuilderArgs, this.oHReflectionConfigurationFiles, ",", canonicalizedPathStr);
        NativeImage.consolidateListArgs(this.imageBuilderArgs, this.oHDynamicProxyConfigurationFiles, ",", canonicalizedPathStr);
        NativeImage.consolidateListArgs(this.imageBuilderArgs, this.oHResourceConfigurationFiles, ",", canonicalizedPathStr);
        NativeImage.consolidateListArgs(this.imageBuilderArgs, this.oHJNIConfigurationFiles, ",", canonicalizedPathStr);
        BiFunction<String, String, String> takeLast = (a, b) -> b;
        String imagePathStr = NativeImage.consolidateArgs(this.imageBuilderArgs, this.oHPath, Function.identity(), canonicalizedPathStr, () -> null, takeLast);
        try {
            this.imagePath = this.canonicalize(Paths.get(imagePathStr, new String[0]));
        }
        catch (NativeImageError | InvalidPathException e) {
            throw NativeImage.showError("The given " + this.oHPath + imagePathStr + " argument does not specify a valid path", e);
        }
        NativeImage.consolidateArgs(this.imageBuilderArgs, this.oHName, Function.identity(), Function.identity(), () -> null, takeLast);
        this.mainClass = NativeImage.consolidateSingleValueArg(this.imageBuilderArgs, this.oHClass);
        boolean buildExecutable = !this.imageBuilderArgs.stream().anyMatch(arg -> arg.contains(this.enableSharedLibraryFlag));
        boolean printFlags = this.imageBuilderArgs.stream().anyMatch(arg -> arg.contains(this.enablePrintFlags));
        if (!printFlags) {
            ArrayList<String> extraImageArgs = new ArrayList<String>();
            ListIterator<String> leftoverArgsItr = leftoverArgs.listIterator();
            while (leftoverArgsItr.hasNext()) {
                String leftoverArg = leftoverArgsItr.next();
                if (leftoverArg.startsWith("-")) continue;
                leftoverArgsItr.remove();
                extraImageArgs.add(leftoverArg);
            }
            if (!this.jarOptionMode) {
                boolean explicitMainClass = this.customImageBuilderArgs.stream().anyMatch(arg -> arg.startsWith(this.oHClass));
                if (extraImageArgs.isEmpty()) {
                    if (buildExecutable && (this.mainClass == null || this.mainClass.isEmpty())) {
                        NativeImage.showError("Please specify class containing the main entry point method. (see --help)");
                    }
                } else {
                    explicitMainClass = true;
                    this.mainClass = (String)extraImageArgs.remove(0);
                    NativeImage.replaceArg(this.imageBuilderArgs, this.oHClass, this.mainClass);
                }
                if (extraImageArgs.isEmpty()) {
                    if (this.customImageBuilderArgs.stream().noneMatch(arg -> arg.startsWith(this.oHName))) {
                        if (explicitMainClass) {
                            NativeImage.replaceArg(this.imageBuilderArgs, this.oHName, this.mainClass.toLowerCase());
                        } else if (this.imageBuilderArgs.stream().noneMatch(arg -> arg.startsWith(this.oHName))) {
                            throw NativeImage.showError("Missing image-name. Use " + this.oHName + "<imagename> to provide one.");
                        }
                    }
                } else {
                    NativeImage.replaceArg(this.imageBuilderArgs, this.oHName, (String)extraImageArgs.remove(0));
                }
            } else if (!extraImageArgs.isEmpty()) {
                NativeImage.replaceArg(this.imageBuilderArgs, this.oHName, (String)extraImageArgs.remove(0));
            }
            if (!extraImageArgs.isEmpty()) {
                String prefix = "Unknown argument" + (extraImageArgs.size() == 1 ? ": " : "s: ");
                NativeImage.showError(extraImageArgs.stream().collect(Collectors.joining(", ", prefix, "")));
            }
        }
        this.imageName = NativeImage.consolidateSingleValueArg(this.imageBuilderArgs, this.oHName);
        if (!leftoverArgs.isEmpty()) {
            String prefix = "Unrecognized option" + (leftoverArgs.size() == 1 ? ": " : "s: ");
            NativeImage.showError(leftoverArgs.stream().collect(Collectors.joining(", ", prefix, "")));
        }
        LinkedHashSet<Path> finalImageClasspath = new LinkedHashSet<Path>(this.imageBuilderBootClasspath);
        finalImageClasspath.addAll(this.imageBuilderClasspath);
        finalImageClasspath.addAll(this.imageProvidedClasspath);
        finalImageClasspath.addAll(this.imageClasspath);
        if (!this.config.buildFallbackImage() && this.imageBuilderArgs.contains(this.oHFallbackThreshold + 10)) {
            return 2;
        }
        return this.buildImage(this.imageBuilderJavaArgs, this.imageBuilderBootClasspath, this.imageBuilderClasspath, this.imageBuilderArgs, finalImageClasspath);
    }

    private boolean traceClassInitialization() {
        String lastTracelArgument = null;
        for (String imageBuilderArg : this.imageBuilderArgs) {
            if (!imageBuilderArg.contains("TraceClassInitialization")) continue;
            lastTracelArgument = imageBuilderArg;
        }
        return "-H:+TraceClassInitialization".equals(lastTracelArgument);
    }

    protected static List<String> createImageBuilderArgs(LinkedHashSet<String> imageArgs, LinkedHashSet<Path> imagecp) {
        ArrayList<String> result = new ArrayList<String>();
        result.add("-imagecp");
        result.add(imagecp.stream().map(ClasspathUtils::classpathToString).collect(Collectors.joining(File.pathSeparator)));
        result.addAll(imageArgs);
        return result;
    }

    protected int buildImage(List<String> javaArgs, LinkedHashSet<Path> bcp, LinkedHashSet<Path> cp, LinkedHashSet<String> imageArgs, LinkedHashSet<Path> imagecp) {
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        List<String> command = pb.command();
        command.add(this.canonicalize(this.config.getJavaExecutable()).toString());
        command.addAll(javaArgs);
        if (!bcp.isEmpty()) {
            command.add(bcp.stream().map(Path::toString).collect(Collectors.joining(File.pathSeparator, "-Xbootclasspath/a:", "")));
        }
        command.addAll(Arrays.asList("-cp", cp.stream().map(Path::toString).collect(Collectors.joining(File.pathSeparator))));
        command.add("com.oracle.svm.hosted.NativeImageGeneratorRunner");
        if (IS_AOT && OS.getCurrent().hasProcFS) {
            command.addAll(Arrays.asList("-watchpid", "" + ProcessProperties.getProcessID()));
        }
        command.addAll(NativeImage.createImageBuilderArgs(imageArgs, imagecp));
        this.showVerboseMessage(this.isVerbose() || this.dryRun, "Executing [");
        this.showVerboseMessage(this.isVerbose() || this.dryRun, command.stream().collect(Collectors.joining(" \\\n")));
        this.showVerboseMessage(this.isVerbose() || this.dryRun, "]");
        if (this.dryRun) {
            return 0;
        }
        int exitStatus = 1;
        try {
            Process p = pb.inheritIO().start();
            exitStatus = p.waitFor();
        }
        catch (IOException | InterruptedException e) {
            throw NativeImage.showError(e.getMessage());
        }
        return exitStatus;
    }

    public static void main(String[] args) {
        NativeImage.performBuild(new DefaultBuildConfiguration(Arrays.asList(args)), defaultNativeImageProvider);
    }

    public static void build(BuildConfiguration config) {
        NativeImage.build(config, defaultNativeImageProvider);
    }

    public static void agentBuild(Path javaHome, Path workDir, List<String> buildArgs) {
        NativeImage.performBuild(new DefaultBuildConfiguration(javaHome, workDir, buildArgs), NativeImage::new);
    }

    public static Map<Path, List<String>> extractEmbeddedImageArgs(final Path workDir, String[] imageClasspath) {
        NativeImage nativeImage = new NativeImage(new BuildConfiguration(){

            @Override
            public Path getWorkingDirectory() {
                return workDir;
            }
        });
        HashMap<Path, List<String>> extractionResults = new HashMap<Path, List<String>>();
        NativeImageMetaInfResourceProcessor extractor = (classpathEntry, resourceRoot, resourcePath, resourceType, resolver) -> {
            nativeImage.imageBuilderArgs.clear();
            NativeImageArgsProcessor args = nativeImage.new NativeImageArgsProcessor();
            if (resourceType == MetaInfFileType.Properties) {
                Map<String, String> properties = NativeImage.loadProperties(Files.newInputStream(resourcePath, new OpenOption[0]));
                NativeImage.forEachPropertyValue(properties.get("Args"), args, resolver);
            } else {
                args.accept(NativeImage.oH(resourceType.optionKey) + resourceRoot.relativize(resourcePath));
            }
            args.apply(true);
            List perEntryResults = extractionResults.computeIfAbsent(classpathEntry, unused -> new ArrayList());
            perEntryResults.addAll(nativeImage.imageBuilderArgs);
        };
        for (String entry : imageClasspath) {
            Path classpathEntry2 = nativeImage.canonicalize(ClasspathUtils.stringToClasspath((String)entry), false);
            nativeImage.processClasspathNativeImageMetaInf(classpathEntry2, extractor);
        }
        return extractionResults;
    }

    private static void performBuild(BuildConfiguration config, Function<BuildConfiguration, NativeImage> nativeImageProvider) {
        try {
            NativeImage.build(config, nativeImageProvider);
        }
        catch (NativeImageError e) {
            NativeImage.show(System.err::println, "Error: " + e.getMessage());
            for (Throwable cause = e.getCause(); cause != null; cause = cause.getCause()) {
                NativeImage.show(System.err::println, "Caused by: " + cause);
            }
            if (config.getBuildArgs().contains("--verbose")) {
                e.printStackTrace();
            }
            System.exit(1);
        }
        System.exit(0);
    }

    private static void build(BuildConfiguration config, Function<BuildConfiguration, NativeImage> nativeImageProvider) {
        NativeImage nativeImage = nativeImageProvider.apply(config);
        if (config.getBuildArgs().isEmpty()) {
            nativeImage.showMessage(usageText);
        } else {
            try {
                nativeImage.prepareImageBuildArgs();
            }
            catch (NativeImageError e) {
                if (nativeImage.isVerbose()) {
                    throw NativeImage.showError("Requirements for building native images are not fulfilled", e);
                }
                throw NativeImage.showError("Requirements for building native images are not fulfilled [cause: " + e.getMessage() + "]", null);
            }
            int buildStatus = nativeImage.completeImageBuild();
            if (buildStatus == 2) {
                NativeImage.build(FallbackBuildConfiguration.create(nativeImage), nativeImageProvider);
                NativeImage.showWarning("Image '" + nativeImage.imageName + "' is a fallback image that requires a JDK for execution (use --" + "no-fallback" + " to suppress fallback image generation).");
            } else if (buildStatus != 0) {
                throw NativeImage.showError("Image build request failed with exit status " + buildStatus);
            }
        }
    }

    Path canonicalize(Path path) {
        return this.canonicalize(path, true);
    }

    Path canonicalize(Path path, boolean strict) {
        Path absolutePath;
        Path path2 = absolutePath = path.isAbsolute() ? path : this.config.getWorkingDirectory().resolve(path);
        if (!strict) {
            return absolutePath;
        }
        boolean hasWildcard = absolutePath.endsWith("$JavaCla$$pathWildcard$ubstitute$");
        if (hasWildcard) {
            absolutePath = absolutePath.getParent();
        }
        try {
            Path realPath = absolutePath.toRealPath(LinkOption.NOFOLLOW_LINKS);
            if (!Files.isReadable(realPath)) {
                NativeImage.showError("Path entry " + ClasspathUtils.classpathToString((Path)path) + " is not readable");
            }
            if (hasWildcard) {
                if (!Files.isDirectory(realPath, new LinkOption[0])) {
                    NativeImage.showError("Path entry with wildcard " + ClasspathUtils.classpathToString((Path)path) + " is not a directory");
                }
                realPath = realPath.resolve("$JavaCla$$pathWildcard$ubstitute$");
            }
            return realPath;
        }
        catch (IOException e) {
            throw NativeImage.showError("Invalid Path entry " + ClasspathUtils.classpathToString((Path)path), e);
        }
    }

    void addImageBuilderClasspath(Path classpath) {
        this.imageBuilderClasspath.add(this.canonicalize(classpath));
    }

    void addImageBuilderBootClasspath(Path classpath) {
        this.imageBuilderBootClasspath.add(this.canonicalize(classpath));
    }

    void addImageBuilderJavaArgs(String ... javaArgs) {
        this.addImageBuilderJavaArgs(Arrays.asList(javaArgs));
    }

    void addImageBuilderJavaArgs(Collection<String> javaArgs) {
        this.imageBuilderJavaArgs.addAll(javaArgs);
    }

    void addPlainImageBuilderArg(String plainArg) {
        assert (plainArg.startsWith(oH) || plainArg.startsWith(oR));
        this.imageBuilderArgs.remove(plainArg);
        this.imageBuilderArgs.add(plainArg);
    }

    private void addImageProvidedClasspath(Path classpath) {
        VMError.guarantee((this.imageClasspath.isEmpty() && this.customImageClasspath.isEmpty() ? 1 : 0) != 0);
        Path classpathEntry = this.canonicalize(classpath);
        if (this.imageProvidedClasspath.add(classpathEntry)) {
            NativeImage.processManifestMainAttributes(classpathEntry, this::handleClassPathAttribute);
            this.processClasspathNativeImageMetaInf(classpathEntry);
        }
    }

    void addImageClasspath(Path classpath) {
        this.addImageClasspathEntry(this.imageClasspath, classpath, true);
    }

    void addCustomImageClasspath(String classpath) {
        this.addImageClasspathEntry(this.customImageClasspath, ClasspathUtils.stringToClasspath((String)classpath), false);
    }

    void addCustomImageClasspath(Path classpath) {
        this.addImageClasspathEntry(this.customImageClasspath, classpath, true);
    }

    private void addImageClasspathEntry(LinkedHashSet<Path> destination, Path classpath, boolean strict) {
        Path classpathEntry;
        try {
            classpathEntry = this.canonicalize(classpath);
        }
        catch (NativeImageError e) {
            if (strict) {
                throw e;
            }
            if (this.isVerbose()) {
                NativeImage.showWarning("Invalid classpath entry: " + classpath);
            }
            destination.add(this.canonicalize(classpath, false));
            return;
        }
        if (!this.imageClasspath.contains(classpathEntry) && !this.customImageClasspath.contains(classpathEntry)) {
            destination.add(classpathEntry);
            NativeImage.processManifestMainAttributes(classpathEntry, this::handleClassPathAttribute);
            this.processClasspathNativeImageMetaInf(classpathEntry);
        }
    }

    void addCustomJavaArgs(String javaArg) {
        this.customJavaArgs.add(javaArg);
    }

    void addCustomImageBuilderArgs(String plainArg) {
        this.addPlainImageBuilderArg(plainArg);
        this.customImageBuilderArgs.add(plainArg);
    }

    void setVerbose(boolean val) {
        this.verbose = val;
    }

    void setJarOptionMode(boolean val) {
        this.jarOptionMode = val;
    }

    boolean isVerbose() {
        return this.verbose;
    }

    protected void setDryRun(boolean val) {
        this.dryRun = val;
    }

    boolean isDryRun() {
        return this.dryRun;
    }

    public void setQueryOption(String val) {
        this.queryOption = val;
    }

    void showVerboseMessage(boolean show, String message) {
        if (show) {
            NativeImage.show(System.out::println, message);
        }
    }

    void showMessage(String message) {
        NativeImage.show(System.out::println, message);
    }

    void showNewline() {
        System.out.println();
    }

    void showMessagePart(String message) {
        NativeImage.show(s -> {
            System.out.print((String)s);
            System.out.flush();
        }, message);
    }

    public static void showWarning(String message) {
        NativeImage.show(System.err::println, "Warning: " + message);
    }

    public static Error showError(String message) {
        throw new NativeImageError(message);
    }

    public static Error showError(String message, Throwable cause) {
        throw new NativeImageError(message, cause);
    }

    private static void show(Consumer<String> printFunc, String message) {
        printFunc.accept(message);
    }

    static List<Path> getJars(Path dir, String ... jarBaseNames) {
        try {
            List<String> baseNameList = Arrays.asList(jarBaseNames);
            return Files.list(dir).filter(p -> {
                String jarFileName = p.getFileName().toString();
                String jarSuffix = ".jar";
                if (!jarFileName.toLowerCase().endsWith(jarSuffix)) {
                    return false;
                }
                if (baseNameList.isEmpty()) {
                    return true;
                }
                String jarBaseName = jarFileName.substring(0, jarFileName.length() - jarSuffix.length());
                return baseNameList.contains(jarBaseName);
            }).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw NativeImage.showError("Unable to use jar-files from directory " + dir, e);
        }
    }

    private List<String> processNativeImageArgs() {
        NativeImageArgsProcessor argsProcessor = new NativeImageArgsProcessor();
        String defaultNativeImageArgs = this.getUserConfigProperties().get(pKeyNativeImageArgs);
        if (defaultNativeImageArgs != null && !defaultNativeImageArgs.isEmpty()) {
            for (String defaultArg : defaultNativeImageArgs.split(" ")) {
                argsProcessor.accept(defaultArg);
            }
        }
        for (String arg : this.config.getBuildArgs()) {
            argsProcessor.accept(arg);
        }
        return argsProcessor.apply(false);
    }

    protected String getXmsValue() {
        return "1g";
    }

    private static long getPhysicalMemorySize() {
        OperatingSystemMXBean osMXBean = ManagementFactory.getOperatingSystemMXBean();
        long totalPhysicalMemorySize = ((com.sun.management.OperatingSystemMXBean)osMXBean).getTotalPhysicalMemorySize();
        return totalPhysicalMemorySize;
    }

    protected String getXmxValue(int maxInstances) {
        Long memMax = Long.divideUnsigned(Long.divideUnsigned(NativeImage.getPhysicalMemorySize(), 10L) * 8L, maxInstances);
        String maxXmx = "14g";
        if (Long.compareUnsigned(memMax, SubstrateOptionsParser.parseLong((String)maxXmx)) >= 0) {
            return maxXmx;
        }
        return Long.toUnsignedString(memMax);
    }

    static Map<String, String> loadProperties(Path propertiesPath) {
        if (Files.isReadable(propertiesPath)) {
            try {
                return NativeImage.loadProperties(Files.newInputStream(propertiesPath, new OpenOption[0]));
            }
            catch (IOException e) {
                throw NativeImage.showError("Could not read properties-file: " + propertiesPath, e);
            }
        }
        return Collections.emptyMap();
    }

    static Map<String, String> loadProperties(InputStream propertiesInputStream) {
        Properties properties = new Properties();
        try {
            InputStream input = propertiesInputStream;
            Object object = null;
            try {
                properties.load(input);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (input != null) {
                    if (object != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        input.close();
                    }
                }
            }
        }
        catch (IOException e) {
            NativeImage.showError("Could not read properties", e);
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (String key : properties.stringPropertyNames()) {
            map.put(key, properties.getProperty(key));
        }
        return Collections.unmodifiableMap(map);
    }

    static boolean forEachPropertyValue(String propertyValue, Consumer<String> target, Function<String, String> resolver) {
        return NativeImage.forEachPropertyValue(propertyValue, target, resolver, " ");
    }

    static boolean forEachPropertyValue(String propertyValue, Consumer<String> target, Function<String, String> resolver, String separatorRegex) {
        if (propertyValue != null) {
            for (String propertyValuePart : propertyValue.split(separatorRegex)) {
                target.accept(resolver.apply(propertyValuePart));
            }
            return true;
        }
        return false;
    }

    public void addOptionKeyValue(String key, String value) {
        this.propertyFileSubstitutionValues.put(key, value);
    }

    static String resolvePropertyValue(String val, String optionArg, String componentDirectory) {
        String resultVal = val;
        if (optionArg != null) {
            resultVal = NativeImage.safeSubstitution(resultVal, "${*}", optionArg);
            for (String argNameValue : optionArg.split(",")) {
                String[] splitted = argNameValue.split(":");
                if (splitted.length != 2) continue;
                String argName = splitted[0];
                String argValue = splitted[1];
                if (argName.isEmpty()) continue;
                resultVal = NativeImage.safeSubstitution(resultVal, "${" + argName + "}", argValue);
            }
        }
        resultVal = NativeImage.safeSubstitution(resultVal, "${.}", componentDirectory);
        return resultVal;
    }

    private static String safeSubstitution(String source, CharSequence target, CharSequence replacement) {
        if (replacement == null && source.contains(target)) {
            throw NativeImage.showError("Unable to provide meaningful substitution for \"" + target + "\" in " + source);
        }
        return source.replace(target, replacement);
    }

    protected static boolean isDeletedPath(Path toDelete) {
        return toDelete.getFileName().toString().endsWith(deletedFileSuffix);
    }

    protected void deleteAllFiles(Path toDelete) {
        block3: {
            try {
                Path deletedPath = toDelete;
                if (!NativeImage.isDeletedPath(deletedPath)) {
                    deletedPath = toDelete.resolveSibling(toDelete.getFileName() + deletedFileSuffix);
                    Files.move(toDelete, deletedPath, new CopyOption[0]);
                }
                Files.walk(deletedPath, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
            }
            catch (IOException e) {
                if (!this.isVerbose()) break block3;
                this.showMessage("Could not recursively delete path: " + toDelete);
                e.printStackTrace();
            }
        }
    }

    public static final class NativeImageError
    extends Error {
        private NativeImageError(String message) {
            super(message);
        }

        private NativeImageError(String message, Throwable cause) {
            super(message, cause);
        }
    }

    class NativeImageArgsProcessor
    implements Consumer<String> {
        Queue<String> args = new ArrayDeque<String>();

        NativeImageArgsProcessor() {
        }

        @Override
        public void accept(String arg) {
            this.args.add(arg);
        }

        List<String> apply(boolean strict) {
            ArrayList<String> leftoverArgs = new ArrayList<String>();
            while (!this.args.isEmpty()) {
                boolean consumed = false;
                for (int index = NativeImage.this.optionHandlers.size() - 1; index >= 0; --index) {
                    OptionHandler handler = (OptionHandler)NativeImage.this.optionHandlers.get(index);
                    int numArgs = this.args.size();
                    if (!handler.consume(this.args)) continue;
                    assert (this.args.size() < numArgs) : "OptionHandler pretends to consume argument(s) but isn't: " + handler.getClass().getName();
                    consumed = true;
                    break;
                }
                if (consumed) continue;
                if (strict) {
                    NativeImage.showError("Property 'Args' contains invalid entry '" + this.args.peek() + "'");
                    continue;
                }
                leftoverArgs.add(this.args.poll());
            }
            return leftoverArgs;
        }
    }

    static interface NativeImageMetaInfResourceProcessor {
        public void processMetaInfResource(Path var1, Path var2, Path var3, MetaInfFileType var4, Function<String, String> var5) throws IOException;
    }

    static enum MetaInfFileType {
        Properties(null, "native-image.properties"),
        JniConfiguration((OptionKey<?>)ConfigurationFiles.Options.JNIConfigurationResources, "jni-config.json"),
        ReflectConfiguration((OptionKey<?>)ConfigurationFiles.Options.ReflectionConfigurationResources, "reflect-config.json"),
        ResourceConfiguration((OptionKey<?>)ConfigurationFiles.Options.ResourceConfigurationResources, "resource-config.json"),
        ProxyConfiguration((OptionKey<?>)ConfigurationFiles.Options.DynamicProxyConfigurationResources, "proxy-config.json");

        final OptionKey<?> optionKey;
        final String fileName;

        private MetaInfFileType(OptionKey<?> optionKey, String fileName) {
            this.optionKey = optionKey;
            this.fileName = fileName;
        }
    }

    private static final class FallbackBuildConfiguration
    implements InvocationHandler {
        private final NativeImage original;
        private final List<String> buildArgs;

        private FallbackBuildConfiguration(NativeImage original) {
            this.original = original;
            this.buildArgs = original.createFallbackBuildArgs();
        }

        static BuildConfiguration create(NativeImage imageName) {
            FallbackBuildConfiguration handler = new FallbackBuildConfiguration(imageName);
            BuildConfiguration fallback = (BuildConfiguration)Proxy.newProxyInstance(BuildConfiguration.class.getClassLoader(), new Class[]{BuildConfiguration.class}, (InvocationHandler)handler);
            return fallback;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            switch (method.getName()) {
                case "getImageClasspath": {
                    return Collections.emptyList();
                }
                case "getBuildArgs": {
                    return this.buildArgs;
                }
                case "buildFallbackImage": {
                    return true;
                }
            }
            return method.invoke((Object)this.original.config, args);
        }
    }

    private static class DefaultBuildConfiguration
    implements BuildConfiguration {
        private final Path workDir;
        private final Path rootDir;
        private final List<String> args;

        DefaultBuildConfiguration(List<String> args) {
            this(null, null, args);
        }

        DefaultBuildConfiguration(Path rootDir, Path workDir, List<String> args) {
            this.args = args;
            Path path = this.workDir = workDir != null ? workDir : Paths.get(".", new String[0]).toAbsolutePath().normalize();
            if (rootDir != null) {
                this.rootDir = rootDir;
            } else if (IS_AOT) {
                Path executablePath = Paths.get(ProcessProperties.getExecutableName(), new String[0]);
                assert (executablePath != null);
                Path binDir = executablePath.getParent();
                Path rootDirCandidate = binDir.getParent();
                if (rootDirCandidate.endsWith(platform)) {
                    rootDirCandidate = rootDirCandidate.getParent();
                }
                if (rootDirCandidate.endsWith(Paths.get("lib", "svm"))) {
                    rootDirCandidate = rootDirCandidate.getParent().getParent();
                }
                this.rootDir = rootDirCandidate;
            } else {
                String rootDirProperty = "native-image.root";
                String rootDirString = System.getProperty(rootDirProperty);
                if (rootDirString == null) {
                    rootDirString = System.getProperty("java.home");
                }
                this.rootDir = Paths.get(rootDirString, new String[0]);
            }
        }

        @Override
        public Path getWorkingDirectory() {
            return this.workDir;
        }

        @Override
        public Path getJavaExecutable() {
            Path binJava = Paths.get("bin", OS.getCurrent() == OS.WINDOWS ? "java.exe" : "java");
            if (Files.isExecutable(this.rootDir.resolve(binJava))) {
                return this.rootDir.resolve(binJava);
            }
            String javaHome = System.getenv("JAVA_HOME");
            if (javaHome == null) {
                throw NativeImage.showError("Environment variable JAVA_HOME is not set");
            }
            Path javaHomePath = Paths.get(javaHome, new String[0]);
            if (!Files.isExecutable(javaHomePath.resolve(binJava))) {
                throw NativeImage.showError("Environment variable JAVA_HOME does not refer to a directory with a " + binJava + " executable");
            }
            return javaHomePath.resolve(binJava);
        }

        @Override
        public List<Path> getBuilderClasspath() {
            ArrayList<Path> result = new ArrayList<Path>();
            if (this.useJavaModules()) {
                result.addAll(NativeImage.getJars(this.rootDir.resolve(Paths.get("lib", "jvmci")), "graal-sdk", "graal", "enterprise-graal"));
            }
            result.addAll(NativeImage.getJars(this.rootDir.resolve(Paths.get("lib", "svm", "builder")), new String[0]));
            return result;
        }

        @Override
        public List<Path> getBuilderCLibrariesPaths() {
            return Collections.singletonList(this.rootDir.resolve(Paths.get("lib", "svm", "clibraries")));
        }

        @Override
        public List<Path> getImageProvidedClasspath() {
            return NativeImage.getJars(this.rootDir.resolve(Paths.get("lib", "svm")), new String[0]);
        }

        @Override
        public Path getBuilderInspectServerPath() {
            Path inspectPath = this.rootDir.resolve(Paths.get("lib", "svm", "inspect"));
            if (Files.isDirectory(inspectPath, new LinkOption[0])) {
                return inspectPath;
            }
            return null;
        }

        @Override
        public List<Path> getBuilderJVMCIClasspath() {
            return NativeImage.getJars(this.rootDir.resolve(Paths.get("lib", "jvmci")), new String[0]);
        }

        @Override
        public List<Path> getBuilderJVMCIClasspathAppend() {
            return this.getBuilderJVMCIClasspath().stream().filter(f -> f.getFileName().toString().toLowerCase().endsWith("graal.jar")).collect(Collectors.toList());
        }

        @Override
        public List<Path> getBuilderBootClasspath() {
            return NativeImage.getJars(this.rootDir.resolve(Paths.get("lib", "boot")), new String[0]);
        }

        @Override
        public List<Path> getBuilderModulePath() {
            ArrayList<Path> result = new ArrayList<Path>();
            result.addAll(NativeImage.getJars(this.rootDir.resolve(Paths.get("lib", "jvmci")), "graal-sdk", "enterprise-graal"));
            result.addAll(NativeImage.getJars(this.rootDir.resolve(Paths.get("lib", "truffle")), "truffle-api"));
            return result;
        }

        @Override
        public List<Path> getBuilderUpgradeModulePath() {
            return NativeImage.getJars(this.rootDir.resolve(Paths.get("lib", "jvmci")), "graal", "graal-management");
        }

        @Override
        public List<Path> getImageClasspath() {
            return Collections.emptyList();
        }

        @Override
        public List<String> getBuildArgs() {
            if (this.args.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<String> buildArgs = new ArrayList<String>();
            buildArgs.addAll(Arrays.asList("--configurations-path", this.rootDir.toString()));
            buildArgs.addAll(Arrays.asList("--configurations-path", this.rootDir.resolve(Paths.get("lib", "svm")).toString()));
            buildArgs.addAll(this.args);
            return buildArgs;
        }

        @Override
        public String getAgentJAR() {
            return this.rootDir.resolve(Paths.get("lib", "svm", "builder", "svm.jar")).toAbsolutePath().toString();
        }
    }

    public static interface BuildConfiguration {
        public Path getWorkingDirectory();

        default public Path getJavaExecutable() {
            throw VMError.unimplemented();
        }

        default public boolean useJavaModules() {
            try {
                Class.forName("java.lang.Module");
            }
            catch (ClassNotFoundException e) {
                return false;
            }
            return true;
        }

        default public List<Path> getBuilderClasspath() {
            throw VMError.unimplemented();
        }

        default public List<Path> getBuilderCLibrariesPaths() {
            throw VMError.unimplemented();
        }

        default public Path getBuilderInspectServerPath() {
            throw VMError.unimplemented();
        }

        default public List<Path> getImageProvidedClasspath() {
            throw VMError.unimplemented();
        }

        default public List<Path> getBuilderJVMCIClasspath() {
            throw VMError.unimplemented();
        }

        default public List<Path> getBuilderJVMCIClasspathAppend() {
            throw VMError.unimplemented();
        }

        default public List<Path> getBuilderBootClasspath() {
            throw VMError.unimplemented();
        }

        default public List<String> getBuilderJavaArgs() {
            String javaVersion = String.valueOf(JavaVersionUtil.JAVA_SPEC);
            String[] flagsForVersion = graalCompilerFlags.get(javaVersion);
            if (flagsForVersion == null) {
                NativeImage.showError(String.format("Image building not supported for Java version %s in %s with VM configuration \"%s\"", System.getProperty("java.version"), System.getProperty("java.home"), System.getProperty("java.vm.name")));
            }
            if (useJVMCINativeLibrary == null) {
                useJVMCINativeLibrary = false;
                ProcessBuilder pb = new ProcessBuilder(new String[0]);
                List<String> command = pb.command();
                command.add(this.getJavaExecutable().toString());
                command.add("-XX:+PrintFlagsFinal");
                command.add("-version");
                try {
                    Process process = pb.start();
                    try (Scanner inputScanner = new Scanner(process.getInputStream());){
                        while (inputScanner.hasNextLine()) {
                            String value;
                            String line = inputScanner.nextLine();
                            if (!line.contains("bool UseJVMCINativeLibrary") || !(value = SubstrateUtil.split((String)line, (String)"=")[1]).trim().startsWith("true")) continue;
                            useJVMCINativeLibrary = true;
                            break;
                        }
                    }
                    process.waitFor();
                    process.destroy();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ArrayList<String> builderJavaArgs = new ArrayList<String>();
            builderJavaArgs.addAll(Arrays.asList(flagsForVersion));
            if (useJVMCINativeLibrary.booleanValue()) {
                builderJavaArgs.add("-XX:+UseJVMCINativeLibrary");
            } else {
                builderJavaArgs.add("-XX:-UseJVMCICompiler");
            }
            return builderJavaArgs;
        }

        default public List<Path> getBuilderModulePath() {
            throw VMError.unimplemented();
        }

        default public List<Path> getBuilderUpgradeModulePath() {
            throw VMError.unimplemented();
        }

        default public List<Path> getImageClasspath() {
            throw VMError.unimplemented();
        }

        default public List<String> getBuildArgs() {
            throw VMError.unimplemented();
        }

        default public boolean buildFallbackImage() {
            return false;
        }

        default public String getAgentJAR() {
            return null;
        }
    }

    static abstract class OptionHandler<T extends NativeImage> {
        protected final T nativeImage;

        OptionHandler(T nativeImage) {
            this.nativeImage = nativeImage;
        }

        abstract boolean consume(Queue<String> var1);

        void addFallbackBuildArgs(List<String> buildArgs) {
        }
    }
}

