/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core;

import com.oracle.svm.core.annotate.RestrictHeapAccess;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;

public abstract class MemoryWalker {
    public static MemoryWalker getMemoryWalker() {
        return (MemoryWalker)ImageSingletons.lookup(MemoryWalker.class);
    }

    public abstract boolean visitMemory(Visitor var1);

    public static interface RuntimeCompiledMethodAccess<T> {
        public UnsignedWord getStart(T var1);

        public UnsignedWord getSize(T var1);

        public String getName(T var1);
    }

    public static interface ImageCodeAccess<T> {
        public UnsignedWord getStart(T var1);

        public UnsignedWord getSize(T var1);

        public String getRegion(T var1);
    }

    public static interface HeapChunkAccess<T extends PointerBase> {
        public UnsignedWord getStart(T var1);

        public UnsignedWord getSize(T var1);

        public UnsignedWord getAllocationStart(T var1);

        public UnsignedWord getAllocationEnd(T var1);

        public String getRegion(T var1);

        public boolean isAligned(T var1);

        public boolean isPinned(T var1);
    }

    public static interface NativeImageHeapRegionAccess<T> {
        public UnsignedWord getStart(T var1);

        public UnsignedWord getSize(T var1);

        public String getRegion(T var1);
    }

    public static interface Visitor {
        @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate while visiting memory.")
        public <T> boolean visitNativeImageHeapRegion(T var1, NativeImageHeapRegionAccess<T> var2);

        @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate while visiting memory.")
        public <T extends PointerBase> boolean visitHeapChunk(T var1, HeapChunkAccess<T> var2);

        @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate while visiting memory.")
        public <T> boolean visitImageCode(T var1, ImageCodeAccess<T> var2);

        @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate while visiting memory.")
        public <T> boolean visitRuntimeCompiledMethod(T var1, RuntimeCompiledMethodAccess<T> var2);
    }
}

