/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.code;

import com.oracle.svm.core.code.CodeInfoQueryResult;
import com.oracle.svm.core.code.RuntimeMethodInfo;
import com.oracle.svm.core.util.ByteArrayReader;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.core.common.util.UnsafeArrayTypeReader;
import org.graalvm.compiler.graph.NodeSourcePosition;

public class DeoptimizationSourcePositionDecoder {
    static final int NO_SOURCE_POSITION = -1;
    static final int NO_CALLER = 0;

    public static NodeSourcePosition decode(int deoptId, CodeInfoQueryResult codeInfo) {
        if (!(codeInfo.data instanceof RuntimeMethodInfo)) {
            return null;
        }
        RuntimeMethodInfo methodInfo = (RuntimeMethodInfo)codeInfo.data;
        return DeoptimizationSourcePositionDecoder.decode(deoptId, methodInfo.deoptimizationStartOffsets, methodInfo.deoptimizationEncodings, methodInfo.deoptimizationObjectConstants);
    }

    static NodeSourcePosition decode(int deoptId, int[] deoptimizationStartOffsets, byte[] deoptimizationEncodings, Object[] deoptimizationObjectConstants) {
        if (deoptId < 0 || deoptId >= deoptimizationStartOffsets.length) {
            return null;
        }
        int startOffset = deoptimizationStartOffsets[deoptId];
        if (startOffset == -1) {
            return null;
        }
        UnsafeArrayTypeReader readBuffer = UnsafeArrayTypeReader.create((byte[])deoptimizationEncodings, (long)0L, (boolean)ByteArrayReader.supportsUnalignedMemoryAccess());
        return DeoptimizationSourcePositionDecoder.decodeSourcePosition(startOffset, deoptimizationObjectConstants, readBuffer);
    }

    private static NodeSourcePosition decodeSourcePosition(long startOffset, Object[] deoptimizationObjectConstants, UnsafeArrayTypeReader readBuffer) {
        readBuffer.setByteIndex(startOffset);
        long callerRelativeOffset = readBuffer.getUV();
        int bci = readBuffer.getSVInt();
        ResolvedJavaMethod method = (ResolvedJavaMethod)deoptimizationObjectConstants[readBuffer.getUVInt()];
        NodeSourcePosition caller = null;
        if (callerRelativeOffset != 0L) {
            caller = DeoptimizationSourcePositionDecoder.decodeSourcePosition(startOffset - callerRelativeOffset, deoptimizationObjectConstants, readBuffer);
        }
        return new NodeSourcePosition(caller, method, bci);
    }
}

