/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.genscavenge.AlignedHeapChunk;
import com.oracle.svm.core.genscavenge.HeapImpl;
import com.oracle.svm.core.genscavenge.Space;
import com.oracle.svm.core.genscavenge.ThreadLocalAllocation;
import com.oracle.svm.core.genscavenge.UnalignedHeapChunk;
import com.oracle.svm.core.heap.ObjectVisitor;
import com.oracle.svm.core.log.Log;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

final class SpaceVerifierImpl
implements Space.Verifier {
    private Space space;
    private final ContainsObjectVisitor coVisitor = ContainsObjectVisitor.factory();

    public static SpaceVerifierImpl factory() {
        return new SpaceVerifierImpl();
    }

    @Override
    public SpaceVerifierImpl initialize(Space s) {
        this.space = s;
        return this;
    }

    @Override
    public boolean verify() {
        Log trace = HeapImpl.getHeapImpl().getHeapVerifierImpl().getTraceLog();
        trace.string("[SpaceVerifierImpl.verify:").string("  ").string(this.space.getName()).newline();
        boolean result = true;
        boolean isTLASpace = ThreadLocalAllocation.isThreadLocalAllocationSpace(this.space);
        if (isTLASpace) {
            ThreadLocalAllocation.disableThreadLocalAllocation();
        }
        if (!this.verifyChunkLists()) {
            HeapImpl.getHeapImpl().getHeapVerifierImpl().getWitnessLog().string("verifyChunkLists() returns false").string("]").newline();
            result = false;
        }
        if (result && !this.verifyChunks()) {
            HeapImpl.getHeapImpl().getHeapVerifierImpl().getWitnessLog().string("[SpaceVerifierImpl.VerifierImpl.verify:").string("  verifyChunks fails").string("]").newline();
            result = false;
        }
        trace.string("  returns: ").bool(result).string("]").newline();
        return result;
    }

    boolean containsChunks() {
        AlignedHeapChunk.AlignedHeader aChunk = this.space.getFirstAlignedHeapChunk();
        UnalignedHeapChunk.UnalignedHeader uChunk = this.space.getFirstUnalignedHeapChunk();
        return aChunk.isNonNull() || uChunk.isNonNull();
    }

    protected boolean containsObjects() {
        this.coVisitor.prologue();
        this.space.walkObjects(this.coVisitor);
        this.coVisitor.epilogue();
        return this.coVisitor.get();
    }

    private boolean verifyChunkLists() {
        Log trace = HeapImpl.getHeapImpl().getHeapVerifierImpl().getTraceLog();
        trace.string("[SpaceVerifierImpl.VerifierImpl.verifyChunkLists:");
        boolean result = true;
        result &= this.verifyAlignedChunkList();
        trace.string("  returns: ").bool(result &= this.verifyUnalignedList());
        trace.string("]").newline();
        return result;
    }

    private boolean verifyAlignedChunkList() {
        Log trace = HeapImpl.getHeapImpl().getHeapVerifierImpl().getTraceLog().string("[SpaceVerifierImpl.VerifierImpl.verifyAlignedChunkList:");
        trace.string("  Space: ").string(this.space.getName()).newline();
        boolean result = true;
        AlignedHeapChunk.AlignedHeader current = this.space.getFirstAlignedHeapChunk();
        AlignedHeapChunk.AlignedHeader previous = (AlignedHeapChunk.AlignedHeader)WordFactory.nullPointer();
        while (current.isNonNull()) {
            AlignedHeapChunk.AlignedHeader previousOfCurrent = (AlignedHeapChunk.AlignedHeader)current.getPrevious();
            if (!(result &= previousOfCurrent.equal((ComparableWord)previous))) {
                Log failure = HeapImpl.getHeapImpl().getHeapVerifierImpl().getWitnessLog().string("[SpaceVerifierImpl.VerifierImpl.verifyAlignedChunkList:");
                failure.string("  space: ").string(this.space.getName()).string("  doubly-linked list failure").newline();
                failure.string("  current: ").hex((WordBase)current);
                failure.string("  current.previous: ").hex((WordBase)previousOfCurrent);
                failure.string("  previous: ").hex((WordBase)previous);
                failure.string("]").newline();
                break;
            }
            previous = current;
            current = (AlignedHeapChunk.AlignedHeader)current.getNext();
        }
        if (!(result &= previous.equal((ComparableWord)this.space.getLastAlignedHeapChunk()))) {
            Log failure = HeapImpl.getHeapImpl().getHeapVerifierImpl().getWitnessLog().string("[SpaceVerifierImpl.VerifierImpl.verifyAlignedChunkList:");
            failure.string("  space: ").string(this.space.getName()).string("  lastAlignedHeapChunk failure").string("]").newline();
            failure.string("  previous: ").hex((WordBase)previous);
            failure.string("  lastAlignedHeapChunk: ").hex((WordBase)this.space.getLastAlignedHeapChunk());
            failure.string("]").newline();
            result = false;
        }
        trace.string("  returns: ").bool(result).string("]").newline();
        return result;
    }

    private boolean verifyUnalignedList() {
        Log failure;
        Log trace = HeapImpl.getHeapImpl().getHeapVerifierImpl().getTraceLog().string("[SpaceVerifierImpl.verifyUnalignedChunkList:");
        boolean result = true;
        UnalignedHeapChunk.UnalignedHeader current = this.space.getFirstUnalignedHeapChunk();
        UnalignedHeapChunk.UnalignedHeader previous = (UnalignedHeapChunk.UnalignedHeader)WordFactory.nullPointer();
        while (current.isNonNull()) {
            if (!(result &= ((UnalignedHeapChunk.UnalignedHeader)current.getPrevious()).equal((ComparableWord)previous))) {
                failure = HeapImpl.getHeapImpl().getHeapVerifierImpl().getWitnessLog().string("[SpaceVerifierImpl.VerifierImpl.verifyUnalignedChunkList:");
                failure.string("  space: ").string(this.space.getName()).string("  doubly-linked list failure").string("]").newline();
                break;
            }
            previous = current;
            current = (UnalignedHeapChunk.UnalignedHeader)current.getNext();
        }
        if (!(result &= previous.equal((ComparableWord)this.space.getLastUnalignedHeapChunk()))) {
            failure = HeapImpl.getHeapImpl().getHeapVerifierImpl().getWitnessLog().string("[SpaceVerifierImpl.VerifierImpl.verifyUnalignedChunkList:");
            failure.string("  space: ").string(this.space.getName()).string("  lastUnalignedHeapChunk failure").string("]").newline();
            result = false;
        }
        trace.string("  returns: ").bool(result).string("]").newline();
        return result;
    }

    private boolean verifyChunks() {
        Log trace = HeapImpl.getHeapImpl().getHeapVerifierImpl().getTraceLog().string("[SpaceVerifierImpl.VerifierImpl.verifyChunks:");
        boolean result = true;
        result &= this.verifyAlignedChunks();
        trace.string("  returns: ").bool(result &= this.verifyUnalignedChunks()).string("]").newline();
        return result;
    }

    private boolean verifyAlignedChunks() {
        Log trace = HeapImpl.getHeapImpl().getHeapVerifierImpl().getTraceLog().string("[SpaceVerifierImpl.VerifierImpl.verifyAlignedChunks:");
        boolean result = true;
        AlignedHeapChunk.AlignedHeader chunk = this.space.getFirstAlignedHeapChunk();
        while (chunk.isNonNull()) {
            result &= AlignedHeapChunk.verifyAlignedHeapChunk(chunk);
            chunk = (AlignedHeapChunk.AlignedHeader)chunk.getNext();
        }
        trace.string("  returns: ").bool(result).string("]").newline();
        return result;
    }

    private boolean verifyUnalignedChunks() {
        Log trace = HeapImpl.getHeapImpl().getHeapVerifierImpl().getTraceLog().string("[SpaceVerifierImpl.verifyUnalignedChunks:");
        boolean result = true;
        UnalignedHeapChunk.UnalignedHeader chunk = this.space.getFirstUnalignedHeapChunk();
        while (chunk.isNonNull()) {
            result &= UnalignedHeapChunk.verifyUnalignedHeapChunk(chunk);
            chunk = (UnalignedHeapChunk.UnalignedHeader)chunk.getNext();
        }
        trace.string("  returns: ").bool(result).string("]").newline();
        return result;
    }

    boolean verifyOnlyCleanCards() {
        Log trace = HeapImpl.getHeapImpl().getHeapVerifierImpl().getTraceLog().string("[SpaceVerifierImpl.VerifierImpl.verifyOnlyCleanCards:");
        trace.string("  space: ").string(this.space.getName()).newline();
        boolean result = this.verifyOnlyCleanAlignedChunks() && this.verifyOnlyCleanUnalignedChunks();
        trace.string("  returns: ").bool(result).string("]").newline();
        return result;
    }

    private boolean verifyOnlyCleanAlignedChunks() {
        Log trace = HeapImpl.getHeapImpl().getHeapVerifierImpl().getTraceLog().string("[SpaceVerifierImpl.VerifierImpl.verifyOnlyAlignedChunks:").newline();
        boolean result = true;
        AlignedHeapChunk.AlignedHeader chunk = this.space.getFirstAlignedHeapChunk();
        while (chunk.isNonNull()) {
            result &= AlignedHeapChunk.verifyOnlyCleanCards(chunk);
            chunk = (AlignedHeapChunk.AlignedHeader)chunk.getNext();
        }
        trace.string("  returns: ").bool(result).string("]").newline();
        return result;
    }

    private boolean verifyOnlyCleanUnalignedChunks() {
        Log trace = HeapImpl.getHeapImpl().getHeapVerifierImpl().getTraceLog().string("[SpaceVerifierImpl.verifyOnlyCleanUnalignedChunks:").newline();
        boolean result = true;
        UnalignedHeapChunk.UnalignedHeader chunk = this.space.getFirstUnalignedHeapChunk();
        while (chunk.isNonNull()) {
            result &= UnalignedHeapChunk.verifyOnlyCleanCardsOfUnalignedHeapChunk(chunk);
            chunk = (UnalignedHeapChunk.UnalignedHeader)chunk.getNext();
        }
        trace.string("  returns: ").bool(result).string("]").newline();
        return result;
    }

    private SpaceVerifierImpl() {
    }

    public static class ContainsObjectVisitor
    implements ObjectVisitor {
        private boolean containsObject;

        public static ContainsObjectVisitor factory() {
            return new ContainsObjectVisitor();
        }

        @Override
        public boolean prologue() {
            this.reset();
            return true;
        }

        @Override
        public boolean visitObject(Object o) {
            this.containsObject = true;
            return false;
        }

        public boolean get() {
            return this.containsObject;
        }

        private ContainsObjectVisitor reset() {
            this.containsObject = false;
            return this;
        }

        ContainsObjectVisitor() {
            this.reset();
        }
    }
}

