/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.aarch64;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.graal.meta.SubstrateRegisterConfig;
import com.oracle.svm.core.thread.Safepoint;
import jdk.vm.ci.aarch64.AArch64Kind;
import jdk.vm.ci.code.Register;
import org.graalvm.compiler.asm.aarch64.AArch64Address;
import org.graalvm.compiler.asm.aarch64.AArch64MacroAssembler;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.aarch64.AArch64LIRInstruction;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;

public class AArch64DecrementingSafepointCheckOp
extends AArch64LIRInstruction {
    public static final LIRInstructionClass<AArch64DecrementingSafepointCheckOp> TYPE = LIRInstructionClass.create(AArch64DecrementingSafepointCheckOp.class);

    protected AArch64DecrementingSafepointCheckOp() {
        super(TYPE);
    }

    public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
        assert (SubstrateOptions.MultiThreaded.getValue().booleanValue());
        SubstrateRegisterConfig threadRegister = (SubstrateRegisterConfig)crb.codeCache.getRegisterConfig();
        AArch64Address safepointAddress = AArch64Address.createUnscaledImmediateAddress((Register)threadRegister.getThreadRegister(), (int)Math.toIntExact(Safepoint.getThreadLocalSafepointRequestedOffset()));
        int safepointSize = AArch64Kind.QWORD.getSizeInBytes() * 8;
        try (AArch64MacroAssembler.ScratchRegister scratchRegister = masm.getScratchRegister();){
            Register scratch = scratchRegister.getRegister();
            masm.ldr(safepointSize, scratch, safepointAddress);
            masm.subs(safepointSize, scratch, scratch, 1);
            masm.str(safepointSize, scratch, safepointAddress);
        }
    }
}

