/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.nodes;

import com.oracle.svm.core.FrameAccess;
import com.oracle.svm.core.graal.meta.SubstrateRegisterConfig;
import java.util.function.Function;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.meta.ValueKind;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.lir.gen.LIRGeneratorTool;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.spi.LIRLowerable;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;

@NodeInfo(cycles=NodeCycles.CYCLES_1, size=NodeSize.SIZE_1)
public class ReadRegisterFixedNode
extends FixedWithNextNode
implements LIRLowerable {
    public static final NodeClass<ReadRegisterFixedNode> TYPE = NodeClass.create(ReadRegisterFixedNode.class);
    private final Function<SubstrateRegisterConfig, Register> registerSupplier;

    public static ReadRegisterFixedNode forHeapBase() {
        return new ReadRegisterFixedNode(SubstrateRegisterConfig::getHeapBaseRegister);
    }

    public static ReadRegisterFixedNode forIsolateThread() {
        return new ReadRegisterFixedNode(SubstrateRegisterConfig::getThreadRegister);
    }

    public ReadRegisterFixedNode(Function<SubstrateRegisterConfig, Register> registerSupplier) {
        super(TYPE, FrameAccess.getWordStamp());
        this.registerSupplier = registerSupplier;
    }

    public void generate(NodeLIRBuilderTool gen) {
        LIRGeneratorTool tool = gen.getLIRGeneratorTool();
        SubstrateRegisterConfig registerConfig = (SubstrateRegisterConfig)tool.getRegisterConfig();
        LIRKind lirKind = tool.getLIRKind(FrameAccess.getWordStamp());
        Register register = this.registerSupplier.apply(registerConfig);
        gen.setResult((ValueNode)this, (Value)tool.emitReadRegister(register, (ValueKind)lirKind));
    }
}

