/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.jdk.SubstrateThreadMXBean;
import java.io.IOException;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.CompilationMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryManagerMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.PlatformManagedObject;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import org.graalvm.nativeimage.ImageSingletons;

@TargetClass(value=ManagementFactory.class)
final class Target_java_lang_management_ManagementFactory {
    Target_java_lang_management_ManagementFactory() {
    }

    @Substitute
    private static List<GarbageCollectorMXBean> getGarbageCollectorMXBeans() {
        return Heap.getHeap().getGC().getGarbageCollectorMXBeanList();
    }

    @Substitute
    private static MemoryMXBean getMemoryMXBean() {
        return Heap.getHeap().getMemoryMXBean();
    }

    @Substitute
    private static RuntimeMXBean getRuntimeMXBean() {
        return (RuntimeMXBean)ImageSingletons.lookup(RuntimeMXBean.class);
    }

    @Substitute
    private static ThreadMXBean getThreadMXBean() {
        return SubstrateThreadMXBean.singleton();
    }

    @Substitute
    private static OperatingSystemMXBean getOperatingSystemMXBean() {
        return (OperatingSystemMXBean)ImageSingletons.lookup(OperatingSystemMXBean.class);
    }

    @Substitute
    private static ClassLoadingMXBean getClassLoadingMXBean() {
        return (ClassLoadingMXBean)ImageSingletons.lookup(ClassLoadingMXBean.class);
    }

    @Substitute
    private static CompilationMXBean getCompilationMXBean() {
        return (CompilationMXBean)ImageSingletons.lookup(CompilationMXBean.class);
    }

    @Substitute
    private static List<MemoryPoolMXBean> getMemoryPoolMXBeans() {
        return Collections.emptyList();
    }

    @Substitute
    private static List<MemoryManagerMXBean> getMemoryManagerMXBeans() {
        return Collections.emptyList();
    }

    @Substitute
    private static MBeanServer getPlatformMBeanServer() {
        return null;
    }

    @Substitute
    private static <T> T newPlatformMXBeanProxy(MBeanServerConnection connection, String mxbeanName, Class<T> mxbeanInterface) throws IOException {
        return null;
    }

    @Substitute
    private static <T extends PlatformManagedObject> T getPlatformMXBean(Class<T> mxbeanInterface) {
        return null;
    }

    @Substitute
    private static <T extends PlatformManagedObject> List<T> getPlatformMXBeans(Class<T> mxbeanInterface) {
        return Collections.emptyList();
    }

    @Substitute
    private static <T extends PlatformManagedObject> T getPlatformMXBean(MBeanServerConnection connection, Class<T> mxbeanInterface) throws IOException {
        return null;
    }

    @Substitute
    private static <T extends PlatformManagedObject> List<T> getPlatformMXBeans(MBeanServerConnection connection, Class<T> mxbeanInterface) throws IOException {
        return Collections.emptyList();
    }

    @Substitute
    private static Set<Class<? extends PlatformManagedObject>> getPlatformManagementInterfaces() {
        return Collections.emptySet();
    }
}

