/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.annotate.NeverInline;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.annotate.TargetElement;
import com.oracle.svm.core.jdk.JDK11OrLater;
import com.oracle.svm.core.jdk.Package_jdk_internal_reflect;
import com.oracle.svm.core.jdk.StackTraceUtils;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.util.VMError;

@TargetClass(classNameProvider=Package_jdk_internal_reflect.class, className="Reflection")
public final class Target_jdk_internal_reflect_Reflection {
    @Substitute
    @NeverInline(value="Starting a stack walk in the caller frame")
    public static Class<?> getCallerClass() {
        return StackTraceUtils.getCallerClass(KnownIntrinsics.readCallerStackPointer(), KnownIntrinsics.readReturnAddress());
    }

    @Substitute
    public static int getClassAccessFlags(Class<?> cls) {
        return cls.getModifiers();
    }

    @Substitute
    @TargetElement(onlyWith={JDK11OrLater.class})
    public static boolean areNestMates(Class<?> currentClass, Class<?> memberClass) {
        throw VMError.unsupportedFeature("JDK11OrLater: Target_jdk_internal_reflect_Reflection.areNestMates");
    }
}

