/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix;

import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.c.function.CEntryPointOptions;
import com.oracle.svm.core.posix.PosixUtils;
import com.oracle.svm.core.posix.headers.Pthread;
import com.oracle.svm.core.posix.headers.Signal;
import java.io.IOException;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.function.CEntryPoint;
import org.graalvm.nativeimage.c.function.CEntryPointLiteral;

@Platforms(value={Platform.LINUX.class, Platform.DARWIN.class})
public class PosixInterruptSignalUtils {
    static boolean initialized = false;
    private static final Signal.SignalEnum INTERRUPT_SIGNAL = Signal.SignalEnum.SIGIO;
    private static final CEntryPointLiteral<Signal.SignalDispatcher> nullDispatcher = CEntryPointLiteral.create(PosixInterruptSignalUtils.class, (String)"nullHandler", (Class[])new Class[]{Integer.TYPE});

    @CEntryPoint
    @CEntryPointOptions(prologue=CEntryPointOptions.NoPrologue.class, epilogue=CEntryPointOptions.NoEpilogue.class, publishAs=CEntryPointOptions.Publish.NotPublished, include=CEntryPointOptions.NotIncludedAutomatically.class)
    @Uninterruptible(reason="Can not check for safepoints because I am running on a borrowed thread.")
    private static void nullHandler(int signalNumber) {
    }

    public static void ensureInitialized() throws IOException {
        if (!initialized) {
            Signal.sigaction saPointer = (Signal.sigaction)StackValue.get(Signal.sigaction.class);
            Signal.sigaction osaPointer = (Signal.sigaction)StackValue.get(Signal.sigaction.class);
            saPointer.sa_handler((Signal.SignalDispatcher)nullDispatcher.getFunctionPointer());
            saPointer.sa_flags(0);
            Signal.sigemptyset(saPointer.sa_mask());
            if (Signal.sigaction(INTERRUPT_SIGNAL, saPointer, osaPointer) < 0) {
                throw PosixUtils.newIOExceptionWithLastError("sigaction");
            }
            initialized = true;
        }
    }

    public static int interruptPThread(Pthread.pthread_t pThread) throws IOException {
        PosixInterruptSignalUtils.ensureInitialized();
        return Pthread.pthread_kill(pThread, INTERRUPT_SIGNAL);
    }
}

