/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix;

import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.jni.JNIRuntimeAccess;
import com.oracle.svm.core.util.VMError;
import java.net.InetAddress;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.function.CLibrary;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeReflection;
import org.graalvm.nativeimage.impl.InternalPlatform;

@Platforms(value={InternalPlatform.LINUX_JNI.class, InternalPlatform.DARWIN_JNI.class})
@AutomaticFeature
@CLibrary(value="net", requireStatic=true)
class PosixJavaNetSubstitutionsFeature
implements Feature {
    PosixJavaNetSubstitutionsFeature() {
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        try {
            JNIRuntimeAccess.register(access.findClassByName("java.net.InetAddress").getDeclaredMethod("anyLocalAddress", new Class[0]));
            JNIRuntimeAccess.register(access.findClassByName("java.net.InetAddressContainer"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.InetAddressContainer").getDeclaredField("addr"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.InetSocketAddress"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.InetSocketAddress").getDeclaredConstructor(InetAddress.class, Integer.TYPE));
            JNIRuntimeAccess.register(access.findClassByName("java.net.SocketInputStream"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.SocketOutputStream"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.DatagramSocketImpl"));
            JNIRuntimeAccess.register(access.findClassByName("java.lang.Integer").getDeclaredField("value"));
            JNIRuntimeAccess.register(access.findClassByName("java.lang.Boolean").getDeclaredMethod("getBoolean", String.class));
            RuntimeReflection.register((Class[])new Class[]{access.findClassByName("java.net.InetAddressImpl")});
            RuntimeReflection.register((Class[])new Class[]{access.findClassByName("java.net.Inet4AddressImpl")});
            RuntimeReflection.register((Class[])new Class[]{access.findClassByName("java.net.Inet6AddressImpl")});
            RuntimeReflection.registerForReflectiveInstantiation((Class[])new Class[]{access.findClassByName("java.net.Inet4AddressImpl")});
            RuntimeReflection.registerForReflectiveInstantiation((Class[])new Class[]{access.findClassByName("java.net.Inet6AddressImpl")});
        }
        catch (Exception e) {
            VMError.shouldNotReachHere("PosixJavaNetSubstitutionsFeature: Error registering class or method: ", e);
        }
    }
}

