/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Delete;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.annotate.TargetElement;
import com.oracle.svm.core.jdk.JDK11OrLater;
import com.oracle.svm.core.jdk.JDK8OrEarlier;
import com.oracle.svm.core.posix.Java_lang_Process_Supplement;
import com.oracle.svm.core.posix.PosixUtils;
import com.oracle.svm.core.posix.ProcessNameProvider;
import com.oracle.svm.core.posix.UNIXProcess_Support;
import com.oracle.svm.core.posix.headers.Signal;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.Executor;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.impl.InternalPlatform;

@TargetClass(classNameProvider=ProcessNameProvider.class)
@Platforms(value={InternalPlatform.LINUX_AND_JNI.class, InternalPlatform.DARWIN_AND_JNI.class})
final class Target_java_lang_UNIXProcess {
    @Platforms(value={Platform.LINUX.class, Platform.DARWIN.class})
    @TargetElement(onlyWith={JDK8OrEarlier.class})
    @Delete
    static Executor processReaperExecutor;
    @Alias
    int pid;
    @Alias
    OutputStream stdin;
    @Alias
    InputStream stdout;
    @Alias
    InputStream stderr;
    @Alias
    int exitcode;
    @Alias
    boolean hasExited;

    Target_java_lang_UNIXProcess() {
    }

    @Substitute
    @Platforms(value={Platform.LINUX.class, Platform.DARWIN.class})
    int forkAndExec(int mode, byte[] helperpath, byte[] file, byte[] argBlock, int argCount, byte[] envBlock, int envCount, byte[] dir, int[] fds, boolean redirectErrorStream) throws IOException {
        return Java_lang_Process_Supplement.forkAndExec(mode, helperpath, file, argBlock, argCount, envBlock, envCount, dir, fds, redirectErrorStream);
    }

    @Substitute
    @TargetElement(onlyWith={JDK8OrEarlier.class})
    @Platforms(value={Platform.LINUX.class, Platform.DARWIN.class})
    void initStreams(int[] fds) {
        UNIXProcess_Support.doInitStreams(this, fds, false);
    }

    @Substitute
    @TargetElement(onlyWith={JDK11OrLater.class})
    @Platforms(value={Platform.LINUX.class, Platform.DARWIN.class})
    void initStreams(int[] fds, boolean forceNullOutputStream) {
        UNIXProcess_Support.doInitStreams(this, fds, forceNullOutputStream);
    }

    @Substitute
    @Platforms(value={Platform.LINUX.class, Platform.DARWIN.class})
    @TargetElement(onlyWith={JDK8OrEarlier.class})
    int waitForProcessExit(int ppid) {
        return PosixUtils.waitForProcessExit(ppid);
    }

    @Substitute
    @TargetElement(onlyWith={JDK8OrEarlier.class})
    @Platforms(value={Platform.LINUX.class, Platform.DARWIN.class})
    static void destroyProcess(int ppid, boolean force) {
        int sig = force ? Signal.SignalEnum.SIGKILL.getCValue() : Signal.SignalEnum.SIGTERM.getCValue();
        Signal.kill(ppid, sig);
    }
}

