/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.util;

import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.jdk.UninterruptibleUtils;
import com.oracle.svm.core.log.Log;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

public class TimeUtils {
    public static final long millisPerSecond = 1000L;
    public static final long microsPerSecond = 1000000L;
    public static final long nanosPerSecond = 1000000000L;
    public static final long nanosPerMilli = 1000000L;
    public static final long microsPerNano = 1000L;

    public static long secondsToMillis(long seconds) {
        return TimeUtils.multiplyOrMaxValue(seconds, 1000L);
    }

    @Uninterruptible(reason="Called from uninterruptible code.")
    public static long secondsToNanos(long seconds) {
        return TimeUtils.multiplyOrMaxValue(seconds, 1000000000L);
    }

    @Uninterruptible(reason="Called from uninterruptible code.")
    public static long millisToNanos(long millis) {
        return TimeUtils.multiplyOrMaxValue(millis, 1000000L);
    }

    @Uninterruptible(reason="Called from uninterruptible code.")
    public static long microsToNanos(long micros) {
        return TimeUtils.multiplyOrMaxValue(micros, 1000L);
    }

    public static long nanoSecondsSince(long startNanos) {
        return System.nanoTime() - startNanos;
    }

    public static long milliSecondsSince(long startMillis) {
        return System.currentTimeMillis() - startMillis;
    }

    public static boolean nanoTimeLessThan(long leftNanos, long rightNanos) {
        return leftNanos - rightNanos < 0L;
    }

    public static long delayNanos(boolean isAbsolute, long time) {
        if (isAbsolute) {
            return TimeUtils.millisToNanos(time - System.currentTimeMillis());
        }
        return time;
    }

    @Uninterruptible(reason="Called from uninterruptible code.")
    public static long divideNanosToSeconds(long nanos) {
        return nanos / 1000000000L;
    }

    @Uninterruptible(reason="Called from uninterruptible code.")
    public static long remainderNanosToSeconds(long nanos) {
        return nanos % 1000000000L;
    }

    public static long divideNanosToMillis(long nanos) {
        return nanos / 1000000L;
    }

    public static long roundNanosToMillis(long nanos) {
        return TimeUtils.roundedDivide(nanos, 1000000L);
    }

    public static long roundNanosToSeconds(long nanos) {
        return TimeUtils.roundedDivide(nanos, 1000000000L);
    }

    public static long roundedDivide(long numerator, long denominator) {
        long halfStep = denominator / 2L;
        long addition = TimeUtils.addOrMaxValue(numerator, halfStep);
        return addition / denominator;
    }

    public static long weightedNanos(int percent, long nanos) {
        UnsignedWord unweightedNanos = WordFactory.unsigned((long)nanos);
        long result = unweightedNanos.unsignedDivide(100).multiply(percent).rawValue();
        return result;
    }

    @Uninterruptible(reason="Called from uninterruptible code.")
    public static long addOrMaxValue(long x, long y) {
        long r = x + y;
        if (((x ^ r) & (y ^ r)) < 0L) {
            r = Long.MAX_VALUE;
        }
        return r;
    }

    @Uninterruptible(reason="Called from uninterruptible code.")
    public static long multiplyOrMaxValue(long x, long y) {
        long ay;
        long r = x * y;
        long ax = UninterruptibleUtils.Math.abs(x);
        if ((ax | (ay = UninterruptibleUtils.Math.abs(y))) >>> 31 != 0L && (y != 0L && r / y != x || x == Long.MIN_VALUE && y == -1L)) {
            r = Long.MAX_VALUE;
        }
        return r;
    }

    public static long doNotLoopTooLong(long startNanos, long loopNanos, long warningNanos, String message) {
        long result = loopNanos;
        long waitedNanos = TimeUtils.nanoSecondsSince(loopNanos);
        if (0L < warningNanos && TimeUtils.nanoTimeLessThan(warningNanos, waitedNanos)) {
            Log.log().string("[TimeUtils.doNotLoopTooLong:").string("  startNanos: ").signed(startNanos).string("  warningNanos: ").signed(warningNanos).string(" < ").string(" waitedNanos: ").signed(waitedNanos).string("  reason: ").string(message).string("]").newline();
            result = System.nanoTime();
        }
        return result;
    }

    public static boolean maybeFatallyTooLong(long startNanos, long failureNanos, String reason) {
        long nanosSinceStart;
        if (0L < failureNanos && TimeUtils.nanoTimeLessThan(failureNanos, nanosSinceStart = TimeUtils.nanoSecondsSince(startNanos))) {
            Log.log().string("[TimeUtils.maybeFatallyTooLong:").string("  startNanos: ").signed(startNanos).string("  failureNanos: ").signed(failureNanos).string(" < nanosSinceStart: ").signed(nanosSinceStart).string("  reason: ").string(reason).string("]").newline();
            return true;
        }
        return false;
    }
}

