/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.windows;

import com.oracle.svm.core.windows.WindowsUtils;
import com.oracle.svm.core.windows.headers.FileAPI;
import com.oracle.svm.core.windows.headers.LibC;
import org.graalvm.nativeimage.LogHandler;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.word.UnsignedWord;

public class WindowsLogHandler
implements LogHandler {
    public void log(CCharPointer bytes, UnsignedWord length) {
        if (!WindowsUtils.writeBytes(WindowsLogHandler.getOutputFile(), bytes, length)) {
            this.fatalError();
        }
    }

    public void flush() {
        WindowsUtils.flush(WindowsLogHandler.getOutputFile());
    }

    public void fatalError() {
        LibC.abort();
    }

    private static int getOutputFile() {
        return FileAPI.GetStdHandle(FileAPI.STD_ERROR_HANDLE());
    }
}

