/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.jni.functions;

import com.oracle.svm.core.FrameAccess;
import com.oracle.svm.core.annotate.UnknownObjectField;
import com.oracle.svm.core.util.VMError;
import java.util.stream.IntStream;
import org.graalvm.nativeimage.c.function.CFunctionPointer;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordBase;

class JNIStructFunctionsInitializer<T extends PointerBase> {
    private final int structSize;
    private WordBase defaultValue;
    @UnknownObjectField(types={int[].class})
    private int[] offsets;
    @UnknownObjectField(types={CFunctionPointer[].class})
    private CFunctionPointer[] functions;

    JNIStructFunctionsInitializer(Class<T> structClass, int[] offsets, CFunctionPointer[] functions, WordBase defaultValue) {
        this.structSize = SizeOf.get(structClass);
        this.offsets = offsets;
        this.functions = functions;
        this.defaultValue = defaultValue;
        int wordSize = FrameAccess.wordSize();
        VMError.guarantee(this.structSize % wordSize == 0 && IntStream.of(offsets).allMatch(offset -> offset % wordSize == 0), "Unaligned struct breaks default value initialization");
    }

    public void initialize(T structure) {
        Pointer p = (Pointer)structure;
        int wordSize = FrameAccess.wordSize();
        int k = 0;
        while (k + wordSize <= this.structSize) {
            p.writeWord(k, this.defaultValue);
            k += wordSize;
        }
        for (int i = 0; i < this.offsets.length; ++i) {
            p.writeWord(this.offsets[i], (WordBase)this.functions[i]);
        }
    }
}

