/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.jni.hosted;

import com.oracle.graal.pointsto.infrastructure.GraphProvider;
import com.oracle.graal.pointsto.meta.HostedProviders;
import com.oracle.svm.core.c.function.CEntryPointOptions;
import com.oracle.svm.core.graal.nodes.CEntryPointEnterNode;
import com.oracle.svm.core.graal.nodes.CEntryPointLeaveNode;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.code.CEntryPointData;
import com.oracle.svm.hosted.code.SimpleSignature;
import com.oracle.svm.jni.hosted.JNIGeneratedMethod;
import com.oracle.svm.jni.hosted.JNIGraphKit;
import com.oracle.svm.jni.nativeapi.JNIEnvironment;
import com.oracle.svm.jni.nativeapi.JNIFieldId;
import com.oracle.svm.jni.nativeapi.JNIObjectHandle;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import jdk.vm.ci.meta.ConstantPool;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.Signature;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.java.FrameStateBuilder;
import org.graalvm.compiler.nodes.InvokeWithExceptionNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.extended.RawLoadNode;
import org.graalvm.compiler.nodes.extended.RawStoreNode;
import org.graalvm.nativeimage.c.function.CEntryPoint;
import org.graalvm.word.LocationIdentity;

public final class JNIFieldAccessorMethod
extends JNIGeneratedMethod {
    private final JavaKind fieldKind;
    private final boolean isSetter;
    private final boolean isStatic;
    private final ResolvedJavaType declaringClass;
    private final ConstantPool constantPool;
    private final String name;
    private final Signature signature;

    public JNIFieldAccessorMethod(JavaKind fieldKind, boolean isSetter, boolean isStatic, ResolvedJavaType declaringClass, ConstantPool constantPool, MetaAccessProvider metaAccess) {
        if (!EnumSet.of(JavaKind.Object, new JavaKind[]{JavaKind.Boolean, JavaKind.Byte, JavaKind.Char, JavaKind.Short, JavaKind.Int, JavaKind.Long, JavaKind.Float, JavaKind.Double}).contains(fieldKind)) {
            throw VMError.shouldNotReachHere();
        }
        this.fieldKind = fieldKind;
        this.isSetter = isSetter;
        this.isStatic = isStatic;
        this.declaringClass = declaringClass;
        this.constantPool = constantPool;
        this.name = this.createName();
        this.signature = this.createSignature(metaAccess);
    }

    private String createName() {
        StringBuilder sb = new StringBuilder(32);
        if (this.isSetter) {
            sb.append("Set");
        } else {
            sb.append("Get");
        }
        if (this.isStatic) {
            sb.append("Static");
        }
        sb.append(this.fieldKind.name());
        sb.append("Field");
        return sb.toString();
    }

    private SimpleSignature createSignature(MetaAccessProvider metaAccess) {
        Class<JNIObjectHandle> valueClass = this.fieldKind.toJavaClass();
        if (this.fieldKind.isObject()) {
            valueClass = JNIObjectHandle.class;
        }
        ResolvedJavaType objectHandle = metaAccess.lookupJavaType(JNIObjectHandle.class);
        ArrayList<JavaType> args = new ArrayList<JavaType>();
        args.add((JavaType)metaAccess.lookupJavaType(JNIEnvironment.class));
        args.add((JavaType)objectHandle);
        args.add((JavaType)metaAccess.lookupJavaType(JNIFieldId.class));
        if (this.isSetter) {
            args.add((JavaType)metaAccess.lookupJavaType(valueClass));
        }
        ResolvedJavaType returnType = this.isSetter ? metaAccess.lookupJavaType(Void.TYPE) : metaAccess.lookupJavaType(valueClass);
        return new SimpleSignature(args, (JavaType)returnType);
    }

    public StructuredGraph buildGraph(DebugContext debug, ResolvedJavaMethod method, HostedProviders providers, GraphProvider.Purpose purpose) {
        ValueNode returnValue;
        InvokeWithExceptionNode object;
        JNIGraphKit kit = new JNIGraphKit(debug, providers, method);
        StructuredGraph graph = kit.getGraph();
        FrameStateBuilder state = new FrameStateBuilder(null, method, graph);
        state.initializeForMethodStart(null, true, providers.getGraphBuilderPlugins());
        ValueNode vmThread = kit.loadLocal(0, this.signature.getParameterKind(0));
        kit.append((ValueNode)CEntryPointEnterNode.enter(vmThread));
        List<ValueNode> arguments = kit.loadArguments(this.signature.toParameterTypes(null));
        if (this.isStatic) {
            object = this.fieldKind.isPrimitive() ? kit.getStaticPrimitiveFieldsArray() : kit.getStaticObjectFieldsArray();
        } else {
            ValueNode handle = arguments.get(1);
            object = kit.unboxHandle(handle);
        }
        ValueNode fieldId = arguments.get(2);
        InvokeWithExceptionNode offset = kit.getFieldOffsetFromId(fieldId);
        if (this.isSetter) {
            returnValue = null;
            ValueNode newValue = arguments.get(3);
            if (this.fieldKind.isObject()) {
                newValue = kit.unboxHandle(newValue);
            }
            kit.append((ValueNode)new RawStoreNode((ValueNode)object, (ValueNode)offset, newValue, this.fieldKind, LocationIdentity.ANY_LOCATION));
        } else {
            returnValue = kit.append((ValueNode)new RawLoadNode((ValueNode)object, (ValueNode)offset, this.fieldKind, LocationIdentity.ANY_LOCATION));
            if (this.fieldKind.isObject()) {
                returnValue = kit.boxObjectInLocalHandle(returnValue);
            }
        }
        kit.append((ValueNode)new CEntryPointLeaveNode(CEntryPointLeaveNode.LeaveAction.Leave));
        JavaKind returnKind = this.isSetter ? JavaKind.Void : this.fieldKind;
        kit.createReturn(returnValue, returnKind);
        assert (graph.verify());
        return graph;
    }

    public String getName() {
        return this.name;
    }

    public Signature getSignature() {
        return this.signature;
    }

    public ResolvedJavaType getDeclaringClass() {
        return this.declaringClass;
    }

    public ConstantPool getConstantPool() {
        return this.constantPool;
    }

    public CEntryPointData createEntryPointData() {
        return CEntryPointData.create(this, "", CEntryPointData.DEFAULT_NAME_TRANSFORMATION, "", CEntryPointOptions.NoPrologue.class, CEntryPointOptions.NoEpilogue.class, CEntryPoint.FatalExceptionHandler.class, CEntryPointOptions.Publish.NotPublished);
    }
}

