/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.javadoc;

import com.puppycrawl.tools.checkstyle.StatelessCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FileContents;
import com.puppycrawl.tools.checkstyle.utils.JavadocUtil;
import java.util.Optional;

@StatelessCheck
public class MissingJavadocPackageCheck
extends AbstractCheck {
    public static final String MSG_PKG_JAVADOC_MISSING = "package.javadoc.missing";

    @Override
    public int[] getDefaultTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getRequiredTokens() {
        return new int[]{16};
    }

    @Override
    public boolean isCommentNodesRequired() {
        return true;
    }

    @Override
    public void visitToken(DetailAST ast) {
        FileContents contents = this.getFileContents();
        if (contents.inPackageInfo() && !MissingJavadocPackageCheck.hasJavadoc(ast)) {
            this.log(ast.getLineNo(), MSG_PKG_JAVADOC_MISSING, new Object[0]);
        }
    }

    private static boolean hasJavadoc(DetailAST ast) {
        boolean hasBefore = MissingJavadocPackageCheck.isJavadocComment(ast.getPreviousSibling());
        boolean hasWithAnnotation = Optional.of(ast.getFirstChild()).map(DetailAST::getFirstChild).map(DetailAST::getFirstChild).map(MissingJavadocPackageCheck::isJavadocComment).orElse(false);
        return hasBefore || hasWithAnnotation;
    }

    private static boolean isJavadocComment(DetailAST ast) {
        return ast != null && ast.getType() == 145 && JavadocUtil.isJavadocComment(ast);
    }
}

